/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.exception.CustomException;
import com.uscale.common.utils.DateUtils;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.common.utils.file.FileUtils;
import com.uscale.common.utils.file.VoiceUtils;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.entity.TmRecordingConfig;
import com.uscale.system.entity.UmSipUserRecording;
import com.uscale.system.service.IUmSipUserRecordingService;
import com.uscale.system.service.TmRecordingConfigService;
import com.uscale.system.vo.UmSipUserRecordingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f55\u97f3"})
@RestController
@RequestMapping(value={"/self/sipUser/recording"})
public class UmSipUserRecordingController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmSipUserRecordingController.class);
    private final IUmSipUserRecordingService umSipUserRecordingService;
    private final TokenService tokenService;
    private final TmRecordingConfigService tmRecordingConfigService;

    @Autowired
    public UmSipUserRecordingController(IUmSipUserRecordingService umSipUserRecordingService, TokenService tokenService, TmRecordingConfigService tmRecordingConfigService) {
        this.umSipUserRecordingService = umSipUserRecordingService;
        this.tokenService = tokenService;
        this.tmRecordingConfigService = tmRecordingConfigService;
    }

    @ApiOperation(value="\u5f55\u97f3\u5217\u8868\u67e5\u8be2")
    @PreAuthorize(value="@ss.hasPermi('systemMng:recording:list')")
    @PostMapping(value={"/list/{page}/{size}"})
    public TableDataInfo list(HttpServletRequest request, @ApiParam(value="\u9875") @PathVariable Integer page, @ApiParam(value="\u6761\u6570") @PathVariable Integer size, @RequestBody UmSipUserRecordingVO recordingVO) {
        LOGGER.debug("\u67e5\u8be2\u5f55\u97f3\u5217\u8868\uff0cpageNum=[{}], pageSize=[{}]", (Object)page, (Object)size);
        Page pageData = new Page((long)page.intValue(), (long)size.intValue());
        LambdaQueryWrapper wrapper = this.buildEWrapper(request, recordingVO);
        return this.getDataTable((Page)this.umSipUserRecordingService.page((IPage)pageData, (Wrapper)wrapper));
    }

    private LambdaQueryWrapper buildEWrapper(HttpServletRequest request, UmSipUserRecordingVO recordingVO) {
        String calleeDeviceId;
        String searchNumber;
        boolean uscaleAdmin;
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Object[] recordingDate = recordingVO.getRecordingDate();
        String label = recordingVO.getLabel();
        String remark = recordingVO.getRemark();
        String channel = recordingVO.getChannel();
        String recordingTime = recordingVO.getRecordingTime();
        if (!ObjectUtils.isEmpty((Object[])recordingDate)) {
            wrapper.and(arg_0 -> UmSipUserRecordingController.lambda$buildEWrapper$0((Date[])recordingDate, arg_0));
        }
        if (StringUtils.isNotEmpty((String)label)) {
            wrapper.and(wra -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wra.like(UmSipUserRecording::getLabel, (Object)label);
            });
        }
        if (StringUtils.isNotEmpty((String)remark)) {
            wrapper.and(wra -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wra.like(UmSipUserRecording::getRemark, (Object)remark);
            });
        }
        if (StringUtils.isNotEmpty((String)channel)) {
            wrapper.and(wra -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wra.like(UmSipUserRecording::getChannel, (Object)channel);
            });
        }
        if (StringUtils.isNotEmpty((String)recordingTime) && !"00:00:00".equals(recordingTime)) {
            String[] split = recordingTime.split(":");
            int i = Integer.parseInt(split[0]) * 60 * 60 + Integer.parseInt(split[1]) * 60 + Integer.parseInt(split[2]);
            wrapper.and(wra -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wra.le(UmSipUserRecording::getRecordingTime, (Object)i)).isNotNull(UmSipUserRecording::getRecordingTime);
            });
        }
        if (!(uscaleAdmin = loginUser.getUser().isUscaleAdmin())) {
            wrapper.and(wra -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wra.eq(UmSipUserRecording::getOwnerNumber, (Object)loginUser.getUsername());
            });
        }
        if (StringUtils.isNotEmpty((String)(searchNumber = recordingVO.getSearchNumber()))) {
            wrapper.and(wra -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wra.eq(UmSipUserRecording::getDeviceId, (Object)searchNumber);
            });
        }
        if (StringUtils.isNotEmpty((String)(calleeDeviceId = recordingVO.getCalleeDeviceId()))) {
            wrapper.and(wra -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wra.eq(UmSipUserRecording::getCalleeDeviceId, (Object)calleeDeviceId);
            });
        }
        wrapper.orderByDesc(UmSipUserRecording::getRecordingDate);
        return wrapper;
    }

    @ApiOperation(value="\u5f55\u97f3\u5217\u8868\u5bfc\u51fa")
    @PostMapping(value={"/export"})
    @PreAuthorize(value="@ss.hasPermi('systemMng:recording:export')")
    public AjaxResult export(HttpServletRequest request, @RequestBody UmSipUserRecordingVO recordingVO) {
        LambdaQueryWrapper wrapper = this.buildEWrapper(request, recordingVO);
        List recordings = this.umSipUserRecordingService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)recordings)) {
            ExcelUtil excelUtil = new ExcelUtil(UmSipUserRecording.class);
            return excelUtil.exportExcel(recordings, DateUtils.dateTime());
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SipUserController.nodata.export", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5f55\u97f3\u5217\u8868\u4fe1\u606f\u4fee\u6539")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u5f55\u97f3\u5217\u8868", businessType=BusinessType.UPDATE)
    @PutMapping
    @PreAuthorize(value="@ss.hasPermi('systemMng:recording:edit')")
    public AjaxResult<Boolean> update(@RequestBody UmSipUserRecording recording) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(UmSipUserRecording::getId, (Object)recording.getId());
        updateWrapper.set(UmSipUserRecording::getLabel, (Object)recording.getLabel());
        updateWrapper.set(UmSipUserRecording::getRemark, (Object)recording.getRemark());
        return AjaxResult.success((Object)this.umSipUserRecordingService.update((Wrapper)updateWrapper));
    }

    @ApiOperation(value="\u5f55\u97f3\u5217\u8868\u4fe1\u606f\u8bfb\u53d6\u72b6\u6001\u4fee\u6539")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u5f55\u97f3\u5217\u8868", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updateRead"})
    @PreAuthorize(value="@ss.hasPermi('systemMng:recording:listen')")
    public AjaxResult<Boolean> updateReadStatus(@RequestBody UmSipUserRecordingVO recordingVO) {
        List ids = recordingVO.getIds();
        ArrayList<UmSipUserRecording> list = new ArrayList<UmSipUserRecording>();
        for (Long id : ids) {
            UmSipUserRecording recording = new UmSipUserRecording();
            recording.setId(id);
            recording.setIsRead(recordingVO.getIsRead());
            list.add(recording);
        }
        return AjaxResult.success((Object)this.umSipUserRecordingService.saveOrUpdateBatch(list));
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5f55\u97f3\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="@ss.hasPermi('systemMng:recording:query')")
    public AjaxResult<UmSipUserRecording> getRecordingById(@ApiParam(value="ID") @PathVariable Integer id) {
        return AjaxResult.success((Object)this.umSipUserRecordingService.getById((Serializable)id));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u97f3\u6587\u4ef6")
    @GetMapping(value={"/getRecordingFile/{id}"})
    public void getRecordingFile(@ApiParam(value="ID") @PathVariable Integer id, HttpServletRequest request, HttpServletResponse response) {
        UmSipUserRecording umSipUserRecording = (UmSipUserRecording)this.umSipUserRecordingService.getById((Serializable)id);
        VoiceUtils.play((String)umSipUserRecording.getRecordingFilePath(), (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5220\u9664\u5f55\u97f3\u4fe1\u606f\u53ca\u6587\u4ef6")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u5f55\u97f3\u5217\u8868", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    @PreAuthorize(value="@ss.hasPermi('systemMng:recording:remove')")
    public AjaxResult<Object> deleteRecord(@ApiParam(value="ID") @PathVariable Long[] ids) {
        this.umSipUserRecordingService.deleteRecord(Arrays.asList(ids));
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8bed\u97f3\u6587\u4ef6")
    @GetMapping(value={"/download/{id}"})
    public void download(@ApiParam(value="\u8bed\u97f3\u6587\u4ef6\u5e8f\u53f7") @PathVariable String id, HttpServletResponse response) throws IOException {
        UmSipUserRecording umSipUserRecording = (UmSipUserRecording)this.umSipUserRecordingService.getById((Serializable)((Object)id));
        if (ObjectUtils.isEmpty((Object)umSipUserRecording)) {
            throw new CustomException(MessageUtils.message((String)"recording.voice.no", (Object[])new Object[0]));
        }
        File file = new File(umSipUserRecording.getRecordingFilePath());
        if (!file.exists()) {
            throw new CustomException(MessageUtils.message((String)"recording.voice.no", (Object[])new Object[0]));
        }
        FileUtils.download((String)(umSipUserRecording.getRecordingFileName() + ".wav"), (String)umSipUserRecording.getRecordingFilePath(), (HttpServletResponse)response);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f55\u97f3\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/getTmRecordingConfig"})
    @PreAuthorize(value="@ss.hasPermi('systemMng:recording:query')")
    public AjaxResult<TmRecordingConfig> getTmRecordingConfig() {
        return AjaxResult.success((Object)this.tmRecordingConfigService.getTmRecordingConfig());
    }

    @ApiOperation(value="\u5f55\u97f3\u914d\u7f6e")
    @PostMapping(value={"/editTmRecordingConfig"})
    public AjaxResult editTmRecordingConfig(@RequestBody TmRecordingConfig tmRecordingConfig) {
        return this.toAjax(this.tmRecordingConfigService.editTmRecordingConfig(tmRecordingConfig));
    }

    private static /* synthetic */ void lambda$buildEWrapper$0(Date[] recordingDate, LambdaQueryWrapper wra) {
        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wra.between(UmSipUserRecording::getRecordingDate, (Object)recordingDate[0], (Object)recordingDate[1]);
    }
}

