/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.SsScheduleMeetingMember;
import com.uscale.system.service.ILocalNumberService;
import com.uscale.system.service.ISsScheduleMeetingMemberService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u5b9a\u5f0f\u4f1a\u8bae\u6210\u5458"})
@RestController
@RequestMapping(value={"/self/meeting/scheduleMember"})
public class SsScheduleMeetingMemberController
extends BaseController {
    private final ISsScheduleMeetingMemberService ssScheduleMeetingMemberService;
    private final ILocalNumberService iLocalNumberService;

    @Autowired
    public SsScheduleMeetingMemberController(ISsScheduleMeetingMemberService ssScheduleMeetingMemberService, ILocalNumberService iLocalNumberService) {
        this.ssScheduleMeetingMemberService = ssScheduleMeetingMemberService;
        this.iLocalNumberService = iLocalNumberService;
    }

    @ApiOperation(value="\u67e5\u8be2\u9884\u5b9a\u5f0f\u4f1a\u8bae\u6210\u5458")
    @GetMapping(value={"/{meetingId}"})
    public AjaxResult<List<SsScheduleMeetingMember>> querySsScheduleMeetingMember(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SsScheduleMeetingMember::getMeetingId, (Object)meetingId);
        return AjaxResult.success((Object)this.ssScheduleMeetingMemberService.list((Wrapper)wrapper));
    }

    @ApiOperation(value="\u6dfb\u52a0\u9884\u5b9a\u5f0f\u4f1a\u8bae\u6210\u5458")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae:\u4f1a\u8bae\u6210\u5458", businessType=BusinessType.INSERT)
    @PostMapping(value={"/{meetingId}"})
    public AjaxResult<Boolean> saveSsScheduleMeetingMember(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId, @RequestBody List<SsScheduleMeetingMember> list) {
        if (CollectionUtils.isEmpty(list)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SsScheduleMeetingMemberController.user.notExist", (Object[])new Object[0]));
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SsScheduleMeetingMember::getMeetingId, (Object)meetingId);
        this.ssScheduleMeetingMemberService.remove((Wrapper)wrapper);
        return AjaxResult.success((Object)this.ssScheduleMeetingMemberService.saveOrUpdateBatch(list));
    }

    @ApiOperation(value="\u5220\u9664\u9884\u5b9a\u5f0f\u4f1a\u8bae\u6210\u5458")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae:\u4f1a\u8bae\u6210\u5458", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{id}"})
    public AjaxResult<Boolean> deleteSsScheduleMeetingMember(@ApiParam(value="ID") @PathVariable(value="id") Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)this.ssScheduleMeetingMemberService.removeById((Serializable)id));
    }

    @ApiOperation(value="\u4f1a\u8bae\u5f00\u59cb\u540e\u67e5\u8be2\u4f1a\u8bae\u6210\u5458")
    @GetMapping(value={"/startedQuery/{meetingId}"})
    public AjaxResult<Object> startedQuerySsScheduleMeetingMember(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId) {
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4f1a\u8bae\u5f00\u59cb\u540e\u6dfb\u52a0\u9884\u5b9a\u5f0f\u4f1a\u8bae\u6210\u5458")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae:\u4f1a\u8bae\u6210\u5458", businessType=BusinessType.INSERT)
    @PostMapping(value={"/startedAdd/{meetingId}"})
    public AjaxResult<Object> startedAddSsScheduleMeetingMember(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId, @RequestBody List<SsScheduleMeetingMember> list) {
        if (CollectionUtils.isEmpty(list)) {
            return AjaxResult.error();
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4f1a\u8bae\u5f00\u59cb\u540e\u4fee\u6539\u4e0e\u4f1a\u6210\u5458\u6743\u9650")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae:\u4f1a\u8bae\u6210\u5458", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/startedModifyRight/{meetingId}"})
    public AjaxResult<Object> startedModifySsScheduleMeetingMemberRight(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId, @RequestBody SsScheduleMeetingMember member) {
        if (ObjectUtils.isEmpty((Object)member)) {
            return AjaxResult.error();
        }
        return AjaxResult.success();
    }
}

