/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.system.entity.SsScheduleMeeting;
import com.uscale.system.entity.SsScheduleMeetingMember;
import com.uscale.system.service.ISsScheduleMeetingMemberService;
import com.uscale.system.service.ISsScheduleMeetingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Api(tags={"\u81ea\u52a9\u670d\u52a1\u9884\u5b9a\u5f0f\u4f1a\u8bae"})
@RestController
@RequestMapping(value={"/self/meeting/schedule"})
public class SsScheduleMeetingController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Gson GSON = new Gson();
    private final JedisPool jedisPool;
    private final ISsScheduleMeetingService ssScheduleMeetingService;
    private final ISsScheduleMeetingMemberService ssScheduleMeetingMemberService;

    @Autowired
    public SsScheduleMeetingController(JedisPool jedisPool, ISsScheduleMeetingService ssScheduleMeetingService, ISsScheduleMeetingMemberService ssScheduleMeetingMemberService) {
        this.jedisPool = jedisPool;
        this.ssScheduleMeetingService = ssScheduleMeetingService;
        this.ssScheduleMeetingMemberService = ssScheduleMeetingMemberService;
    }

    @ApiOperation(value="\u67e5\u8be2\u9884\u8ba2\u5f0f\u4f1a\u8bae")
    @GetMapping(value={"/{meetingId}"})
    public AjaxResult<SsScheduleMeeting> getScheduleMeeting(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId) {
        if (ObjectUtils.isEmpty((Object)meetingId)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SsScheduleMeetingController.param.Illegal", (Object[])new Object[0]));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SsScheduleMeeting::getMeetingId, (Object)meetingId);
        SsScheduleMeeting scheduleMeeting = (SsScheduleMeeting)this.ssScheduleMeetingService.getOne((Wrapper)wrapper);
        if (ObjectUtils.isEmpty((Object)scheduleMeeting)) {
            this.LOGGER.error("\u67e5\u8be2\u9884\u8ba2\u5f0f\u4f1a\u8bae\uff0c\u4f1a\u8bae\u4e0d\u5b58\u5728\uff1ameetingId=[{}]", (Object)meetingId);
            return AjaxResult.error((String)MessageUtils.message((String)"SsScheduleMeetingController.not.exits", (Object[])new Object[0]));
        }
        return AjaxResult.success((Object)scheduleMeeting);
    }

    @ApiOperation(value="\u65b0\u589e\u9884\u8ba2\u5f0f\u4f1a\u8bae")
    @RepeatSubmit
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae", businessType=BusinessType.INSERT)
    @PostMapping(value={"/create"})
    public AjaxResult<SsScheduleMeeting> saveScheduleMeeting(@RequestBody SsScheduleMeeting scheduleMeeting) {
        String time = scheduleMeeting.getStartTime();
        this.LOGGER.debug("\u65b0\u589e\u9884\u5b9a\u5f0f\u4f1a\u8bae\uff0c\u83b7\u53d6\u5230\u53c2\u6570\uff1ascheduleMeeting=[{}]", (Object)GSON.toJson((Object)scheduleMeeting));
        int[] resourceLimitNum = new int[]{60, 120};
        AjaxResult ajaxResult = this.ssScheduleMeetingService.saveScheduleMeeting(scheduleMeeting, resourceLimitNum);
        if ((Integer)ajaxResult.get("code") == 200) {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                jedis.set(RedisKeyEnum.SCHEDULE_MEETING_ID.getKey() + scheduleMeeting.getMeetingId(), time);
            }
        }
        return ajaxResult;
    }

    @ApiOperation(value="\u66f4\u65b0\u9884\u8ba2\u5f0f\u4f1a\u8bae")
    @RepeatSubmit
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/update"})
    public AjaxResult<Object> updateScheduleMeeting(@RequestBody SsScheduleMeeting scheduleMeeting) {
        this.LOGGER.debug("\u65b0\u589e\u9884\u5b9a\u5f0f\u4f1a\u8bae\uff0c\u83b7\u53d6\u5230\u53c2\u6570\uff1ascheduleMeeting=[{}]", (Object)GSON.toJson((Object)scheduleMeeting));
        int[] resourceLimitNum = new int[]{60, 120};
        return this.ssScheduleMeetingService.updateScheduleMeeting(scheduleMeeting, resourceLimitNum);
    }

    @ApiOperation(value="\u5220\u9664\u9884\u5b9a\u5f0f\u4f1a\u8bae")
    @DeleteMapping(value={"/{id}"})
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae", businessType=BusinessType.DELETE)
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult<Boolean> removeScheduleMeeting(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="id") Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            return AjaxResult.error();
        }
        SsScheduleMeeting scheduleMeeting = (SsScheduleMeeting)this.ssScheduleMeetingService.getById((Serializable)id);
        if (ObjectUtils.isEmpty((Object)scheduleMeeting)) {
            return AjaxResult.error();
        }
        this.ssScheduleMeetingMemberService.deleteMeetingMember(scheduleMeeting.getMeetingId());
        this.ssScheduleMeetingService.deleteMeeting(scheduleMeeting.getMeetingId());
        return AjaxResult.success((Object)this.ssScheduleMeetingService.removeById((Serializable)id));
    }

    @ApiOperation(value="\u8fdb\u5165\u6b63\u5728\u8fdb\u884c\u7684\u9884\u5b9a\u5f0f\u4f1a\u8bae")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae(\u8fdb\u5165)", businessType=BusinessType.OTHER)
    @GetMapping(value={"/joinStartedScheduleMeeting/{meetingId}"})
    public AjaxResult<Map<String, Object>> joinStartedScheduleMeeting(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId) {
        if (ObjectUtils.isEmpty((Object)meetingId)) {
            return AjaxResult.error();
        }
        SsScheduleMeeting scheduleMeeting = this.ssScheduleMeetingService.getMeeting(meetingId);
        if (ObjectUtils.isEmpty((Object)scheduleMeeting)) {
            this.LOGGER.error("\u4f1a\u8bae\u4e0d\u5b58\u5728\uff1ameetingId=[{}]", (Object)meetingId);
            return AjaxResult.error();
        }
        String userNumber = SecurityUtils.getSortNumber();
        HashMap data = new HashMap();
        AjaxResult ajaxResult = AjaxResult.success(data);
        if (!userNumber.equals(scheduleMeeting.getScheduler())) {
            LambdaQueryWrapper memberWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)memberWrapper.select(new SFunction[]{SsScheduleMeetingMember::getIdentity}).eq(SsScheduleMeetingMember::getParticipantPhoneNumber, (Object)userNumber)).eq(SsScheduleMeetingMember::getMeetingId, (Object)meetingId);
            SsScheduleMeetingMember member = (SsScheduleMeetingMember)this.ssScheduleMeetingMemberService.getOne((Wrapper)memberWrapper);
            if (ObjectUtils.isEmpty((Object)member)) {
                this.LOGGER.error("\u8fdb\u5165\u4f1a\u8bae\uff0c\u5df2\u7ecf\u4e0d\u662f\u4e0e\u4f1a\u8005\u6210\u5458\uff0c\u8fdb\u5165\u5931\u8d25\uff1ameetingId=[{}], userNumber=[{}]", (Object)meetingId, (Object)userNumber);
                return AjaxResult.error();
            }
            ((Map)ajaxResult.data).put("identity", member.getIdentity());
        } else {
            ((Map)ajaxResult.data).put("identity", "scheduler");
        }
        ((Map)ajaxResult.data).put("meetingInfo", scheduleMeeting);
        return ajaxResult;
    }

    @ApiOperation(value="\u5173\u95ed\u4f1a\u8bae")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u9884\u8ba2\u5f0f\u4f1a\u8bae(\u5173\u95ed)", businessType=BusinessType.DELETE)
    @PostMapping(value={"/closeScheduleMeeting/{meetingId}"})
    @Transactional(rollbackFor={Exception.class})
    public AjaxResult<Object> closeScheduleMeeting(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId) {
        if (ObjectUtils.isEmpty((Object)meetingId)) {
            return AjaxResult.error();
        }
        SsScheduleMeeting scheduleMeeting = this.ssScheduleMeetingService.getMeeting(meetingId);
        if (ObjectUtils.isEmpty((Object)scheduleMeeting)) {
            return AjaxResult.error();
        }
        this.ssScheduleMeetingMemberService.deleteMeetingMember(meetingId);
        this.ssScheduleMeetingService.removeById((Serializable)scheduleMeeting.getId());
        return AjaxResult.success();
    }

    private int[] queryMeetingResourceLimit() {
        String totalPeople;
        String total;
        try (Jedis jedis = this.jedisPool.getResource();){
            total = jedis.get(RedisKeyEnum.TOTAL.getKey());
            totalPeople = jedis.get(RedisKeyEnum.TOTAL_PEOPLE.getKey());
        }
        return new int[]{Integer.parseInt(total), Integer.parseInt(totalPeople)};
    }
}

