/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.config.AmiConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.DialEvent;
import com.uscale.system.entity.InstantMeetingInfo;
import com.uscale.system.entity.LocalNumber;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.SsInstantMeetingAdmin;
import com.uscale.system.entity.SsInstantMeetingInfo;
import com.uscale.system.entity.SsInstantMeetingMember;
import com.uscale.system.entity.SsScheduleMeeting;
import com.uscale.system.entity.TmCalleePrefixConfiguration;
import com.uscale.system.enums.SsInstantMeetingInfoEnum;
import com.uscale.system.enums.SsInstantMeetingMemberEnum;
import com.uscale.system.service.ILocalNumberService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.ISsScheduleMeetingService;
import com.uscale.system.service.ITmCalleePrefixConfigurationService;
import com.uscale.system.tool.SeqIdUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ConfbridgeKickAction;
import org.asteriskjava.manager.action.ConfbridgeMuteAction;
import org.asteriskjava.manager.action.ConfbridgeUnmuteAction;
import org.asteriskjava.manager.action.HangupAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.OriginateAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Api(tags={"\u81ea\u52a9\u670d\u52a1\u7acb\u5373\u5f0f\u4f1a\u8bae"})
@RestController
@RequestMapping(value={"/self/meeting/instant"})
@PropertySource(value={"classpath:/conference.properties"}, encoding="utf-8")
public class SsInstantMeetingController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Gson GSON = new Gson();
    private static final String RESPONSE = "Success";
    private static final String MEETING = "MEETING";
    private static final String ADMIN = "TYPE_ADMIN";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String TOGGLE_MUTE = "toggle_mute";
    public static final String FROM_EXTEN_SIP = "from-exten-sip";
    public static final String DIALLOCAL_IGNORE = "DIALLOCAL_IGNORE";
    @Value(value="${instance.sound_muted}")
    private String soundMuted;
    @Value(value="${instance.sound_join}")
    private String soundJoin;
    @Value(value="${instance.sound_leave}")
    private String soundLeave;
    @Value(value="${instance.sound_unMuted}")
    private String soundUnMuted;
    @Value(value="${instance.sound_kicked}")
    private String soundKicked;
    @Value(value="${instance.max_members}")
    private String maxMembers;
    @Value(value="${instance.sound_locked}")
    private String soundLocked;
    @Value(value="${instance.mixing_interval}")
    private String mixingInterval;
    @Value(value="${instance.internal_sample_rate}")
    private String internalSampleRate;
    @Value(value="${instance.language}")
    private String Language;
    @Value(value="${instance.admin}")
    private String instanceAdmin;
    @Value(value="${instance.de_noise}")
    private String deNoise;
    @Value(value="${instance.announcement}")
    private String announcement;
    @Value(value="${instance.announce_only_user}")
    private String announceOnlyUser;
    @Value(value="${instance.start_muted}")
    private String startMuted;
    @Value(value="${instance.menu8}")
    private String menu8;
    @Value(value="${instance.menu7}")
    private String menu7;
    private final SeqIdUtil seqIdUtil;
    private final ISipUserService iSipUserService;
    private final ILocalNumberService iLocalNumberService;
    private final JedisPool jedisPool;
    private final ITmCalleePrefixConfigurationService iTmCalleePrefixConfigurationService;
    private static final String CONFERENCE = "conference";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String UTF_8 = "application/json;charset=utf8";
    private static final String SYSTEM_ERROR = "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
    @Autowired
    private ISsScheduleMeetingService ssScheduleMeetingService;

    @Autowired
    public SsInstantMeetingController(SeqIdUtil seqIdUtil, ISipUserService iSipUserService, ILocalNumberService iLocalNumberService, JedisPool jedisPool, ITmCalleePrefixConfigurationService iTmCalleePrefixConfigurationService, ISsScheduleMeetingService ssScheduleMeetingService) {
        this.seqIdUtil = seqIdUtil;
        this.iSipUserService = iSipUserService;
        this.iLocalNumberService = iLocalNumberService;
        this.jedisPool = jedisPool;
        this.iTmCalleePrefixConfigurationService = iTmCalleePrefixConfigurationService;
        this.ssScheduleMeetingService = ssScheduleMeetingService;
    }

    @ApiOperation(value="\u5f00\u542f\u7acb\u5373\u5f0f\u4f1a\u8bae\u4e4b\u524d\u6821\u9a8c\u7528\u6237\u6709\u6ca1\u6709\u6743\u9650")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae(\u6821\u9a8c\u6743\u9650)", businessType=BusinessType.OTHER)
    @GetMapping(value={"/checkPermission/{number}"})
    public AjaxResult<Object> checkPermission(@ApiParam(value="\u53f7\u7801") @PathVariable String number) {
        Boolean flag = false;
        if (ObjectUtils.isEmpty((Object)number)) {
            this.LOGGER.error("\u7acb\u5373\u5f0f\u4f1a\u8bae\u7528\u6237\u53f7\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.userPhone.isEmpty", (Object[])new Object[0]));
        }
        SipUser sipUser = this.iSipUserService.getSipUserByNumber(number);
        Object[] simpleBusiness = sipUser.getSimpleBusiness();
        if (ObjectUtils.isEmpty((Object[])simpleBusiness)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.noPermission", (Object[])new Object[0]));
        }
        for (Object business : simpleBusiness) {
            if (!SipUserBusinessEnum.SIMPLE_INSTANT_MEETING.getCode().equals(business)) continue;
            flag = true;
            break;
        }
        if (flag.booleanValue()) {
            return AjaxResult.success();
        }
        return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.noPermission", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5f00\u542f\u7acb\u5373\u5f0f\u4f1a\u8bae")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae(\u5f00\u542f)", businessType=BusinessType.INSERT)
    @PostMapping(value={"/use/{number}"})
    public AjaxResult<SsInstantMeetingInfo> instantMeeting(@ApiParam(value="\u53f7\u7801") @PathVariable String number) {
        String[] simpleBusiness;
        if (ObjectUtils.isEmpty((Object)number)) {
            this.LOGGER.error("\u7acb\u5373\u5f0f\u4f1a\u8bae\u7528\u6237\u53f7\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.userPhone.isEmpty", (Object[])new Object[0]));
        }
        SipUser sipUser = this.iSipUserService.getSipUserByNumber(number);
        for (String business : simpleBusiness = sipUser.getSimpleBusiness()) {
            if (!SipUserBusinessEnum.SIMPLE_INSTANT_MEETING.getCode().equals(business)) continue;
            SsInstantMeetingInfo ssInstantMeetingInfo = new SsInstantMeetingInfo();
            ssInstantMeetingInfo.setNumber(Long.valueOf(Long.parseLong(number)));
            ssInstantMeetingInfo.setSubject("Meeting");
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(TmCalleePrefixConfiguration::getCallProperty, (Object)"meetingCall");
            TmCalleePrefixConfiguration one = (TmCalleePrefixConfiguration)this.iTmCalleePrefixConfigurationService.getOne((Wrapper)lambdaQueryWrapper);
            if (ObjectUtils.isEmpty((Object)one)) {
                this.LOGGER.error("\u88ab\u53eb\u5b57\u51a0\u672a\u914d\u7f6e");
                return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.callee.prefix", (Object[])new Object[0]));
            }
            ssInstantMeetingInfo.setMeetingAccessCode(one.getPrefix());
            ssInstantMeetingInfo.setMeetingId(this.seqIdUtil.getNextMeetingId());
            ssInstantMeetingInfo.setMeetingStatus(SsInstantMeetingInfoEnum.MEETING_STATUS_ON.getName());
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(10, 1);
            ssInstantMeetingInfo.setStartTime(date);
            ssInstantMeetingInfo.setExplain(Integer.valueOf(0));
            ssInstantMeetingInfo.setEndTime(cal.getTime());
            ssInstantMeetingInfo.setTimeRemaining(Long.valueOf(cal.getTime().getTime()));
            ssInstantMeetingInfo.setOnGoingConferencePromptTone(SsInstantMeetingInfoEnum.ON_GOING_CONFERENCE_PROMPT_TONE_OFF.getName());
            ssInstantMeetingInfo.setAutomaticallyAddParticipant(SsInstantMeetingInfoEnum.AUTOMATICALLY_ADD_PARTICIPANT_ON.getName());
            this.startInstantMeeting(ssInstantMeetingInfo.getMeetingId(), number);
            try (Jedis jedis = this.jedisPool.getResource();){
                SsInstantMeetingAdmin admin = new SsInstantMeetingAdmin(number, number, ssInstantMeetingInfo.getMeetingId());
                jedis.set(RedisKeyEnum.CONFERENCE_ADMIN.getKey() + RedisKeyEnum.CONNECTOR.getKey() + ssInstantMeetingInfo.getMeetingId(), this.GSON.toJson((Object)admin));
                jedis.setex(RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + ssInstantMeetingInfo.getNumber() + RedisKeyEnum.CONNECTOR.getKey() + ssInstantMeetingInfo.getMeetingId(), 3660, this.GSON.toJson((Object)ssInstantMeetingInfo));
                SsInstantMeetingMember meetingMember = new SsInstantMeetingMember();
                meetingMember.setMemberStatus("0");
                meetingMember.setNumber(number);
                meetingMember.setParticipantPhoneNumber(number);
                meetingMember.setType(ADMIN);
                meetingMember.setMeetingStatusListen(Boolean.valueOf(true));
                meetingMember.setMeetingStatusSpeak(Boolean.valueOf(true));
                meetingMember.setKick(Boolean.valueOf(false));
                meetingMember.setChangePermissions(Boolean.valueOf(false));
                meetingMember.setListenIcon("el-icon-service");
                meetingMember.setSpeakIcon("el-icon-microphone");
                meetingMember.setMeetingId(ssInstantMeetingInfo.getMeetingId());
                LocalNumber localNumberByNumber = this.iLocalNumberService.getLocalNumberByNumber(ssInstantMeetingInfo.getNumber().toString());
                if (ObjectUtils.isEmpty((Object)localNumberByNumber)) {
                    this.LOGGER.error("\u7acb\u5373\u5f0f\u4f1a\u8bae\u53d1\u8d77\u4eba\u5728localNumber\u8868\u4e2d\u672a\u67e5\u5230");
                    AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.noPermission", (Object[])new Object[0]));
                }
                jedis.setex(RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + localNumberByNumber.getNumber() + RedisKeyEnum.CONNECTOR.getKey() + RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + ssInstantMeetingInfo.getNumber() + RedisKeyEnum.CONNECTOR.getKey() + ssInstantMeetingInfo.getMeetingId(), 60, this.GSON.toJson((Object)meetingMember));
                SsScheduleMeeting scheduleMeeting = new SsScheduleMeeting();
                scheduleMeeting.setMeetingId(ssInstantMeetingInfo.getMeetingId());
                scheduleMeeting.setMeetingStatus("1");
                StringBuffer guestPassword = new StringBuffer();
                StringBuffer moderatorPassword = new StringBuffer();
                Random random = new Random();
                for (int i = 0; i < 6; ++i) {
                    guestPassword.append(random.nextInt(10));
                    moderatorPassword.append(random.nextInt(10));
                }
                scheduleMeeting.setGuestPassword(guestPassword.toString());
                scheduleMeeting.setModeratorPassword(moderatorPassword.toString());
                scheduleMeeting.setAccessCode(ssInstantMeetingInfo.getMeetingAccessCode());
                scheduleMeeting.setSubject(ssInstantMeetingInfo.getSubject());
                this.ssScheduleMeetingService.save((Object)scheduleMeeting);
                ssInstantMeetingInfo.setGuestPassword(scheduleMeeting.getGuestPassword());
                ssInstantMeetingInfo.setModeratorPassword(scheduleMeeting.getModeratorPassword());
            }
            return AjaxResult.success((Object)ssInstantMeetingInfo);
        }
        return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.noPermission", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u521b\u5efa\u7acb\u5373\u5f0f\u4f1a\u8bae")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae(\u521b\u5efa)", businessType=BusinessType.INSERT)
    @GetMapping(value={"/getWindowCounts/{number}"})
    public AjaxResult<Integer> getWindowCounts(@ApiParam(value="\u53f7\u7801") @PathVariable String number) {
        int count;
        try (Jedis jedis = this.jedisPool.getResource();){
            Set jsonSet = jedis.keys(RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + number + "*");
            count = jsonSet.size();
        }
        return AjaxResult.success((Object)count);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u8d26\u53f7\u7684\u6240\u6709\u7acb\u5373\u5f0f\u4f1a\u8bae")
    @GetMapping(value={"/queryAll/{number}"})
    public AjaxResult<Set<SsInstantMeetingInfo>> queryAllInstantMeetingByNumber(@ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable String number) {
        if (StringUtils.isEmpty((Object)number)) {
            this.LOGGER.error("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7cfb\u7edf\u7684\u7528\u6237");
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.login", (Object[])new Object[0]));
        }
        LocalNumber localNumberByNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        if (ObjectUtils.isEmpty((Object)localNumberByNumber)) {
            this.LOGGER.error("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7cfb\u7edf\u7684\u7528\u6237");
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.login", (Object[])new Object[0]));
        }
        HashSet<SsInstantMeetingInfo> set = new HashSet<SsInstantMeetingInfo>();
        try (Jedis jedis = this.jedisPool.getResource();){
            ArrayList keys1;
            Set keys = jedis.keys(RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + localNumberByNumber.getDeviceNumber() + "*");
            if (!ObjectUtils.isEmpty((Object)keys)) {
                for (String key : keys) {
                    SsInstantMeetingInfo ssInstantMeetingInfo = (SsInstantMeetingInfo)this.GSON.fromJson(jedis.get(key.split("::", 3)[2]), SsInstantMeetingInfo.class);
                    if (ObjectUtils.isEmpty((Object)ssInstantMeetingInfo)) continue;
                    set.add(ssInstantMeetingInfo);
                }
            }
            if (!CollectionUtils.isEmpty(keys1 = new ArrayList(jedis.keys(RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + number + "*")))) {
                for (String s : keys1) {
                    SsInstantMeetingInfo instantMeetingInfo = (SsInstantMeetingInfo)this.GSON.fromJson(jedis.get(s), SsInstantMeetingInfo.class);
                    if (ObjectUtils.isEmpty((Object)instantMeetingInfo)) continue;
                    set.add(instantMeetingInfo);
                }
            }
        }
        return AjaxResult.success(set);
    }

    @ApiOperation(value="\u7ed3\u675f\u7acb\u5373\u5f0f\u4f1a\u8bae")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae(\u7ed3\u675f)", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/delete/{meetingId}/{number}"})
    public AjaxResult<Object> deleteInstantMeeting(@ApiParam(value="\u4f1a\u8baeid") @PathVariable String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable String number) {
        this.endConference(meetingId);
        return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.meeting.end", (Object[])new Object[0]));
    }

    private void sendPost(String hostAndPort, String business, String params) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(hostAndPort + business + "?" + params);
        httpPost.setHeader(CONTENT_TYPE, UTF_8);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        try {
            httpClient.close();
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="\u6839\u636e\u4f1a\u8baeid\u5728redis\u4e2d\u67e5\u8be2\u7acb\u5373\u5f0f\u4f1a\u8bae")
    @GetMapping(value={"/queryRedis/{meetingId}/{number}"})
    public AjaxResult<Boolean> queryRedis(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable(value="number") String number) {
        HashSet keys;
        if (ObjectUtils.isEmpty((Object)meetingId) || ObjectUtils.isEmpty((Object)number)) {
            return AjaxResult.error();
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            keys = new HashSet(jedis.keys(RedisKeyEnum.INSTANT_MEETING.getKey() + "*" + meetingId));
        }
        return AjaxResult.success((Object)(!CollectionUtils.isEmpty(keys) ? 1 : 0));
    }

    @ApiOperation(value="\u8fdb\u5165\u6b63\u5728\u8fdb\u884c\u7684\u7acb\u5373\u5f0f\u4f1a\u8bae")
    @GetMapping(value={"/joinInstantScheduleMeeting/{meetingId}/{number}"})
    public AjaxResult<SsInstantMeetingInfo> joinInstantScheduleMeeting(@ApiParam(value="\u4f1a\u8baeID") @PathVariable(value="meetingId") String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable(value="number") String number) {
        if (StringUtils.isEmpty((Object)number)) {
            this.LOGGER.error("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7cfb\u7edf\u7684\u7528\u6237");
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.login", (Object[])new Object[0]));
        }
        LocalNumber localNumberByNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        if (ObjectUtils.isEmpty((Object)localNumberByNumber)) {
            this.LOGGER.error("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7cfb\u7edf\u7684\u7528\u6237");
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.login", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)meetingId) && ObjectUtils.isEmpty((Object)number)) {
            return AjaxResult.error();
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            Set keys = jedis.keys(RedisKeyEnum.INSTANT_MEETING.getKey() + "*" + meetingId);
            ArrayList list = new ArrayList(keys);
            if (list.size() == 1) {
                SsScheduleMeeting ssScheduleMeeting;
                SsInstantMeetingInfo ssInstantMeetingInfo = (SsInstantMeetingInfo)this.GSON.fromJson(jedis.get((String)list.get(0)), SsInstantMeetingInfo.class);
                String initiator = ((String)list.get(0)).split("::")[1];
                if (ObjectUtils.isEmpty((Object)ssInstantMeetingInfo)) {
                    this.LOGGER.error("\u4f1a\u8bae\u4e0d\u5b58\u5728\uff1ameetingId=[{}]", (Object)meetingId);
                    AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.meeting.notExist", (Object[])new Object[]{meetingId}));
                    return ajaxResult;
                }
                String conferenceKey = (String)list.get(0);
                String memberKey = RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + localNumberByNumber.getDeviceNumber() + RedisKeyEnum.CONNECTOR.getKey() + conferenceKey;
                SsInstantMeetingMember ssInstantMeetingMember = (SsInstantMeetingMember)this.GSON.fromJson(jedis.get(memberKey), SsInstantMeetingMember.class);
                if (number.equals(initiator)) {
                    ssInstantMeetingInfo.setExplain(Integer.valueOf(0));
                    SsScheduleMeeting ssScheduleMeeting2 = this.ssScheduleMeetingService.getMeeting(ssInstantMeetingInfo.getMeetingId());
                    if (!ObjectUtils.isEmpty((Object)ssScheduleMeeting2)) {
                        ssInstantMeetingInfo.setModeratorPassword(ssScheduleMeeting2.getModeratorPassword());
                        ssInstantMeetingInfo.setGuestPassword(ssScheduleMeeting2.getGuestPassword());
                    }
                    AjaxResult ajaxResult = AjaxResult.success((Object)ssInstantMeetingInfo);
                    return ajaxResult;
                }
                if (ObjectUtils.isEmpty((Object)ssInstantMeetingMember)) {
                    this.LOGGER.error("\u4f1a\u8bdd\u7ed3\u675f\uff0c\u767b\u5f55\u7528\u6237\u4e0d\u5b58\u5728=[{}]", (Object)memberKey);
                    AjaxResult ssScheduleMeeting2 = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.meeting.session", (Object[])new Object[0]));
                    return ssScheduleMeeting2;
                }
                if (ssInstantMeetingMember.getType().equals(SsInstantMeetingMemberEnum.TYPE_ADMIN)) {
                    ssInstantMeetingInfo.setExplain(Integer.valueOf(0));
                } else {
                    ssInstantMeetingInfo.setExplain(Integer.valueOf(1));
                }
                if (ssInstantMeetingInfo.getType() == 1 && !ObjectUtils.isEmpty((Object)(ssScheduleMeeting = this.ssScheduleMeetingService.getMeeting(ssInstantMeetingInfo.getMeetingId())))) {
                    ssInstantMeetingInfo.setModeratorPassword(ssScheduleMeeting.getModeratorPassword());
                    ssInstantMeetingInfo.setGuestPassword(ssScheduleMeeting.getGuestPassword());
                }
                AjaxResult ajaxResult = AjaxResult.success((Object)ssInstantMeetingInfo);
                return ajaxResult;
            }
        }
        this.LOGGER.debug("\u4f1a\u8bae\u53f7\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.meeting.wrong", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u589e\u52a0\u4e0e\u4f1a\u8005")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae:\u4e0e\u4f1a\u8005", businessType=BusinessType.INSERT)
    @PostMapping(value={"/addMember/{meetingId}/{number}"})
    public AjaxResult<Object> addMember(@ApiParam(value="\u4f1a\u8baeid") @PathVariable(value="meetingId") String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable(value="number") String number, SsInstantMeetingMember ... memberArray) {
        if (ObjectUtils.isEmpty((Object)meetingId)) {
            this.LOGGER.error("\u672a\u63a5\u6536\u5230\u4f1a\u8baeid:[{}]", (Object)meetingId);
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
        }
        ArrayList<String> numbers = new ArrayList<String>();
        for (SsInstantMeetingMember item : memberArray) {
            numbers.add(item.getParticipantPhoneNumber());
        }
        if (CollectionUtils.isEmpty(numbers)) {
            this.LOGGER.error("\u6ca1\u6709\u63a5\u6536\u5230\u8981\u6dfb\u52a0\u5230\u4f1a\u8bae\u7684\u6210\u5458");
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
        }
        String key = RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + number + RedisKeyEnum.CONNECTOR.getKey() + meetingId;
        try (Jedis jedis = this.jedisPool.getResource();){
            SsInstantMeetingAdmin ssInstantMeetingAdmin = (SsInstantMeetingAdmin)this.GSON.fromJson(jedis.get(RedisKeyEnum.CONFERENCE_ADMIN.getKey() + RedisKeyEnum.CONNECTOR.getKey() + meetingId), SsInstantMeetingAdmin.class);
            HashSet<String> adminSet = new HashSet<String>();
            if (ObjectUtils.isEmpty((Object)ssInstantMeetingAdmin)) {
                this.LOGGER.debug("\u4f1a\u8bae\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            adminSet.add(ssInstantMeetingAdmin.getAdmin());
            adminSet.add(ssInstantMeetingAdmin.getInitiator());
            for (SsInstantMeetingMember item : memberArray) {
                String memberKey = RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + item.getParticipantPhoneNumber() + RedisKeyEnum.CONNECTOR.getKey() + key;
                if (!CollectionUtils.isEmpty(adminSet) && adminSet.contains(item.getParticipantPhoneNumber())) {
                    item.setType(ADMIN);
                }
                if (item.getType().equals(SsInstantMeetingMemberEnum.TYPE_ADMIN)) {
                    item.setChangePermissions(Boolean.valueOf(false));
                    item.setKick(Boolean.valueOf(false));
                } else {
                    item.setChangePermissions(Boolean.valueOf(true));
                    item.setKick(Boolean.valueOf(true));
                }
                item.setMemberStatus(MessageUtils.message((String)"SsInstantMeetingController.user.inviting", (Object[])new Object[0]));
                item.setNumber(number);
                item.setMeetingId(meetingId);
                jedis.setex(memberKey, 60, this.GSON.toJson((Object)item));
                this.joinInstantMeeting(meetingId, item.getMeetingStatusSpeak(), item.getParticipantPhoneNumber(), item.getNumber(), item.getType());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0e\u4f1a\u8005")
    @GetMapping(value={"/queryMeetingMember/{meetingId}/{number}"})
    public AjaxResult<List<SsInstantMeetingMember>> queryMeetingMember(@ApiParam(value="\u4f1a\u8baeid") @PathVariable(value="meetingId") String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable(value="number") String number) {
        String initiator;
        HashSet<String> adminList;
        ArrayList<SsInstantMeetingMember> instantMeetingMember;
        block37: {
            if (ObjectUtils.isEmpty((Object)meetingId)) {
                return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object)number)) {
                return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.login", (Object[])new Object[0]));
            }
            instantMeetingMember = new ArrayList<SsInstantMeetingMember>();
            adminList = new HashSet<String>();
            try (Jedis jedis = this.jedisPool.getResource();){
                SsInstantMeetingAdmin ssInstantMeetingAdmin = (SsInstantMeetingAdmin)this.GSON.fromJson(jedis.get(RedisKeyEnum.CONFERENCE_ADMIN.getKey() + RedisKeyEnum.CONNECTOR.getKey() + meetingId), SsInstantMeetingAdmin.class);
                if (ObjectUtils.isEmpty((Object)ssInstantMeetingAdmin)) {
                    AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                    return ajaxResult;
                }
                initiator = ssInstantMeetingAdmin.getInitiator();
                String admin = ssInstantMeetingAdmin.getAdmin();
                if (ObjectUtils.isEmpty((Object)initiator) && ObjectUtils.isEmpty((Object)admin)) {
                    AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                    return ajaxResult;
                }
                adminList.add(initiator);
                adminList.add(admin);
                ArrayList memberKeys = new ArrayList(jedis.keys(RedisKeyEnum.MEMBER.getKey() + "*" + meetingId));
                if (!CollectionUtils.isEmpty(memberKeys)) {
                    for (String json : memberKeys) {
                        SsInstantMeetingMember ssInstantMeetingMember = (SsInstantMeetingMember)this.GSON.fromJson(jedis.get(json), SsInstantMeetingMember.class);
                        instantMeetingMember.add(ssInstantMeetingMember);
                    }
                    break block37;
                }
                AjaxResult ajaxResult = AjaxResult.success(instantMeetingMember);
                return ajaxResult;
            }
        }
        if (!CollectionUtils.isEmpty(adminList)) {
            if (!number.equals(initiator) && !adminList.contains(number)) {
                for (SsInstantMeetingMember item : instantMeetingMember) {
                    item.setChangePermissions(Boolean.valueOf(false));
                    item.setKick(Boolean.valueOf(false));
                }
                this.LOGGER.debug("\u767b\u5f55\u7528\u6237\u662f\u666e\u901a\u4eba");
                return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.ordinary.auth", (Object[])new Object[0]), instantMeetingMember);
            }
            if (!number.equals(initiator) && adminList.contains(number)) {
                for (SsInstantMeetingMember item : instantMeetingMember) {
                    if (number.equals(item.getParticipantPhoneNumber())) {
                        item.setChangePermissions(Boolean.valueOf(false));
                        item.setKick(Boolean.valueOf(false));
                        continue;
                    }
                    item.setChangePermissions(Boolean.valueOf(true));
                    item.setKick(Boolean.valueOf(true));
                }
                this.LOGGER.debug("\u767b\u5f55\u7528\u6237\u662f\u7b2c\u4e8c\u4e3b\u5e2d");
                return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.sSeat.auth", (Object[])new Object[0]), instantMeetingMember);
            }
            if (number.equals(initiator) && adminList.size() == 1) {
                for (SsInstantMeetingMember item : instantMeetingMember) {
                    if (number.equals(item.getParticipantPhoneNumber())) {
                        item.setChangePermissions(Boolean.valueOf(false));
                        item.setKick(Boolean.valueOf(false));
                        continue;
                    }
                    item.setChangePermissions(Boolean.valueOf(true));
                    item.setKick(Boolean.valueOf(true));
                }
                this.LOGGER.debug("\u767b\u5f55\u7528\u6237\u662f\u7b2c\u4e00\u4e3b\u5e2d\u3010\u672a\u8f6c\u79fb\u7ed9\u522b\u4eba\u4e3b\u5e2d\u3011");
                return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.fSeat.auth", (Object[])new Object[0]), instantMeetingMember);
            }
            if (number.equals(initiator) && adminList.size() > 1) {
                for (SsInstantMeetingMember item : instantMeetingMember) {
                    item.setChangePermissions(Boolean.valueOf(false));
                    item.setKick(Boolean.valueOf(true));
                    if (!number.equals(item.getParticipantPhoneNumber())) continue;
                    item.setKick(Boolean.valueOf(false));
                }
                this.LOGGER.debug("\u767b\u5f55\u7528\u6237\u662f\u7b2c\u4e00\u4e3b\u5e2d\u3010\u8f6c\u79fb\u7ed9\u522b\u4eba\u4e3b\u5e2d\u3011");
                return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.transfer.auth", (Object[])new Object[0]), instantMeetingMember);
            }
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u7acb\u5373\u5f0f\u4f1a\u8bae\u6210\u5458")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae:\u4e0e\u4f1a\u8005", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/removeMemberByNumber/{meetingId}/{number}/{participantPhoneNumber}"})
    public AjaxResult<Object> removeMemberByNumber(@ApiParam(value="\u4f1a\u8baeid") @PathVariable String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable String number, @ApiParam(value="\u4e0e\u4f1a\u8005\u53f7\u7801") @PathVariable String participantPhoneNumber) {
        String kickUser;
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            String key = RedisKeyEnum.JOIN_INSTANT.getKey() + RedisKeyEnum.CONNECTOR.getKey() + meetingId + RedisKeyEnum.CONNECTOR.getKey() + participantPhoneNumber;
            kickUser = jedis.get(key);
        }
        if (ObjectUtils.isEmpty((Object)kickUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.meeting.notJoin", (Object[])new Object[0]));
        }
        InstantMeetingInfo instantMeetingInfo = (InstantMeetingInfo)this.GSON.fromJson(kickUser, InstantMeetingInfo.class);
        this.kick(meetingId, instantMeetingInfo.getChannel(), number, participantPhoneNumber);
        return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.meeting.delete", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u4fee\u6539\u4e0e\u4f1a\u8005\u53ef\u8bf4\u4e0e\u4e0d\u53ef\u8bf4\u72b6\u6001")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae:\u8bf4\u72b6\u6001", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updateSpeakStatus/{meetingId}/{number}"})
    public AjaxResult<Object> updateSpeakStatus(@ApiParam(value="\u4f1a\u8baeid") @PathVariable String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable String number, @ApiParam(value="\u4e0e\u4f1a\u8005\u4fe1\u606f") @RequestBody SsInstantMeetingMember memberInfo) {
        if (!ObjectUtils.isEmpty((Object)memberInfo)) {
            String key = RedisKeyEnum.INSTANT_MEETING.getKey() + "*" + meetingId;
            try (Jedis jedis = this.jedisPool.getResource();){
                ArrayList keys = new ArrayList(jedis.keys(RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + memberInfo.getParticipantPhoneNumber() + RedisKeyEnum.CONNECTOR.getKey() + key));
                if (keys.size() == 1) {
                    jedis.set((String)keys.get(0), this.GSON.toJson((Object)memberInfo));
                    if (memberInfo.getMeetingStatusSpeak().booleanValue()) {
                        this.muteOrUnmute(meetingId, memberInfo, "unmute");
                    } else {
                        this.muteOrUnmute(meetingId, memberInfo, "mute");
                    }
                }
            }
            return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.userSay.success", (Object[])new Object[0]));
        }
        return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.userSay.fail", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u4fee\u6539\u4e0e\u4f1a\u8005\u53ef\u542c\u4e0e\u4e0d\u53ef\u542c\u72b6\u6001")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae:\u542c\u72b6\u6001", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updateListenStatus/{meetingId}/{number}"})
    public AjaxResult<Object> updateListenStatus(@ApiParam(value="\u4f1a\u8baeid") @PathVariable String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable String number, @ApiParam(value="\u4e0e\u4f1a\u8005\u4fe1\u606f") @RequestBody SsInstantMeetingMember memberInfo) {
        if (!ObjectUtils.isEmpty((Object)memberInfo)) {
            String key = RedisKeyEnum.INSTANT_MEETING.getKey() + "*" + meetingId;
            try (Jedis jedis = this.jedisPool.getResource();){
                ArrayList keys = new ArrayList(jedis.keys(RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + memberInfo.getParticipantPhoneNumber() + RedisKeyEnum.CONNECTOR.getKey() + key));
                if (keys.size() == 1) {
                    jedis.set((String)keys.get(0), this.GSON.toJson((Object)memberInfo));
                    this.LOGGER.debug("GSON.toJson(memberInfo)================[{}]", (Object)this.GSON.toJson((Object)memberInfo));
                }
            }
            return AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.userAudible.success", (Object[])new Object[0]));
        }
        return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.userAudible.fail", (Object[])new Object[0]));
    }

    private void muteOrUnmute(String meetingId, SsInstantMeetingMember memberInfo, String muteOrUnmute) {
        if (!ObjectUtils.isEmpty((Object)memberInfo)) {
            String muteUser;
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                String key = RedisKeyEnum.JOIN_INSTANT.getKey() + RedisKeyEnum.CONNECTOR.getKey() + meetingId + RedisKeyEnum.CONNECTOR.getKey() + memberInfo.getParticipantPhoneNumber();
                muteUser = jedis.get(key);
            }
            InstantMeetingInfo instantMeetingInfo = (InstantMeetingInfo)this.GSON.fromJson(muteUser, InstantMeetingInfo.class);
            if (!ObjectUtils.isEmpty((Object)instantMeetingInfo)) {
                if ("mute".equals(muteOrUnmute)) {
                    this.mute(meetingId, instantMeetingInfo.getChannel());
                } else {
                    this.unmute(meetingId, instantMeetingInfo.getChannel());
                }
            }
        }
    }

    @ApiOperation(value="\u8f6c\u79fb\u4e3b\u5e2d\u6743\u9650")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae:\u8f6c\u79fb\u4e3b\u5e2d\u6743\u9650", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changePermissions/{meetingId}/{transferPermissions}/{receivePermissions}"})
    public AjaxResult<Object> changePermissions(@ApiParam(value="\u4f1a\u8baeid") @PathVariable String meetingId, @ApiParam(value="\u5f53\u524d\u8d26\u53f7") @PathVariable String transferPermissions, @ApiParam(value="\u4e0e\u4f1a\u8005\u53f7\u7801") @PathVariable String receivePermissions) {
        String initiator;
        block17: {
            LocalNumber localNumberByNumber = this.iLocalNumberService.getLocalNumberByNumber(receivePermissions);
            if (ObjectUtils.isEmpty((Object)localNumberByNumber)) {
                return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.user.outer", (Object[])new Object[0]));
            }
            try (Jedis jedis = this.jedisPool.getResource();){
                ArrayList list = new ArrayList(jedis.keys(RedisKeyEnum.INSTANT_MEETING.getKey() + "*" + meetingId));
                if (list.size() == 1) {
                    initiator = ((String)list.get(0)).split("::")[1];
                    break block17;
                }
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
        }
        if (!ObjectUtils.isEmpty((Object)initiator)) {
            return this.change(receivePermissions, meetingId, transferPermissions, initiator);
        }
        return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.meeting.transfer", (Object[])new Object[0]));
    }

    private AjaxResult change(String receivePermissions, String meetingId, String transferPermissions, String initiator) {
        String receiveKey = RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + receivePermissions + RedisKeyEnum.CONNECTOR.getKey() + RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + initiator + RedisKeyEnum.CONNECTOR.getKey() + meetingId;
        String transferKey = RedisKeyEnum.MEMBER.getKey() + RedisKeyEnum.CONNECTOR.getKey() + transferPermissions + RedisKeyEnum.CONNECTOR.getKey() + RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + initiator + RedisKeyEnum.CONNECTOR.getKey() + meetingId;
        try (Jedis jedis = this.jedisPool.getResource();){
            SsInstantMeetingMember receiveMember = (SsInstantMeetingMember)this.GSON.fromJson(jedis.get(receiveKey), SsInstantMeetingMember.class);
            SsInstantMeetingMember transferMember = (SsInstantMeetingMember)this.GSON.fromJson(jedis.get(transferKey), SsInstantMeetingMember.class);
            if (!ObjectUtils.isEmpty((Object)receiveMember) && !ObjectUtils.isEmpty((Object)transferMember)) {
                receiveMember.setType(ADMIN);
                receiveMember.setChangePermissions(Boolean.valueOf(false));
                transferMember.setType("TYPE_GUEST");
                transferMember.setChangePermissions(Boolean.valueOf(true));
                if (initiator.equals(transferPermissions)) {
                    transferMember.setType(ADMIN);
                }
                jedis.set(receiveKey, this.GSON.toJson((Object)receiveMember));
                jedis.set(transferKey, this.GSON.toJson((Object)transferMember));
                SsInstantMeetingAdmin ssInstantMeetingAdmin = new SsInstantMeetingAdmin(initiator, receivePermissions, meetingId);
                jedis.set(RedisKeyEnum.CONFERENCE_ADMIN.getKey() + RedisKeyEnum.CONNECTOR.getKey() + meetingId, this.GSON.toJson((Object)ssInstantMeetingAdmin));
                AjaxResult ajaxResult = AjaxResult.success((String)MessageUtils.message((String)"SsInstantMeetingController.transfer.success", (Object[])new Object[0]));
                return ajaxResult;
            }
            AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.transfer.fail", (Object[])new Object[0]));
            return ajaxResult;
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u7684\u53d1\u8d77\u8005")
    @GetMapping(value={"/queryMeetingStarter/{meetingId}"})
    public AjaxResult<Object> queryMeetingStarter(@ApiParam(value="\u4f1a\u8baeid") @PathVariable String meetingId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            ArrayList list = new ArrayList(jedis.keys(RedisKeyEnum.INSTANT_MEETING.getKey() + "*" + meetingId));
            if (!CollectionUtils.isEmpty(list)) {
                String s = ((String)list.get(0)).split("::")[1];
                AjaxResult ajaxResult = AjaxResult.success((Object)s);
                return ajaxResult;
            }
        }
        return AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u7684\u53d1\u8d77\u8005\u548c\u4e3b\u5e2d")
    @GetMapping(value={"/queryMeetingStarterAndAdmin/{meetingId}"})
    public AjaxResult<List<String>> queryMeetingStarterAndAdmin(@ApiParam(value="\u4f1a\u8baeid") @PathVariable String meetingId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String admin = jedis.get(RedisKeyEnum.CONFERENCE_ADMIN.getKey() + RedisKeyEnum.CONNECTOR.getKey() + meetingId);
            if (ObjectUtils.isEmpty((Object)admin)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            SsInstantMeetingAdmin ssInstantMeetingAdmin = (SsInstantMeetingAdmin)this.GSON.fromJson(admin, SsInstantMeetingAdmin.class);
            if (ObjectUtils.isEmpty((Object)ssInstantMeetingAdmin)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(ssInstantMeetingAdmin.getAdmin());
            list.add(ssInstantMeetingAdmin.getInitiator());
            AjaxResult ajaxResult = AjaxResult.success(list);
            return ajaxResult;
        }
    }

    @ApiOperation(value="\u91cd\u8bbe\u4f1a\u8bae\u65f6\u95f4")
    @Log(title="\u81ea\u52a9\u670d\u52a1\u7acb:\u7acb\u5373\u5f0f\u4f1a\u8bae:\u91cd\u8bbe\u4f1a\u8bae\u65f6\u95f4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/resetTime/{meetingId}"})
    public AjaxResult<Object> resetTime(@ApiParam(value="\u53f7\u7801") @PathVariable String meetingId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            ArrayList jsonSet = new ArrayList(jedis.keys(RedisKeyEnum.INSTANT_MEETING.getKey() + "*" + RedisKeyEnum.CONNECTOR.getKey() + meetingId));
            if (CollectionUtils.isEmpty(jsonSet) && jsonSet.size() != 1) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            SsInstantMeetingInfo ssInstantMeetingInfo = (SsInstantMeetingInfo)this.GSON.fromJson(jedis.get((String)jsonSet.get(0)), SsInstantMeetingInfo.class);
            if (ObjectUtils.isEmpty((Object)ssInstantMeetingInfo)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SsInstantMeetingController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(ssInstantMeetingInfo.getEndTime());
            cal.add(10, 1);
            ssInstantMeetingInfo.setEndTime(cal.getTime());
            ssInstantMeetingInfo.setTimeRemaining(Long.valueOf(cal.getTime().getTime()));
            jedis.setex(RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + ssInstantMeetingInfo.getNumber() + RedisKeyEnum.CONNECTOR.getKey() + ssInstantMeetingInfo.getMeetingId(), 3600, this.GSON.toJson((Object)ssInstantMeetingInfo));
        }
        return AjaxResult.success();
    }

    private void startInstantMeeting(String conference, String number) {
        block16: {
            OriginateAction originateAction = new OriginateAction();
            originateAction.setVariable(this.soundMuted, "g-mute-set");
            originateAction.setVariable(this.soundUnMuted, "g-mute-canceled");
            originateAction.setVariable(this.soundJoin, "confbridge-join");
            originateAction.setVariable(this.soundLeave, "confbridge-leave");
            originateAction.setVariable(this.maxMembers, "60");
            originateAction.setVariable(this.mixingInterval, "10");
            originateAction.setVariable(this.internalSampleRate, "auto");
            Locale locale = Locale.getDefault();
            originateAction.setVariable(this.Language, locale.getCountry().toLowerCase());
            originateAction.setVariable(this.soundLocked, "g_locked_conference_cannot_be_invited");
            originateAction.setVariable(this.announceOnlyUser, NO);
            originateAction.setVariable(this.deNoise, YES);
            originateAction.setVariable(this.instanceAdmin, YES);
            originateAction.setVariable(this.announcement, "g-join-conference");
            originateAction.setVariable(this.menu8, TOGGLE_MUTE);
            originateAction.setVariable(this.menu7, TOGGLE_MUTE);
            originateAction.setChannel("Local/" + number + "@" + FROM_EXTEN_SIP);
            originateAction.setApplication("ConfBridge");
            originateAction.setData(conference);
            originateAction.setCallerId(number + " <" + number + ">");
            originateAction.setAccount(this.iLocalNumberService.getLocalNumberByNumber(number).getDeviceNumber());
            originateAction.setAsync(Boolean.valueOf(true));
            originateAction.setTimeout(Long.valueOf(60000L));
            originateAction.setVariable(DIALLOCAL_IGNORE, "all");
            originateAction.setVariable(MEETING, String.valueOf(1));
            ManagerConnection managerConnection = AmiConfig.getConnection();
            try {
                ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)originateAction, 60000L);
                this.LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
                if (RESPONSE.equals(managerResponse.getResponse())) {
                    try (Jedis jedis = this.jedisPool.getResource();){
                        ArrayList<String> conferenceChannel = new ArrayList<String>();
                        conferenceChannel.add(originateAction.getChannel());
                        jedis.select(1);
                        jedis.set(RedisKeyEnum.CONFERENCE_CHANNEL.getKey() + conference, this.GSON.toJson(conferenceChannel));
                    }
                    this.LOGGER.debug("\u4f1a\u8bae\u53d1\u8d77\u6210\u529f\uff1a[{}]", (Object)managerResponse.getResponse());
                    break block16;
                }
                this.LOGGER.error("ami\u8c03\u7528\u5931\u8d25\uff1a[{}]", (Object)managerResponse.getMessage());
            }
            catch (IOException | TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    private void joinInstantMeeting(String conference, Boolean meetingStatusSpeak, String participantPhoneNumber, String number, String type) {
        OriginateAction originateAction = new OriginateAction();
        originateAction.setVariable(this.soundMuted, "g-mute-set");
        originateAction.setVariable(this.soundUnMuted, "g-mute-canceled");
        originateAction.setVariable(this.soundJoin, "confbridge-join");
        originateAction.setVariable(this.soundLeave, "confbridge-leave");
        Locale locale = Locale.getDefault();
        originateAction.setVariable(this.Language, locale.getCountry().toLowerCase());
        originateAction.setVariable(this.announceOnlyUser, NO);
        originateAction.setVariable(this.deNoise, NO);
        originateAction.setVariable(this.announcement, "g-join-conference");
        originateAction.setVariable(this.menu8, TOGGLE_MUTE);
        originateAction.setVariable(this.menu7, TOGGLE_MUTE);
        if (meetingStatusSpeak.booleanValue()) {
            originateAction.setVariable(this.startMuted, NO);
        } else {
            originateAction.setVariable(this.startMuted, YES);
        }
        if (ADMIN.equals(type)) {
            originateAction.setVariable(this.instanceAdmin, YES);
        } else {
            originateAction.setVariable(this.instanceAdmin, NO);
        }
        originateAction.setChannel("Local/" + participantPhoneNumber + "@" + FROM_EXTEN_SIP);
        originateAction.setApplication("ConfBridge");
        originateAction.setData(conference);
        originateAction.setAccount(this.iLocalNumberService.getLocalNumberByNumber(number).getDeviceNumber());
        originateAction.setCallerId(number + " <" + number + ">");
        originateAction.setAsync(Boolean.valueOf(true));
        originateAction.setTimeout(Long.valueOf(60000L));
        originateAction.setVariable(MEETING, String.valueOf(1));
        ManagerConnection managerConnection = AmiConfig.getConnection();
        try {
            ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)originateAction, 60000L);
            this.LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
            if (RESPONSE.equals(managerResponse.getResponse())) {
                this.LOGGER.debug("\u4e0e\u4f1a\u8005\u52a0\u5165\u6210\u529f\uff1a{}", (Object)managerResponse.getResponse());
                try (Jedis jedis = this.jedisPool.getResource();){
                    String key = RedisKeyEnum.CONFERENCE_CHANNEL.getKey() + conference;
                    jedis.select(1);
                    String json = jedis.get(key);
                    ArrayList<String> conferenceChannel = (ArrayList<String>)this.GSON.fromJson(json, new /* Unavailable Anonymous Inner Class!! */.getType());
                    if (CollectionUtils.isEmpty((Collection)conferenceChannel)) {
                        conferenceChannel = new ArrayList<String>();
                    }
                    conferenceChannel.add(originateAction.getChannel());
                    jedis.set(key, this.GSON.toJson(conferenceChannel));
                }
            } else {
                this.LOGGER.error("ami\u8c03\u7528\u5931\u8d25\uff1a[{}]", (Object)managerResponse.getMessage());
            }
            this.LOGGER.debug("\u7acb\u5373\u5f0f\u4f1a\u8bae\u5df2\u5f00\u542f:[{}]", (Object)conference);
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private void kick(String conference, String channel, String participantPhoneNumber, String number) {
        ConfbridgeKickAction confbridgeKickAction = new ConfbridgeKickAction(conference, channel);
        ManagerConnection managerConnection = AmiConfig.getConnection();
        try {
            ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)confbridgeKickAction, 60000L);
            if (RESPONSE.equals(managerResponse.getResponse())) {
                this.LOGGER.debug("\u4f1a\u8bae\u4e2d\u8e22\u6389\u6210\u5458:[{}]", (Object)participantPhoneNumber);
            }
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private void mute(String conference, String channel) {
        ConfbridgeMuteAction confbridgeMuteAction = new ConfbridgeMuteAction(conference, channel);
        ManagerConnection managerConnection = AmiConfig.getConnection();
        try {
            ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)confbridgeMuteAction, 60000L);
            this.LOGGER.debug("\u4f1a\u8bae\u4e2d\u9759\u97f3\u6210\u5458:[{}]", (Object)channel);
            if (!RESPONSE.equals(managerResponse.getResponse())) {
                this.LOGGER.error("\u9759\u97f3\u5931\u8d25");
            }
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private void unmute(String conference, String channel) {
        ConfbridgeUnmuteAction confbridgeUnmuteAction = new ConfbridgeUnmuteAction(conference, channel);
        ManagerConnection managerConnection = AmiConfig.getConnection();
        try {
            ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)confbridgeUnmuteAction, 60000L);
            this.LOGGER.debug("\u4f1a\u8bae\u4e2d\u53d6\u6d88\u9759\u97f3\u6210\u5458:[{}]", (Object)channel);
            if (!RESPONSE.equals(managerResponse.getResponse())) {
                this.LOGGER.error("\u53d6\u6d88\u9759\u97f3\u5931\u8d25");
            }
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    private void endConference(String conference) {
        ManagerConnection managerConnection = AmiConfig.getConnection();
        ConfbridgeKickAction confBridgeKickAction = new ConfbridgeKickAction(conference, "all");
        try {
            ManagerResponse managerResponse1 = managerConnection.sendAction((ManagerAction)confBridgeKickAction, 60000L);
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                String json = jedis.get(RedisKeyEnum.CONFERENCE_CHANNEL.getKey() + conference);
                List conferenceChannels = (List)this.GSON.fromJson(json, new /* Unavailable Anonymous Inner Class!! */.getType());
                ArrayList keys = new ArrayList(jedis.keys(RedisKeyEnum.CHANNEL_LOCAL.getKey()));
                ArrayList<String> channelList = new ArrayList<String>();
                ArrayList<String> realChannels = new ArrayList<String>();
                ArrayList<String> hangupChannels = new ArrayList<String>();
                for (String k : keys) {
                    DialEvent dialEvent = (DialEvent)this.GSON.fromJson(jedis.get(k), DialEvent.class);
                    channelList.add(dialEvent.getDestination().substring(0, dialEvent.getDestination().lastIndexOf("-")));
                    realChannels.add(dialEvent.getDestination());
                }
                if (!CollectionUtils.isEmpty((Collection)conferenceChannels)) {
                    conferenceChannels.retainAll(channelList);
                    if (!CollectionUtils.isEmpty((Collection)conferenceChannels)) {
                        block14: for (String conferenceChannel : conferenceChannels) {
                            for (String realChannel : realChannels) {
                                if (!conferenceChannel.equals(realChannel.substring(0, realChannel.lastIndexOf("-")))) continue;
                                hangupChannels.add(realChannel);
                                continue block14;
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty(hangupChannels)) {
                        for (String hangupChannel : hangupChannels) {
                            HangupAction hangupAction = new HangupAction(hangupChannel);
                            try {
                                ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)hangupAction, 60000L);
                                this.LOGGER.debug("{}", (Object)managerResponse);
                                if (RESPONSE.equals(managerResponse.getResponse())) {
                                    this.LOGGER.debug("\u5173\u95ed\u4f1a\u8bae\uff0c\u505c\u6389\u6240\u6709\u6b63\u5728\u632f\u94c3\u7684\u901a\u9053{}", (Object)hangupChannel);
                                    continue;
                                }
                                this.LOGGER.debug("\u4f1a\u8bae\u4e2d,\u672a\u80fd\u5173\u95ed\u6b63\u5728\u632f\u94c3\u7684\u901a\u9053\u6709{}", (Object)hangupChannel);
                            }
                            catch (IOException | TimeoutException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                jedis.del(RedisKeyEnum.CONFERENCE_CHANNEL.getKey() + conference);
                jedis.select(0);
                SsInstantMeetingAdmin admin = (SsInstantMeetingAdmin)this.GSON.fromJson(jedis.get(RedisKeyEnum.CONFERENCE_ADMIN.getKey() + RedisKeyEnum.CONNECTOR.getKey() + conference), SsInstantMeetingAdmin.class);
                jedis.del(RedisKeyEnum.INSTANT_MEETING.getKey() + RedisKeyEnum.CONNECTOR.getKey() + admin.getInitiator() + RedisKeyEnum.CONNECTOR.getKey() + conference);
                jedis.del(conference);
            }
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
        this.LOGGER.debug("\u7ed3\u675f\u4f1a\u8bae:[{}]", (Object)conference);
    }
}

