/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.action.BlindTransferAction;
import com.uscale.common.action.CancelAtxferAction;
import com.uscale.common.annotation.Log;
import com.uscale.common.config.AmiConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.AmiUtil;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.system.entity.BridgeEnterEvent;
import com.uscale.system.entity.GsSoftConsoleGroupMember;
import com.uscale.system.entity.License;
import com.uscale.system.entity.LocalNumber;
import com.uscale.system.entity.QueueCallerJoinEvent;
import com.uscale.system.entity.QueueMembers;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.SoftConsoleGroupPause;
import com.uscale.system.entity.SsTelephoneBook;
import com.uscale.system.enums.ExtensionStateEnum;
import com.uscale.system.model.softConsole.CdrRecordQuery;
import com.uscale.system.service.ICdrService;
import com.uscale.system.service.IGsSoftConsoleGroupMemberService;
import com.uscale.system.service.ILocalNumberService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.ITmCalleePrefixConfigurationService;
import com.uscale.system.service.QueueMembersService;
import com.uscale.system.service.SsOperatorServiceCountService;
import com.uscale.system.service.SsTelephoneBookService;
import com.uscale.system.tool.FormatStateUtils;
import com.uscale.system.tool.LicenseUtils;
import com.uscale.system.tool.excel.BusClick;
import com.uscale.system.vo.CdrRecord;
import com.uscale.system.vo.OperatorVo;
import com.uscale.system.vo.SoftConsoleMemberStatusVO;
import com.uscale.system.vo.SoftNumberVO;
import com.uscale.system.vo.SsOperatorServiceCountVo;
import com.uscale.system.vo.SsTelephoneBookVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletResponse;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.AbstractManagerAction;
import org.asteriskjava.manager.action.AtxferAction;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.HangupAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.OriginateAction;
import org.asteriskjava.manager.action.QueueChangePriorityCallerAction;
import org.asteriskjava.manager.action.QueuePauseAction;
import org.asteriskjava.manager.action.RedirectAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.params.SetParams;

@Api(tags={"\u8bdd\u52a1\u53f0"})
@RestController
@RequestMapping(value={"/self/console"})
public class SoftConsoleController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftConsoleController.class);
    private static final String SYSTEM_ERROR = "\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
    private static final String NOT_IN_ANY_GROUP = "\u5f53\u524d\u7528\u6237\u4e0d\u5728\u4efb\u4f55\u4e00\u4e2a\u8bdd\u52a1\u53f0\u7ec4\u4e2d";
    private static final String CONSOLE_GROUP = "consoleGroup:";
    private static final String FROM_EXTEN_SIP = "from-exten-sip";
    private static final Integer PRIORITY = 1;
    private final JedisPool jedisPool;
    private static final Gson GSON = new Gson();
    private final SsTelephoneBookService ssTelephoneBookService;
    private final ILocalNumberService iLocalNumberService;
    private final SsOperatorServiceCountService ssOperatorServiceCountService;
    private final IGsSoftConsoleGroupMemberService gsSoftConsoleGroupMemberService;
    private final QueueMembersService queueMembersService;
    private final ISipUserService sipUserService;
    private final ICdrService cdrService;
    private final ITmCalleePrefixConfigurationService iTmCalleePrefixConfigurationService;
    private static final String RESPONSE = "Success";
    private static final String MANAGER_RESPONSE = "managerResponse:";
    private static final String CALLERID_NAME = "CALLERID(name)";

    @Autowired
    public SoftConsoleController(JedisPool jedisPool, SsTelephoneBookService ssTelephoneBookService, ILocalNumberService iLocalNumberService, SsOperatorServiceCountService ssOperatorServiceCountService, IGsSoftConsoleGroupMemberService gsSoftConsoleGroupMemberService, QueueMembersService queueMembersService, ISipUserService sipUserService, ICdrService cdrService, ITmCalleePrefixConfigurationService iTmCalleePrefixConfigurationService) {
        this.jedisPool = jedisPool;
        this.ssTelephoneBookService = ssTelephoneBookService;
        this.iLocalNumberService = iLocalNumberService;
        this.ssOperatorServiceCountService = ssOperatorServiceCountService;
        this.gsSoftConsoleGroupMemberService = gsSoftConsoleGroupMemberService;
        this.queueMembersService = queueMembersService;
        this.sipUserService = sipUserService;
        this.cdrService = cdrService;
        this.iTmCalleePrefixConfigurationService = iTmCalleePrefixConfigurationService;
    }

    @ApiOperation(value="\u67e5\u53f7\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/checkNumberPageList"})
    public AjaxResult<Page<SsTelephoneBookVo>> checkNumberPageList(@ApiParam(value="\u9875\u6761\u6570") @RequestParam Integer pageNum, @ApiParam(value="\u9875\u6570") @RequestParam Integer pageSize, @ApiParam(value="\u53f7\u7801") @RequestParam String phone, @RequestParam String address) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page result = this.ssTelephoneBookService.checkNumberPageList(page, phone, address);
        return AjaxResult.success((Object)result);
    }

    @ApiOperation(value="\u53f7\u7801\u7ba1\u7406\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/numberManagerPageList"})
    public AjaxResult<Page<SsTelephoneBookVo>> numberManagerPageList(@ApiParam(value="\u9875\u6761\u6570") @RequestParam Integer pageNum, @ApiParam(value="\u9875\u6570") @RequestParam Integer pageSize, @ApiParam(value="\u540d\u79f0\u7d22\u5f15") @RequestParam String nameIndex, @ApiParam(value="\u5730\u5740\u7d22\u5f15") @RequestParam String addressIndex, @ApiParam(value="\u7535\u8bdd") @RequestParam String phone) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page result = this.ssTelephoneBookService.numberManagerPageList(page, nameIndex, addressIndex, phone);
        if (!ObjectUtils.isEmpty((Object)result.getRecords())) {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                for (SsTelephoneBookVo item : result.getRecords()) {
                    item.setStatus(jedis.get(RedisKeyEnum.EXTENSION_STATE.getKey() + item.getDeviceId()));
                }
            }
        }
        return AjaxResult.success((Object)result);
    }

    @ApiOperation(value="\u65b0\u589e\u53f7\u7801")
    @Log(title="\u8bdd\u52a1\u53f0:\u53f7\u7801\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping(value={"/numberManagerInsert"})
    public AjaxResult<Object> numberManagerInsert(@RequestBody SsTelephoneBook ssTelephoneBook) {
        this.ssTelephoneBookService.insertSelective(ssTelephoneBook);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u53f7\u7801")
    @Log(title="\u8bdd\u52a1\u53f0:\u53f7\u7801\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/numberManagerUpdate"})
    public AjaxResult<Object> numberManagerUpdate(@RequestBody SsTelephoneBook ssTelephoneBook) {
        this.ssTelephoneBookService.updateByPrimaryKeySelective(ssTelephoneBook);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u53f7\u7801", notes="\u6839\u636eID\u5220\u9664\u53f7\u7801")
    @Log(title="\u8bdd\u52a1\u53f0:\u53f7\u7801\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/numberManagerDelete/{id}"})
    public AjaxResult<Object> numberManagerUpdate(@PathVariable Integer id) {
        this.ssTelephoneBookService.deleteByPrimaryKey(Long.valueOf(id.intValue()));
        return AjaxResult.success();
    }

    @ApiOperation(value="\u8bdd\u52a1\u5458\u670d\u52a1\u7edf\u8ba1\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/operatorServicePageList"})
    public AjaxResult<Page<SsOperatorServiceCountVo>> operatorServicePageList(@ApiParam(value="\u9875\u6761\u6570") @RequestParam Integer pageNum, @ApiParam(value="\u9875\u6570") @RequestParam Integer pageSize, @ApiParam(value="\u5f00\u59cb\u65f6\u95f4") @RequestParam(required=false) String startTime, @ApiParam(value="\u7ed3\u675f\u65f6\u95f4") @RequestParam(required=false) String endTime) {
        if (ObjectUtils.isEmpty((Object)startTime)) {
            startTime = null;
        }
        if (ObjectUtils.isEmpty((Object)endTime)) {
            endTime = null;
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page result = this.ssOperatorServiceCountService.operatorServicePageList(page, startTime, endTime);
        return AjaxResult.success((Object)result);
    }

    @ApiOperation(value="\u901a\u8bdd\u8bb0\u5f55\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/callRecordPageList"})
    public AjaxResult<Page<CdrRecord>> callRecordPageList(@RequestBody CdrRecordQuery query) {
        Page page = new Page((long)query.getPageNum().intValue(), (long)query.getPageSize().intValue());
        Page result = this.cdrService.cdrPageList(page, query);
        return AjaxResult.success((Object)result);
    }

    @ApiOperation(value="\u8bdd\u52a1\u53f0\u6210\u5458(\u4f11\u606f\u4e0e\u5de5\u4f5c)")
    @Log(title="\u8bdd\u52a1\u53f0:\u8bdd\u52a1\u53f0\u6210\u5458(\u4f11\u606f\u4e0e\u5de5\u4f5c)", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/pausedOrUnPaused/{iface}/{paused}"})
    public AjaxResult<Object> startInstantMeeting(@ApiParam(value="\u901a\u9053") @PathVariable String iface, @ApiParam(value="\u4f11\u606f\u4e0e\u5de5\u4f5c") @PathVariable Boolean paused) {
        ArrayList<SoftConsoleGroupPause> params = new ArrayList<SoftConsoleGroupPause>();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(LocalNumber::getNumber, (Object)iface);
        LocalNumber one = (LocalNumber)this.iLocalNumberService.getOne((Wrapper)lambdaQueryWrapper);
        if (ObjectUtils.isEmpty((Object)one)) {
            LOGGER.error("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u8bdd\u52a1\u5458\u7684\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.not.operatorInfo", (Object[])new Object[0]));
        }
        iface = one.getDeviceProtocol() + "/" + one.getDeviceNumber();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(GsSoftConsoleGroupMember::getMemberNumber, (Object)one.getAccountcode());
        List softConsoleGroupMember = this.gsSoftConsoleGroupMemberService.list((Wrapper)queryWrapper);
        for (GsSoftConsoleGroupMember item : softConsoleGroupMember) {
            String queue = CONSOLE_GROUP + item.getGroupNumber();
            SoftConsoleGroupPause softConsoleGroupPause = new SoftConsoleGroupPause(iface, paused, queue);
            params.add(softConsoleGroupPause);
        }
        try {
            for (SoftConsoleGroupPause softConsoleGroupPause : params) {
                QueuePauseAction queuePauseAction = new QueuePauseAction(softConsoleGroupPause.getIface(), softConsoleGroupPause.getQueue(), softConsoleGroupPause.getPaused());
                ManagerConnection managerConnection = AmiConfig.getConnection();
                ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)queuePauseAction, 60000L);
                LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
                if (RESPONSE.equals(managerResponse.getResponse())) {
                    LOGGER.debug("\u8bdd\u52a1\u5458\u9009\u62e9\u4f11\u606f\uff08true\uff09\u6216\u8005\u5de5\u4f5c\uff08false\uff09\uff1a[{}]---[{}]", (Object)softConsoleGroupPause.getQueue(), (Object)softConsoleGroupPause.getPaused());
                    continue;
                }
                CommandAction commandAction = new CommandAction();
                commandAction.setCommand("queue show");
                AmiUtil.getManagerConnection((AbstractManagerAction)commandAction);
                QueuePauseAction queuePause = new QueuePauseAction(softConsoleGroupPause.getIface(), softConsoleGroupPause.getQueue(), softConsoleGroupPause.getPaused());
                AmiUtil.getManagerConnection((AbstractManagerAction)queuePause);
                return AjaxResult.success();
            }
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operator.register", (Object[])new Object[0]));
        }
        LOGGER.debug("\u8bdd\u52a1\u5458\u5207\u6362\u72b6\u6001\u6210\u529f");
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4e3b\u53eb\u6392\u5e8f")
    @PostMapping(value={"/changePriorityCaller/{queue}/{caller}"})
    public AjaxResult<Object> changePriorityCaller(@ApiParam(value="\u8bdd\u52a1\u53f0\u53f7") @PathVariable String queue, @ApiParam(value="\u4e3b\u53eb\u53f7\u7801") @PathVariable String caller) {
        List joinEvent = null;
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList list = new ArrayList(jedis.keys(queue));
            if (CollectionUtils.isEmpty(list)) {
                AjaxResult ajaxResult = AjaxResult.success();
                return ajaxResult;
            }
            for (String key : list) {
                String json = jedis.get(key);
                joinEvent = (List)GSON.fromJson(json, new /* Unavailable Anonymous Inner Class!! */.getType());
            }
            if (joinEvent != null) {
                for (QueueCallerJoinEvent item : joinEvent) {
                    if (!item.getCallerIdNum().equals(caller)) continue;
                    caller = item.getChannel();
                    int now = joinEvent.indexOf(item);
                    Collections.swap(joinEvent, now, 0);
                    break;
                }
                jedis.set(queue, GSON.toJson((Object)joinEvent));
            }
        }
        try {
            QueueChangePriorityCallerAction queueChangePriorityCallerAction = new QueueChangePriorityCallerAction(queue, caller, Integer.valueOf(1));
            ManagerConnection managerConnection = AmiConfig.getConnection();
            ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)queueChangePriorityCallerAction, 60000L);
            LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
            if (RESPONSE.equals(managerResponse.getResponse())) {
                LOGGER.debug("\u8bbe\u7f6e\u8bdd\u52a1\u53f0\u4e3b\u53eb\u4f18\u5148\u7ea7\u4e3a\u7b2c\u4e00\uff0c\u6267\u884c\u7ed3\u679c=[{}]", (Object)managerResponse.getResponse());
            } else {
                LOGGER.error("\u8bbe\u7f6e\u8bdd\u52a1\u53f0\u4e3b\u53eb\u4f18\u5148\u7ea7\u4e3a\u7b2c\u4e00\uff0c\u6267\u884c\u7ed3\u679c:[{}]", (Object)managerResponse.getMessage());
            }
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.calling.order", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u83b7\u53d6\u8bdd\u52a1\u5458\u72b6\u6001")
    @GetMapping(value={"/getOperatorState/{number}"})
    public AjaxResult<OperatorVo> getOperatorState(@ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String number) {
        OperatorVo operatorVo = new OperatorVo();
        operatorVo.setWorkId(number);
        operatorVo.setSeatNumber(number);
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            String state = jedis.get(RedisKeyEnum.EXTENSION_STATE.getKey() + number);
            if (StringUtils.isEmpty((Object)state)) {
                LOGGER.error("\u672a\u80fd\u4eceredis\u4e2d\u83b7\u53d6\u767b\u5f55\u8bdd\u52a1\u53f0\u7684\u4eba\u7684\u72b6\u6001\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5redis\u662f\u5426\u542f\u52a8");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            state = FormatStateUtils.formatState((String)state);
            operatorVo.setState(state);
            if (state.equals(ExtensionStateEnum.IN_USE.getName())) {
                ArrayList list = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + number + "*"));
                for (String s : list) {
                    long currentTimeMillis;
                    long subTime;
                    BridgeEnterEvent bridge = (BridgeEnterEvent)GSON.fromJson(jedis.get(s), BridgeEnterEvent.class);
                    String status = jedis.get(RedisKeyEnum.EXTENSION_STATE.getKey() + bridge.getConnectedLineNum());
                    if (ExtensionStateEnum.HOLD.getCode().equals(status)) continue;
                    operatorVo.setOtherNumber(bridge.getConnectedLineNum());
                    Date dateReceived = bridge.getDateReceived();
                    if (!StringUtils.isEmpty((Object)dateReceived) && (subTime = (currentTimeMillis = System.currentTimeMillis()) - dateReceived.getTime()) > 0L) {
                        long seconds = Math.round(subTime / 1000L);
                        long minutes = Math.round(seconds / 60L);
                        if (minutes > 0L) {
                            seconds -= minutes * 60L;
                        }
                        operatorVo.setSeconds(seconds);
                        operatorVo.setMinutes(minutes);
                    }
                    operatorVo.setDateReceived(dateReceived);
                }
            }
        }
        jedis = this.jedisPool.getResource();
        var4_4 = null;
        try {
            jedis.select(1);
            String SOFT_CONSOLE_KEY = RedisKeyEnum.SOFT_CONSOLE.getKey() + number;
            jedis.set(SOFT_CONSOLE_KEY, number);
            jedis.expire(SOFT_CONSOLE_KEY, 10);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (jedis != null) {
                if (var4_4 != null) {
                    try {
                        jedis.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    jedis.close();
                }
            }
        }
        return AjaxResult.success((Object)operatorVo);
    }

    @ApiOperation(value="\u5bfc\u51fa\u8bdd\u52a1\u5458")
    @GetMapping(value={"/exportExcel"})
    public AjaxResult<Object> exportExcel(@ApiParam(value="\u9875\u6761\u6570") @RequestParam Integer pageNum, @ApiParam(value="\u9875\u6570") @RequestParam Integer pageSize, @ApiParam(value="\u5f00\u59cb\u65f6\u95f4") @RequestParam String startTime, @ApiParam(value="\u7ed3\u675f\u65f6\u95f4") @RequestParam String endTime, HttpServletResponse response) {
        ArrayList<BusClick> resultList = new ArrayList<BusClick>();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page result = this.ssOperatorServiceCountService.operatorServicePageList(page, startTime, endTime);
        if (result.getRecords() != null && !result.getRecords().isEmpty()) {
            for (SsOperatorServiceCountVo ssOperatorServiceCountVo : result.getRecords()) {
                BusClick busClick = new BusClick();
                busClick.setPhone(ssOperatorServiceCountVo.getPhone());
                busClick.setServicesNum(ssOperatorServiceCountVo.getServicesNum());
                busClick.setNotAnsweredNum(ssOperatorServiceCountVo.getNotAnsweredNum());
                busClick.setRingDuration(ssOperatorServiceCountVo.getRingDuration());
                busClick.setAvgServiceDuration(ssOperatorServiceCountVo.getAvgServiceDuration());
                busClick.setAvgRingDuration(ssOperatorServiceCountVo.getAvgRingDuration());
                resultList.add(busClick);
            }
            ExcelUtil excelUtil = new ExcelUtil(BusClick.class);
            return excelUtil.exportExcel(resultList, MessageUtils.message((String)"SoftConsoleController.service.statistics", (Object[])new Object[0]));
        }
        return null;
    }

    @ApiOperation(value="\u67e5\u8be2\u8bdd\u52a1\u53f0\u6210\u5458\u662f\u5426\u5728\u4f11\u606f")
    @GetMapping(value={"/queryMemberStatus/{number}"})
    public AjaxResult<Object> queryMemberStatus(@ApiParam(value="\u53f7\u7801") @PathVariable String number) {
        LocalNumber localNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(QueueMembers::getInter, (Object)(localNumber.getDeviceProtocol() + "/" + localNumber.getDeviceNumber()));
        List one = this.queueMembersService.list((Wrapper)lambdaQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)one)) {
            return AjaxResult.success((String)this.formatStatusForMember(((QueueMembers)one.get(0)).getPaused()));
        }
        LOGGER.error("\u672a\u627e\u5230\u767b\u5f55\u8bdd\u52a1\u53f0\u7cfb\u7edf\u7684\u7528\u6237\u4fe1\u606f");
        return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
    }

    private String formatStatusForMember(Integer state) {
        if (state == 0) {
            return "\u4f11\u606f";
        }
        return "\u5de5\u4f5c";
    }

    @ApiOperation(value="\u83b7\u53d6\u8bdd\u52a1\u5458\u72b6\u6001")
    @GetMapping(value={"/queryStatus/{number}"})
    public AjaxResult<Object> queryStatus(@ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String number) {
        LocalNumber localNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        if (localNumber != null) {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                String state = jedis.get(RedisKeyEnum.EXTENSION_STATE.getKey() + localNumber.getAccountcode());
                AjaxResult ajaxResult = AjaxResult.success((String)state);
                return ajaxResult;
            }
        }
        LOGGER.error("\u5728redis\u4e2d\uff0c\u672a\u627e\u5230\u5206\u673a\u72b6\u6001");
        return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u68c0\u9a8c\u662f\u5426\u4e3a\u73ed\u957f\u5e2d")
    @GetMapping(value={"/queryMonitor/{number}"})
    public AjaxResult<Object> queryMonitor(@ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String number) {
        LocalNumber localNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        if (ObjectUtils.isEmpty((Object)localNumber)) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u8bdd\u52a1\u53f0\u7684\u7528\u6237");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(GsSoftConsoleGroupMember::getMemberNumber, (Object)localNumber.getDeviceNumber());
        List list = this.gsSoftConsoleGroupMemberService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u8bdd\u52a1\u53f0\u7684\u7528\u6237");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
        }
        for (GsSoftConsoleGroupMember item : list) {
            if (item.getMonitor() != 1) continue;
            return AjaxResult.success((Object)item.getMonitor());
        }
        return AjaxResult.success((String)"0");
    }

    @ApiOperation(value="\u5f3a\u62c6")
    @Log(title="\u8bdd\u52a1\u53f0:\u5f3a\u62c6", businessType=BusinessType.OTHER)
    @PostMapping(value={"/forcedHangUp/{number}"})
    public AjaxResult<Object> forcedHangUp(@ApiParam(value="\u5f3a\u62c6\u7684\u53f7\u7801") @PathVariable String number) {
        LocalNumber localNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        if (ObjectUtils.isEmpty((Object)localNumber)) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5f3a\u62c6\u7684\u7528\u6237\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.user.notFound", (Object[])new Object[0]));
        }
        String sortNumber = SecurityUtils.getSortNumber();
        LocalNumber loginUser = this.iLocalNumberService.getLocalNumberByNumber(sortNumber);
        if (!this.sipUserService.isOpenSimpleBusiness(loginUser.getDeviceNumber(), SipUserBusinessEnum.SIMPLE_REMOVE.getCode())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.removeOverstep", (Object[])new Object[0]));
        }
        if (this.sipUserService.isOpenSimpleBusiness(localNumber.getAccountcode(), SipUserBusinessEnum.SIMPLE_REMOVE_LIMIT.getCode())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operationNum.removeOverstep", (Object[])new Object[0]));
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList list = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + localNumber.getAccountcode() + "*"));
            if (CollectionUtils.isEmpty(list)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.remove", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (list.size() != 1) {
                LOGGER.error("\u67e5\u8be2\u5230\u8be5\u53f7\u7801\u6b63\u5728\u540c\u65f6\u547c\u53eb\u591a\u4e2a\u8bdd\u673a");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            String bridge_console_group_key = (String)list.get(0);
            String linkedId = bridge_console_group_key.substring(bridge_console_group_key.lastIndexOf(":") + 1);
            String backNumber = "";
            ArrayList grouplist = new ArrayList(jedis.keys("*" + linkedId));
            for (String item : grouplist) {
                if (item.contains(localNumber.getAccountcode())) continue;
                backNumber = item.substring(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey().length(), item.lastIndexOf(":"));
                break;
            }
            if (this.sipUserService.isOpenSimpleBusiness(backNumber, SipUserBusinessEnum.SIMPLE_REMOVE_LIMIT.getCode())) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.peerRemove", (Object[])new Object[0]));
                return ajaxResult;
            }
            String json = jedis.get(bridge_console_group_key);
            BridgeEnterEvent bridgeEnterEvent = (BridgeEnterEvent)GSON.fromJson(json, BridgeEnterEvent.class);
            try {
                HangupAction hangupAction = new HangupAction(bridgeEnterEvent.getChannel());
                ManagerConnection managerConnection = AmiConfig.getConnection();
                ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)hangupAction, 60000L);
                LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
                if (RESPONSE.equals(managerResponse.getResponse())) {
                    LOGGER.debug("\u5f3a\u62c6,\u5df2\u7ecf\u5411Asterisk\u53d1\u9001\u4e86\u6307\u4ee4,\u5f3a\u62c6\u7684\u901a\u9053\u4e3a\uff1a{}", (Object)bridgeEnterEvent.getChannel());
                } else {
                    LOGGER.error("\u5f3a\u62c6\u7684\u7ed3\u679c:[{}]", (Object)managerResponse.getMessage());
                }
            }
            catch (IOException | TimeoutException e) {
                e.printStackTrace();
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
                if (jedis != null) {
                    if (var6_6 != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        jedis.close();
                    }
                }
                return ajaxResult;
            }
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.remove.success", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5f3a\u63d2")
    @Log(title="\u8bdd\u52a1\u53f0:\u5f3a\u63d2", businessType=BusinessType.OTHER)
    @PostMapping(value={"/forcedInsertion/{number}"})
    public AjaxResult<Object> forcedInsertion(@ApiParam(value="\u5f3a\u62c6\u7684\u53f7\u7801") @PathVariable String number) {
        String sortNumber = SecurityUtils.getSortNumber();
        LocalNumber loginUser = this.iLocalNumberService.getLocalNumberByNumber(sortNumber);
        LocalNumber localNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        if (ObjectUtils.isEmpty((Object)localNumber)) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5f3a\u63d2\u7684\u7528\u6237\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.user.notFound", (Object[])new Object[0]));
        }
        if (!this.sipUserService.isOpenSimpleBusiness(loginUser.getDeviceNumber(), SipUserBusinessEnum.SIMPLE_INSERT.getCode())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.insertOverstep", (Object[])new Object[0]));
        }
        if (this.sipUserService.isOpenSimpleBusiness(localNumber.getAccountcode(), SipUserBusinessEnum.SIMPLE_INSERT_LIMIT.getCode())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operationNum.insertOverstep", (Object[])new Object[0]));
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList list = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + localNumber.getAccountcode() + "*"));
            if (CollectionUtils.isEmpty(list)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.insert", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (list.size() != 1) {
                LOGGER.error("\u67e5\u8be2\u5230\u8be5\u53f7\u7801\u6b63\u5728\u540c\u65f6\u547c\u53eb\u591a\u4e2a\u8bdd\u673a");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            String bridge_console_group_key = (String)list.get(0);
            String linkedId = bridge_console_group_key.substring(bridge_console_group_key.lastIndexOf(":") + 1);
            String backNumber = "";
            ArrayList grouplist = new ArrayList(jedis.keys("*" + linkedId));
            for (String item : grouplist) {
                if (item.contains(localNumber.getAccountcode())) continue;
                backNumber = item.substring(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey().length(), item.lastIndexOf(":"));
                break;
            }
            if (this.sipUserService.isOpenSimpleBusiness(backNumber, SipUserBusinessEnum.SIMPLE_INSERT_LIMIT.getCode())) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.peerInsert", (Object[])new Object[0]));
                return ajaxResult;
            }
            String json = jedis.get(bridge_console_group_key);
            BridgeEnterEvent bridgeEnterEvent = (BridgeEnterEvent)GSON.fromJson(json, BridgeEnterEvent.class);
            try {
                String callerChannel = bridgeEnterEvent.getChannel().split("-")[0];
                String user = callerChannel.replace(SipUserBusinessEnum.PJSIP.getCode(), "");
                OriginateAction originateAction = new OriginateAction();
                originateAction.setApplication("ChanSpy");
                originateAction.setChannel(loginUser.getDeviceProtocol() + "/" + loginUser.getDeviceNumber());
                originateAction.setData(callerChannel + ",bqw");
                originateAction.setCallerId(user);
                originateAction.setVariable(CALLERID_NAME, user);
                originateAction.setAccount(user);
                ManagerConnection managerConnection = AmiConfig.getConnection();
                ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)originateAction, 60000L);
                LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
                if (RESPONSE.equals(managerResponse.getResponse())) {
                    LOGGER.debug("\u5f3a\u63d2,\u5df2\u7ecf\u5411Asterisk\u53d1\u9001\u4e86\u6307\u4ee4,\u5f3a\u63d2\u7684\u901a\u9053\u4e3a\uff1a{}", (Object)bridgeEnterEvent.getChannel());
                } else {
                    LOGGER.error("\u5f3a\u63d2\u7684\u7ed3\u679c:[{}]", (Object)managerResponse.getMessage());
                }
            }
            catch (IOException | TimeoutException e) {
                e.printStackTrace();
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
                if (jedis != null) {
                    if (var6_6 != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        jedis.close();
                    }
                }
                return ajaxResult;
            }
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.insert.success", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5f3a\u66ff")
    @Log(title="\u8bdd\u52a1\u53f0:\u5f3a\u66ff", businessType=BusinessType.OTHER)
    @PostMapping(value={"/forcedReplace/{number}"})
    public AjaxResult<Object> forcedReplace(@ApiParam(value="\u5f3a\u66ff\u7684\u53f7\u7801") @PathVariable String number) {
        String sortNumber = SecurityUtils.getSortNumber();
        LocalNumber loginUser = this.iLocalNumberService.getLocalNumberByNumber(sortNumber);
        LocalNumber localNumber = this.iLocalNumberService.getLocalNumberByNumber(number);
        if (ObjectUtils.isEmpty((Object)localNumber)) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u5f3a\u66ff\u7684\u7528\u6237\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.user.notFound", (Object[])new Object[0]));
        }
        if (!this.sipUserService.isOpenSimpleBusiness(loginUser.getDeviceNumber(), SipUserBusinessEnum.SIMPLE_REPLACE.getCode())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.replaceOverstep", (Object[])new Object[0]));
        }
        if (this.sipUserService.isOpenSimpleBusiness(localNumber.getAccountcode(), SipUserBusinessEnum.SIMPLE_REPLACE_LIMIT.getCode())) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operationNum.replaceOverstep", (Object[])new Object[0]));
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList list = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + localNumber.getAccountcode() + "*"));
            if (CollectionUtils.isEmpty(list)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.replace", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (list.size() != 1) {
                LOGGER.error("\u67e5\u8be2\u5230\u8be5\u53f7\u7801\u6b63\u5728\u540c\u65f6\u547c\u53eb\u591a\u4e2a\u8bdd\u673a");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
                return ajaxResult;
            }
            String json = jedis.get((String)list.get(0));
            BridgeEnterEvent bridgeEnterEvent = (BridgeEnterEvent)GSON.fromJson(json, BridgeEnterEvent.class);
            LocalNumber callNumber = this.iLocalNumberService.getLocalNumberByNumber(bridgeEnterEvent.getConnectedLineNum());
            if (ObjectUtils.isEmpty((Object)callNumber)) {
                LOGGER.error("\u672a\u67e5\u8be2\u5230\u5f3a\u66ff\u7684\u7528\u6237\u4fe1\u606f");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.user.notFound", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (this.sipUserService.isOpenSimpleBusiness(callNumber.getAccountcode(), SipUserBusinessEnum.SIMPLE_REPLACE_LIMIT.getCode())) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.peerReplace", (Object[])new Object[0]));
                return ajaxResult;
            }
            try {
                String caller = bridgeEnterEvent.getChannel().split("-")[0];
                String user = caller.replace(SipUserBusinessEnum.PJSIP.getCode(), "");
                OriginateAction originateAction = new OriginateAction();
                originateAction.setApplication("Bridge");
                originateAction.setChannel(loginUser.getDeviceProtocol() + "/" + loginUser.getDeviceNumber());
                originateAction.setData(bridgeEnterEvent.getChannel().split("-")[0]);
                originateAction.setCallerId(user);
                originateAction.setVariable(CALLERID_NAME, user);
                originateAction.setAccount(user);
                ManagerConnection managerConnection = AmiConfig.getConnection();
                ManagerResponse managerResponse = managerConnection.sendAction((ManagerAction)originateAction, 60000L);
                LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
                if (RESPONSE.equals(managerResponse.getResponse())) {
                    LOGGER.debug("\u5f3a\u66ff,\u5df2\u7ecf\u5411Asterisk\u53d1\u9001\u4e86\u6307\u4ee4,\u5f3a\u66ff\u7684\u901a\u9053\u4e3a\uff1a{}", (Object)bridgeEnterEvent.getChannel());
                } else {
                    LOGGER.error("\u5f3a\u66ff\u7684\u7ed3\u679c:[{}]", (Object)managerResponse.getMessage());
                }
            }
            catch (IOException | TimeoutException e) {
                e.printStackTrace();
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.system.error", (Object[])new Object[0]));
                if (jedis != null) {
                    if (var6_6 != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        jedis.close();
                    }
                }
                return ajaxResult;
            }
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.replace.success", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u67e5\u8be2\u672c\u7ec4\u6240\u6709\u8bdd\u52a1\u5458\u72b6\u6001")
    @GetMapping(value={"/queryAllOperatorStatus/{number}"})
    public AjaxResult<List<SoftConsoleMemberStatusVO>> queryAllOperatorStatus(@ApiParam(value="\u53f7\u7801") @PathVariable String number) {
        List numbers;
        ArrayList<SoftConsoleMemberStatusVO> result = new ArrayList<SoftConsoleMemberStatusVO>();
        ArrayList<String> extensionState = new ArrayList<String>();
        ArrayList<String> deviceId = new ArrayList<String>();
        SipUser sipUserByNumber = this.sipUserService.getSipUserByNumber(number);
        if (ObjectUtils.isEmpty((Object)sipUserByNumber)) {
            LOGGER.error("\u672a\u67e5\u5230\u5f53\u524d\u7528\u6237\u7684\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.not.operatorInfo", (Object[])new Object[0]));
        }
        List groups = this.gsSoftConsoleGroupMemberService.getGroupNumberByNumber(sipUserByNumber.getDeviceId());
        if (CollectionUtils.isEmpty((Collection)groups)) {
            LOGGER.error(NOT_IN_ANY_GROUP);
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.notGroup", (Object[])new Object[0]));
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(GsSoftConsoleGroupMember::getGroupNumber, (Collection)groups);
        List list1 = this.gsSoftConsoleGroupMemberService.list((Wrapper)lambdaQueryWrapper);
        for (GsSoftConsoleGroupMember item : list1) {
            extensionState.add(RedisKeyEnum.EXTENSION_STATE.getKey() + item.getMemberNumber());
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            for (String key : extensionState) {
                String json = jedis.get(key);
                if (ObjectUtils.isEmpty((Object)json)) continue;
                deviceId.add(key.split("::")[1]);
                json = FormatStateUtils.formatState((String)json);
                SoftConsoleMemberStatusVO vo = new SoftConsoleMemberStatusVO(json, null, key.split("::")[1]);
                result.add(vo);
            }
            numbers = this.sipUserService.queryNumbersByDeviceIds(deviceId);
            for (SoftConsoleMemberStatusVO item : numbers) {
                for (SoftConsoleMemberStatusVO vo : result) {
                    if (!item.getDeviceId().equals(vo.getDeviceId())) continue;
                    item.setStatus(vo.getStatus());
                }
            }
        }
        return AjaxResult.success((Object)numbers);
    }

    @ApiOperation(value="\u67e5\u8be2\u961f\u5217\u4e2d\u7684\u6392\u961f\u53f7\u7801")
    @GetMapping(value={"/queryQueue/{groupId}"})
    public AjaxResult<List<QueueCallerJoinEvent>> queryQueue(@ApiParam(value="\u53f7\u7801") @PathVariable String groupId) {
        ArrayList groupCallerJoinEvent;
        ArrayList<String> numbers = new ArrayList<String>();
        List userList = null;
        ArrayList<QueueCallerJoinEvent> voList = new ArrayList<QueueCallerJoinEvent>();
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            String group = RedisKeyEnum.CONSOLE_GROUP.getKey() + groupId;
            String json = jedis.get(group);
            if (StringUtils.isEmpty((Object)json)) {
                jedis.set(group, "[]");
                AjaxResult ajaxResult = AjaxResult.success();
                return ajaxResult;
            }
            List joinEvent = (List)GSON.fromJson(json, new /* Unavailable Anonymous Inner Class!! */.getType());
            groupCallerJoinEvent = new ArrayList(joinEvent);
        }
        if (CollectionUtils.isEmpty(groupCallerJoinEvent)) {
            return AjaxResult.success();
        }
        for (QueueCallerJoinEvent item : groupCallerJoinEvent) {
            numbers.add(item.getCallerIdNum());
        }
        if (!CollectionUtils.isEmpty(numbers)) {
            userList = this.ssTelephoneBookService.queryNamesByNumbers(numbers);
        }
        if (CollectionUtils.isEmpty(userList)) {
            return AjaxResult.success(groupCallerJoinEvent);
        }
        for (QueueCallerJoinEvent item : groupCallerJoinEvent) {
            long currentTimeMillis;
            long subTime;
            Date dateReceived;
            for (SsTelephoneBook user : userList) {
                if (!item.getCallerIdNum().equals(user.getPhone())) continue;
                item.setName(user.getName());
                break;
            }
            if (!StringUtils.isEmpty((Object)(dateReceived = item.getDateReceived())) && (subTime = (currentTimeMillis = System.currentTimeMillis()) - dateReceived.getTime()) > 0L) {
                long seconds = Math.round(subTime / 1000L);
                long minutes = Math.round(seconds / 60L);
                if (minutes > 0L) {
                    seconds -= minutes * 60L;
                }
                item.setSeconds(seconds);
                item.setMinutes(minutes);
            }
            voList.add(item);
        }
        if (CollectionUtils.isEmpty(voList)) {
            return AjaxResult.success();
        }
        return AjaxResult.success(voList);
    }

    @ApiOperation(value="\u67e5\u8be2\u767b\u5f55\u7528\u6237\u662f\u5426\u6709\u8bdd\u52a1\u53f0\u6743\u9650")
    @GetMapping(value={"/queryAuthority/{name}"})
    public AjaxResult<HashMap<String, Boolean>> queryAuthority(@ApiParam(value="\u7528\u6237\u53f7\u7801") @PathVariable(value="name") String name) {
        LocalNumber numberInfo;
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        boolean softConsoleFlag = false;
        boolean meetingFlag = false;
        resultMap.put("softConsole", softConsoleFlag);
        resultMap.put("meeting", meetingFlag);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SipUser::getNumber, (Object)name);
        SipUser one = (SipUser)this.sipUserService.getOne((Wrapper)lambdaQueryWrapper);
        if (ObjectUtils.isEmpty((Object)one)) {
            return AjaxResult.success(resultMap);
        }
        Object[] simpleBusiness = one.getSimpleBusiness();
        if (ObjectUtils.isEmpty((Object[])simpleBusiness)) {
            return AjaxResult.success(resultMap);
        }
        for (Object item : simpleBusiness) {
            if ("telephonist".equals(item)) {
                softConsoleFlag = true;
            }
            if (!"instant_meeting".equals(item)) continue;
            meetingFlag = true;
            resultMap.put("meeting", meetingFlag);
        }
        if (softConsoleFlag && !ObjectUtils.isEmpty((Object)(numberInfo = this.iLocalNumberService.getLocalNumberByNumber(name)))) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(QueueMembers::getInter, (Object)(numberInfo.getDeviceProtocol() + "/" + numberInfo.getAccountcode()));
            int count = this.queueMembersService.count((Wrapper)queryWrapper);
            if (count > 0) {
                resultMap.put("softConsole", softConsoleFlag);
            }
        }
        return AjaxResult.success(resultMap);
    }

    @ApiOperation(value="\u68c0\u67e5\u662f\u5426\u80fd\u767b\u5f55\u8bdd\u52a1\u53f0 ,\u9650\u5236\u767b\u5f55\u8bdd\u52a1\u53f0\u6210\u5458\u6570\u91cf")
    @GetMapping(value={"/cehckLoginSoftConsole/{number}"})
    public AjaxResult<Object> cehckLoginSoftConsole(@ApiParam(value="\u8bdd\u52a1\u53f0\u6210\u5458") @PathVariable String number) {
        if (StringUtils.isEmpty((Object)number)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.limit", (Object[])new Object[0]));
        }
        String key = RedisKeyEnum.SOFT_CONSOLE.getKey() + number;
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            if (jedis.exists(key).booleanValue()) {
                AjaxResult ajaxResult = AjaxResult.success();
                return ajaxResult;
            }
            String LOGIN_SOFT_CONSOLE_PREFIX = RedisKeyEnum.SOFT_CONSOLE.getKey() + "*";
            Set loginUsers = jedis.keys(LOGIN_SOFT_CONSOLE_PREFIX);
            LicenseUtils licenseUtils = LicenseUtils.getInstance();
            License license = licenseUtils.getLicense(jedis, true);
            if (ObjectUtils.isEmpty((Object)license)) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.limit", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (loginUsers.size() >= Integer.parseInt(license.getLsrConsoleCount())) {
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.limit", (Object[])new Object[0]));
                return ajaxResult;
            }
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u961f\u5217\u4e2d\u7684\u4fdd\u6301\u53f7\u7801")
    @GetMapping(value={"/queryHold/{number}"})
    public AjaxResult<List<QueueCallerJoinEvent>> queryHold(@ApiParam(value="\u53f7\u7801") @PathVariable String number) {
        ArrayList<QueueCallerJoinEvent> joinEvent = new ArrayList<QueueCallerJoinEvent>();
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList keyList = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + number + "*"));
            if (keyList.isEmpty()) {
                AjaxResult ajaxResult = AjaxResult.success(joinEvent);
                return ajaxResult;
            }
            for (String s : keyList) {
                BridgeEnterEvent bridge = (BridgeEnterEvent)GSON.fromJson(jedis.get(s), BridgeEnterEvent.class);
                String status = jedis.get(RedisKeyEnum.EXTENSION_STATE.getKey() + bridge.getConnectedLineNum());
                if (!ExtensionStateEnum.HOLD.getCode().equals(status)) continue;
                QueueCallerJoinEvent q = new QueueCallerJoinEvent();
                q.setCallerIdNum(bridge.getConnectedLineNum());
                q.setDateReceived(bridge.getDateReceived());
                joinEvent.add(q);
            }
        }
        return AjaxResult.success(joinEvent);
    }

    @ApiOperation(value="\u8bdd\u52a1\u5458\u54a8\u8be2\u8f6c")
    @Log(title="\u8bdd\u52a1\u53f0:\u54a8\u8be2\u8f6c", businessType=BusinessType.OTHER)
    @PostMapping(value={"/consultingTransfer/{number}/{member}"})
    public AjaxResult<Object> consultingTransfer(@ApiParam(value="\u8f6c\u63a5\u53f7\u7801") @PathVariable String number, @ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String member) {
        AjaxResult api = this.getNumberStatus(number, member);
        if (api.code.equals(500)) {
            return api;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList keyList = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + api.msg + "*"));
            if (ObjectUtils.isEmpty(keyList)) {
                LOGGER.error("\u6ca1\u6709\u6b63\u5728\u4e0e\u8bdd\u52a1\u5458\u901a\u8bdd\u7684\u4fe1\u606f");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.transfer", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (number.equals(member)) {
                LOGGER.error("\u65e0\u6cd5\u54a8\u8be2\u81ea\u5df1");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.transferOwn", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (this.queryCallNumber(number, member)) {
                LOGGER.error("\u4e0e\u8bdd\u52a1\u5458\u901a\u8bdd\u4e2d");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.transfer.fail", (Object[])new Object[0]));
                return ajaxResult;
            }
            jedis.set(RedisKeyEnum.CONSULTING.getKey() + number, "1");
            BridgeEnterEvent bridgeEnterEvent = (BridgeEnterEvent)GSON.fromJson(jedis.get((String)keyList.get(0)), BridgeEnterEvent.class);
            AtxferAction atxferAction = new AtxferAction(bridgeEnterEvent.getChannel(), FROM_EXTEN_SIP, number, PRIORITY);
            atxferAction.setActionId(bridgeEnterEvent.getUniqueId());
            ManagerResponse managerResponse = AmiUtil.getManagerConnection((AbstractManagerAction)atxferAction);
            LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
            if (!RESPONSE.equals(managerResponse.getResponse())) {
                LOGGER.error("\u8bdd\u52a1\u5458\u54a8\u8be2\u8f6c\u8bdd\u52a1\u5458\u53f7\u7801:{} \u8f6c\u63a5\u53f7\u7801:{} \u8bdd\u52a1\u5458\u8f6c\u63a5\u7684\u7ed3\u679c:[{}]", new Object[]{number, member, managerResponse.getMessage()});
            }
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.operation.transferring", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u8bdd\u52a1\u5458\u76f2\u8f6c")
    @Log(title="\u8bdd\u52a1\u53f0:\u76f2\u8f6c", businessType=BusinessType.OTHER)
    @PostMapping(value={"/sendBlindTransfer/{number}/{member}"})
    public AjaxResult<Object> sendBlindTransfer(@ApiParam(value="\u8f6c\u63a5\u53f7\u7801") @PathVariable String number, @ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String member) {
        AjaxResult api = this.getNumberStatus(number, member);
        if (api.code.equals(500)) {
            return api;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList keyList = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + api.msg + "*"));
            if (ObjectUtils.isEmpty(keyList)) {
                LOGGER.error("\u6ca1\u6709\u6b63\u5728\u4e0e\u8bdd\u52a1\u5458\u901a\u8bdd\u7684\u4fe1\u606f");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.blindTransfer", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (number.equals(member)) {
                LOGGER.error("\u65e0\u6cd5\u76f2\u8f6c\u81ea\u5df1");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.blindTransferOwn", (Object[])new Object[0]));
                return ajaxResult;
            }
            if (this.queryCallNumber(number, member)) {
                LOGGER.error("\u4e0e\u8bdd\u52a1\u5458\u901a\u8bdd\u4e2d");
                AjaxResult ajaxResult = AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.blindTransfer.fail", (Object[])new Object[0]));
                return ajaxResult;
            }
            BridgeEnterEvent bridgeEnterEvent = (BridgeEnterEvent)GSON.fromJson(jedis.get((String)keyList.get(0)), BridgeEnterEvent.class);
            ManagerResponse managerResponse = AmiUtil.getManagerConnection((AbstractManagerAction)new BlindTransferAction(bridgeEnterEvent.getChannel(), FROM_EXTEN_SIP, number));
            LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
            if (!RESPONSE.equals(managerResponse.getResponse())) {
                LOGGER.error("\u8bdd\u52a1\u5458\u76f2\u8f6c\u8bdd\u52a1\u5458\u53f7\u7801:{} \u8f6c\u63a5\u53f7\u7801:{} \u8bdd\u52a1\u5458\u8f6c\u63a5\u7684\u7ed3\u679c:[{}]", new Object[]{number, member, managerResponse.getMessage()});
            }
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.operation.blindTransferring", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u8bdd\u52a1\u5458\u53d6\u6d88\u54a8\u8be2\u8f6c")
    @Log(title="\u8bdd\u52a1\u53f0:\u53d6\u6d88\u54a8\u8be2\u8f6c", businessType=BusinessType.OTHER)
    @PostMapping(value={"/sendCancelAtxfer/{number}/{member}"})
    public AjaxResult<Object> sendCancelAtxfer(@ApiParam(value="\u8f6c\u63a5\u53f7\u7801") @PathVariable String number, @ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String member) {
        AjaxResult api = this.getNumberStatus(number, member);
        if (api.code.equals(500)) {
            return api;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList keyList = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + api.msg + "*"));
            if (ObjectUtils.isEmpty(keyList)) {
                LOGGER.error("\u6ca1\u6709\u6b63\u5728\u4e0e\u8bdd\u52a1\u5458\u901a\u8bdd\u7684\u4fe1\u606f");
                AjaxResult ajaxResult = AjaxResult.error((String)"\u60a8\u672a\u4e0e\u5176\u4ed6\u4eba\u4f1a\u8bdd\uff0c\u65e0\u6cd5\u8f6c\u63a5\u6765\u7535");
                return ajaxResult;
            }
            if (number.equals(member)) {
                LOGGER.error("\u65e0\u6cd5\u53d6\u6d88\u54a8\u8be2\u81ea\u5df1");
                AjaxResult ajaxResult = AjaxResult.error((String)"\u53d6\u6d88\u54a8\u8be2\u5931\u8d25,\u65e0\u6cd5\u53d6\u6d88\u54a8\u8be2\u81ea\u5df1");
                return ajaxResult;
            }
            if (this.queryCallNumber(number, member)) {
                LOGGER.error("\u4e0e\u8bdd\u52a1\u5458\u901a\u8bdd\u4e2d");
                AjaxResult ajaxResult = AjaxResult.error((String)"\u53d6\u6d88\u54a8\u8be2\u5931\u8d25,\u4e0e\u8bdd\u52a1\u5458\u901a\u8bdd\u4e2d");
                return ajaxResult;
            }
            BridgeEnterEvent bridgeEnterEvent = (BridgeEnterEvent)GSON.fromJson(jedis.get((String)keyList.get(0)), BridgeEnterEvent.class);
            CancelAtxferAction cancelAtxferAction = new CancelAtxferAction(bridgeEnterEvent.getChannel());
            cancelAtxferAction.setActionId(bridgeEnterEvent.getUniqueId());
            ManagerResponse managerResponse = AmiUtil.getManagerConnection((AbstractManagerAction)cancelAtxferAction);
            LOGGER.debug("managerResponse:[{}]", (Object)managerResponse);
            if (!RESPONSE.equals(managerResponse.getResponse())) {
                LOGGER.error("\u8bdd\u52a1\u5458\u76f2\u8f6c\u8bdd\u52a1\u5458\u53f7\u7801:{} \u8f6c\u63a5\u53f7\u7801:{} \u8bdd\u52a1\u5458\u8f6c\u63a5\u7684\u7ed3\u679c:[{}]", new Object[]{number, member, managerResponse.getMessage()});
            }
        }
        return AjaxResult.success((String)"\u6b63\u5728\u53d6\u6d88\u54a8\u8be2\u8f6c\u4e2d");
    }

    @ApiOperation(value="\u8bdd\u52a1\u5458\u547c\u53eb")
    @Log(title="\u8bdd\u52a1\u53f0:\u8bdd\u52a1\u5458\u547c\u53eb", businessType=BusinessType.OTHER)
    @PostMapping(value={"/sendCallNumber/{number}/{member}"})
    public AjaxResult<Object> sendCallNumber(@ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String number, @ApiParam(value="\u8f6c\u63a5\u53f7\u7801") @PathVariable String member) {
        AjaxResult api = this.getNumberStatus(member, number);
        if (api.code.equals(500)) {
            return api;
        }
        SipUser sipUserByNumber = this.sipUserService.getSipUserByNumber(number);
        if (ObjectUtils.isEmpty((Object)sipUserByNumber)) {
            LOGGER.error("\u672a\u67e5\u5230\u5f53\u524d\u7528\u6237\u7684\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.not.operatorInfo", (Object[])new Object[0]));
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            SetParams params = new SetParams();
            params.ex(30);
            jedis.set(RedisKeyEnum.ATXFER.getKey() + number, "1", params);
        }
        OriginateAction originateAction = new OriginateAction();
        originateAction.setChannel(SipUserBusinessEnum.PJSIP.getCode() + sipUserByNumber.getDeviceId());
        originateAction.setContext(FROM_EXTEN_SIP);
        originateAction.setPriority(PRIORITY);
        originateAction.setExten(member);
        originateAction.setCallerId(number);
        originateAction.setAccount(sipUserByNumber.getDeviceId());
        originateAction.setVariable("PJSIP_HEADER(add,Call-Info)", "\\;answer-after=0");
        originateAction.setVariable(CALLERID_NAME, number);
        ManagerResponse managerResponse = AmiUtil.getManagerConnection((AbstractManagerAction)originateAction);
        if (!RESPONSE.equals(managerResponse.getResponse())) {
            LOGGER.error("\u8bdd\u52a1\u5458\u547c\u53eb\u8bdd\u52a1\u5458\u53f7\u7801:{} \u8f6c\u63a5\u53f7\u7801:{} \u8bdd\u52a1\u5458\u8f6c\u63a5\u7684\u7ed3\u679c:[{}]", new Object[]{number, member, managerResponse.getMessage()});
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.operation.call", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u8bdd\u52a1\u5458\u9009\u62e9\u63a5\u542c")
    @Log(title="\u8bdd\u52a1\u53f0:\u8bdd\u52a1\u5458\u9009\u62e9\u63a5\u542c", businessType=BusinessType.OTHER)
    @PostMapping(value={"/sendSelectAnswer/{number}/{member}"})
    public AjaxResult<Object> sendSelectAnswer(@ApiParam(value="\u8f6c\u63a5\u53f7\u7801") @PathVariable String number, @ApiParam(value="\u8bdd\u52a1\u5458\u53f7\u7801") @PathVariable String member) {
        Object object;
        if (ObjectUtils.isEmpty((Object)member) || ObjectUtils.isEmpty((Object)number)) {
            LOGGER.error("\u8bdd\u52a1\u5458\u9009\u62e9\u63a5\u542c: \u8bdd\u52a1\u5458\u53f7\u7801:{} \u8f6c\u63a5\u53f7\u7801:{}", (Object)member, (Object)number);
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.user.notFound", (Object[])new Object[0]));
        }
        LocalNumber one = (LocalNumber)this.iLocalNumberService.getOne((Wrapper)new LambdaQueryWrapper().eq(LocalNumber::getNumber, (Object)member));
        if (ObjectUtils.isEmpty((Object)one)) {
            LOGGER.error("\u8bdd\u52a1\u5458\u9009\u62e9\u63a5\u542c: \u67e5\u8be2\u6570\u636e\u5e93\u672a\u83b7\u53d6\u5230\u8bdd\u52a1\u5458\u7684\u76f8\u5173\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.not.operatorInfo", (Object[])new Object[0]));
        }
        List groups = this.gsSoftConsoleGroupMemberService.getGroupNumberByNumber(one.getDeviceNumber());
        if (CollectionUtils.isEmpty((Collection)groups)) {
            LOGGER.error("\u5f53\u524d\u7528\u6237\u4e0d\u5728\u4efb\u4f55\u4e00\u4e2a\u8bdd\u52a1\u53f0\u7ec4\u4e2d\u53f7\u7801: {}", (Object)one.getDeviceNumber());
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.notGroup", (Object[])new Object[0]));
        }
        ArrayList groupCallerJoinEvent = new ArrayList();
        ArrayList<String> groupIdList = new ArrayList<String>();
        Jedis jedis = this.jedisPool.getResource();
        Object object2 = null;
        try {
            jedis.select(1);
            for (String groupId : groups) {
                groupIdList.add(RedisKeyEnum.CONSOLE_GROUP.getKey() + groupId);
            }
            if (CollectionUtils.isEmpty(groupIdList)) {
                object = AjaxResult.success();
                return object;
            }
            for (String key : groupIdList) {
                String json = jedis.get(key);
                if (StringUtils.isEmpty((Object)json)) {
                    jedis.set(key, "[]");
                    continue;
                }
                List joinEvent = (List)GSON.fromJson(json, new /* Unavailable Anonymous Inner Class!! */.getType());
                groupCallerJoinEvent.addAll(joinEvent);
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (jedis != null) {
                if (object2 != null) {
                    try {
                        jedis.close();
                    }
                    catch (Throwable groupId) {
                        ((Throwable)object2).addSuppressed(groupId);
                    }
                } else {
                    jedis.close();
                }
            }
        }
        String channel = "";
        for (QueueCallerJoinEvent queueCallerJoinEvent : groupCallerJoinEvent) {
            if (!queueCallerJoinEvent.getCallerIdNum().equals(number)) continue;
            channel = queueCallerJoinEvent.getChannel();
            break;
        }
        Jedis jedis2 = this.jedisPool.getResource();
        object = null;
        try {
            jedis2.select(1);
            SetParams params = new SetParams();
            params.ex(15);
            jedis2.set(RedisKeyEnum.ATXFER.getKey() + number, "1", params);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (jedis2 != null) {
                if (object != null) {
                    try {
                        jedis2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    jedis2.close();
                }
            }
        }
        ManagerResponse managerResponse = AmiUtil.getManagerConnection((AbstractManagerAction)new RedirectAction(channel, FROM_EXTEN_SIP, member, PRIORITY));
        if (!RESPONSE.equals(managerResponse.getResponse())) {
            LOGGER.error("\u8bdd\u52a1\u5458\u547c\u53eb\u8bdd\u52a1\u5458\u53f7\u7801:{} \u8f6c\u63a5\u53f7\u7801:{} \u8bdd\u52a1\u5458\u8f6c\u63a5\u7684\u7ed3\u679c:[{}]", new Object[]{number, member, managerResponse.getMessage()});
        }
        return AjaxResult.success((String)MessageUtils.message((String)"SoftConsoleController.operation.transferring", (Object[])new Object[0]));
    }

    public AjaxResult<Object> getNumberStatus(String number, String member) {
        if (ObjectUtils.isEmpty((Object)number)) {
            LOGGER.error("\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7684\u8bdd\u52a1\u5458\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.user.notFound", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)member)) {
            LOGGER.error("\u672a\u83b7\u53d6\u5230\u8f6c\u63a5\u7684\u53f7\u7801");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.not.operatorInfo", (Object[])new Object[0]));
        }
        LocalNumber one = (LocalNumber)this.iLocalNumberService.getOne((Wrapper)new LambdaQueryWrapper().eq(LocalNumber::getNumber, (Object)member));
        if (ObjectUtils.isEmpty((Object)one)) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5e93\u672a\u83b7\u53d6\u5230\u8bdd\u52a1\u5458\u7684\u76f8\u5173\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.not.operatorInfo", (Object[])new Object[0]));
        }
        return AjaxResult.success((String)one.getAccountcode());
    }

    public boolean queryCallNumber(String number, String member) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            ArrayList list = new ArrayList(jedis.keys(RedisKeyEnum.BRIDGE_CONSOLE_GROUP.getKey() + member + "*"));
            for (String s : list) {
                BridgeEnterEvent bridge = (BridgeEnterEvent)GSON.fromJson(jedis.get(s), BridgeEnterEvent.class);
                if (!number.equals(bridge.getConnectedLineNum())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @PostMapping(value={"/listNumbersStatus/{numbers}"})
    public AjaxResult<Object> listNumbersStatus(@PathVariable String numbers) {
        StringJoiner status = new StringJoiner(",");
        String[] numbersArray = numbers.split(",");
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            for (String s : numbersArray) {
                status.add(jedis.get(RedisKeyEnum.EXTENSION_STATE.getKey() + s));
            }
        }
        return AjaxResult.success((String)"", (Object)status.toString());
    }

    @PostMapping(value={"/getConsoleGroup/{number}"})
    public AjaxResult<SoftNumberVO> getConsoleGroup(@PathVariable String number) {
        SipUser sipUserByNumber = this.sipUserService.getSipUserByNumber(number);
        if (ObjectUtils.isEmpty((Object)sipUserByNumber)) {
            LOGGER.error("\u672a\u67e5\u5230\u5f53\u524d\u7528\u6237\u7684\u4fe1\u606f");
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.user.notFound", (Object[])new Object[0]));
        }
        List groups = this.gsSoftConsoleGroupMemberService.getGroupNumberByNumber(sipUserByNumber.getDeviceId());
        if (CollectionUtils.isEmpty((Collection)groups)) {
            LOGGER.error(NOT_IN_ANY_GROUP);
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.notGroup", (Object[])new Object[0]));
        }
        SoftNumberVO vo = new SoftNumberVO();
        vo.setDeviceId(sipUserByNumber.getDeviceId());
        vo.setConsoleGroup((String)groups.get(0));
        return AjaxResult.success((Object)vo);
    }

    @ApiOperation(value="\u6e05\u7a7a\u8bdd\u52a1\u53f0\u7528\u6237")
    @Log(title="\u6e05\u7a7a\u8bdd\u52a1\u53f0\u7528\u6237", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/clearPhone"})
    public AjaxResult clearPhone() {
        int sipCount = this.ssTelephoneBookService.count();
        if (sipCount == 0) {
            return AjaxResult.error((String)MessageUtils.message((String)"SoftConsoleController.operation.clear", (Object[])new Object[0]));
        }
        return this.ssTelephoneBookService.deletePhone() ? AjaxResult.success((String)MessageUtils.message((String)"operate.success", (Object[])new Object[0])) : AjaxResult.error((String)MessageUtils.message((String)"operate.fail", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5bfc\u51fa\u7535\u8bdd\u672c")
    @GetMapping(value={"/exportTelephoneBook"})
    public AjaxResult exportTelephoneBook() {
        List list = this.ssTelephoneBookService.list();
        ExcelUtil util = new ExcelUtil(SsTelephoneBook.class);
        return util.exportExcel(list, MessageUtils.message((String)"SsTelephoneBook.telephoneBook", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5bfc\u5165\u7535\u8bdd\u672c")
    @PostMapping(value={"/importTelephoneBook"})
    public AjaxResult importTelephoneBook(@ApiParam(value="\u6587\u4ef6") @RequestParam(value="file") MultipartFile file) throws Exception {
        ExcelUtil util = new ExcelUtil(SsTelephoneBook.class);
        List ssTelephoneBooks = util.importExcel(file.getInputStream());
        if (CollectionUtils.isEmpty((Collection)ssTelephoneBooks)) {
            return AjaxResult.error();
        }
        return this.toAjax(this.ssTelephoneBookService.saveBatchTelephoneBook(ssTelephoneBooks));
    }
}

