/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.annotation.RepeatSubmit;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.dao.SipUserDao;
import com.uscale.system.entity.SipUser;
import com.uscale.system.model.CreateSipUserTrust;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.IUmSipUserTrustService;
import com.uscale.system.vo.UmSipUserTrustVO;
import com.uscale.web.controller.userMng.SipUserController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u81ea\u52a9\u670d\u52a1\u4fe1\u4efb\u53f7\u7801"})
@RestController
@RequestMapping(value={"/self/sipUser/trust"})
public class SipUserTrustController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SipUserController.class);
    private static final Gson GSON = new Gson();
    private final TokenService tokenService;
    private final IUmSipUserTrustService sipUserTrustService;
    private final SipUserDao sipUserDao;
    private final ISipUserService iSipUserService;

    @Autowired
    public SipUserTrustController(TokenService tokenService, IUmSipUserTrustService sipUserTrustService, SipUserDao sipUserDao, ISipUserService iSipUserService) {
        this.tokenService = tokenService;
        this.sipUserTrustService = sipUserTrustService;
        this.sipUserDao = sipUserDao;
        this.iSipUserService = iSipUserService;
    }

    @ApiOperation(value="\u4fe1\u4efb\u53f7\u7801\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u9875\u6761\u6570") Integer pageNum, @ApiParam(value="\u9875\u6570") Integer pageSize) {
        LOGGER.debug("\u67e5\u8be2SIP\u7528\u6237\u4fe1\u4efb\u53f7\u7801\u5217\u8868\uff0cpageNum=[{}], pageSize=[{}]", (Object)pageNum, (Object)pageSize);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        String deviceId = this.sipUserDao.queryDeviceIdByNumber(SecurityUtils.getSortNumber());
        Page result = this.sipUserTrustService.pageList(page, deviceId);
        if (result != null && result.getRecords() != null) {
            List trusts = result.getRecords();
            for (UmSipUserTrustVO vo : trusts) {
                String trustDeviceId = vo.getTrustDeviceId();
                SipUser sipUserByDeviceId = this.iSipUserService.getSipUserByDeviceId(trustDeviceId);
                if (sipUserByDeviceId == null) continue;
                vo.setNumber(sipUserByDeviceId.getNumber());
            }
        }
        return this.getDataTable(result);
    }

    @ApiOperation(value="\u4fe1\u4efb\u53f7\u7801\u5217\u8868\u65b0\u589e")
    @RepeatSubmit
    @Log(title="\u81ea\u52a9\u670d\u52a1:\u4fe1\u4efb\u5217\u8868", businessType=BusinessType.INSERT)
    @PostMapping(value={"/create"})
    public AjaxResult<Object> add(HttpServletRequest request, @ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @Validated @RequestBody CreateSipUserTrust createSip) {
        LOGGER.debug("\u65b0\u589eSIP\u7528\u6237\uff0c\u83b7\u53d6\u5230\u53c2\u6570\uff1acreateSip=[{}]", (Object)GSON.toJson((Object)createSip));
        return this.toAjax(this.sipUserTrustService.createTrusts(this.tokenService.getLoginUser(request), createSip));
    }

    @ApiOperation(value="\u4fe1\u4efb\u53f7\u7801\u5217\u8868\u5220\u9664")
    @RepeatSubmit
    @Log(title="\u81ea\u52a9\u670d\u52a1:\u4fe1\u4efb\u5217\u8868", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult<Object> remove(@ApiParam(value="\u4fe1\u4efb\u53f7\u7801IDS") @PathVariable List<Long> ids) {
        return this.toAjax(this.sipUserTrustService.removeByIds(ids));
    }
}

