/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.entity.SipUser;
import com.uscale.system.service.ISipUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u4fee\u6539\u4e1a\u52a1\u5bc6\u7801"})
@RestController
@RequestMapping(value={"/self/sipUser/servicePassword"})
public class SipUserServicePasswordController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final TokenService tokenService;
    private final ISipUserService sipUserService;

    @Autowired
    public SipUserServicePasswordController(TokenService tokenService, ISipUserService sipUserService) {
        this.tokenService = tokenService;
        this.sipUserService = sipUserService;
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801", required=true, dataType="String"), @ApiImplicitParam(name="newPassword", value="\u65b0\u5bc6\u7801", required=true, dataType="String")})
    @Log(title="\u7528\u6237\u7ba1\u7406:\u4fee\u6539\u4e1a\u52a1\u5bc6\u7801", businessType=BusinessType.UPDATE)
    @PostMapping
    public AjaxResult<Boolean> changeServicePassword(HttpServletRequest request, @ApiIgnore @RequestBody Map<String, String> param) {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        SipUser sipUser = this.sipUserService.getSipUserByNumber(loginUser.getUsername());
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            return AjaxResult.error();
        }
        String oldPassword = param.get("oldPassword");
        String newPassword = param.get("newPassword");
        if (!sipUser.getServicePassword().equals(oldPassword)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserServicePasswordController.oldPassword.wrong", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)newPassword)) {
            return AjaxResult.error();
        }
        SipUser user = new SipUser();
        user.setId(sipUser.getId());
        user.setServicePassword(newPassword);
        return AjaxResult.success((Object)this.sipUserService.updateById((Object)user));
    }
}

