/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.domain.model.LoginUser;
import com.uscale.common.enums.BusinessType;
import com.uscale.framework.web.service.TokenService;
import com.uscale.system.entity.UmSipUserBlack;
import com.uscale.system.service.IUmSipUserBlackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9ed1\u540d\u5355"})
@RestController
@RequestMapping(value={"/self/sipUser/black"})
public class SipUserBlackListController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final TokenService tokenService;
    private final IUmSipUserBlackService umSipUserBlackService;

    @Autowired
    public SipUserBlackListController(TokenService tokenService, IUmSipUserBlackService umSipUserBlackService) {
        this.tokenService = tokenService;
        this.umSipUserBlackService = umSipUserBlackService;
    }

    @ApiOperation(value="\u9ed1\u540d\u5355\u5217\u8868")
    @GetMapping
    public AjaxResult<List<UmSipUserBlack>> queryBlackList(HttpServletRequest request) {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        this.LOGGER.debug("\u67e5\u8be2\u7528\u6237\u9ed1\u540d\u5355\u914d\u7f6e\uff1auserId=[{}]", (Object)loginUser.getUsername());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UmSipUserBlack::getDeviceId, (Object)loginUser.getUsername());
        return AjaxResult.success((Object)this.umSipUserBlackService.list((Wrapper)wrapper));
    }

    @ApiOperation(value="\u6dfb\u52a0\u9ed1\u540d\u5355")
    @Log(title="\u9ed1\u540d\u5355", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult<Boolean> saveBlackList(HttpServletRequest request, @RequestBody List<UmSipUserBlack> blackList) {
        if (CollectionUtils.isEmpty(blackList)) {
            return AjaxResult.error();
        }
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        String userId = loginUser.getUsername();
        blackList.forEach(item -> item.setDeviceId(userId));
        return AjaxResult.success((Object)this.umSipUserBlackService.saveOrUpdateBatch(blackList));
    }

    @ApiOperation(value="\u5220\u9664\u9ed1\u540d\u5355", notes="\u6839\u636eID\u5220\u9664\u9ed1\u540d\u5355")
    @Log(title="\u9ed1\u540d\u5355", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult<Boolean> deleteBlackList(@PathVariable(value="ids") List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return AjaxResult.error();
        }
        return AjaxResult.success((Object)this.umSipUserBlackService.removeByIds(ids));
    }
}

