/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.utils.SecurityUtils;
import com.uscale.system.entity.SsScheduleMeeting;
import com.uscale.system.entity.SsScheduleMeetingMember;
import com.uscale.system.enums.SsScheduleMeetingEnum;
import com.uscale.system.service.ISsScheduleMeetingMemberService;
import com.uscale.system.service.ISsScheduleMeetingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6211\u7684\u4f1a\u8bae"})
@RestController
@RequestMapping(value={"/self/meeting"})
public class MyMeetingController {
    private final ISsScheduleMeetingService ssScheduleMeetingService;
    private final ISsScheduleMeetingMemberService ssScheduleMeetingMemberService;

    @Autowired
    public MyMeetingController(ISsScheduleMeetingService ssScheduleMeetingService, ISsScheduleMeetingMemberService ssScheduleMeetingMemberService) {
        this.ssScheduleMeetingService = ssScheduleMeetingService;
        this.ssScheduleMeetingMemberService = ssScheduleMeetingMemberService;
    }

    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\u4f1a\u8bae\u8bb0\u5f55")
    @GetMapping(value={"/queryMyMeeting"})
    public AjaxResult<Map<String, Object>> queryMyMeeting() {
        String number = SecurityUtils.getSortNumber();
        HashMap data = new HashMap();
        AjaxResult result = AjaxResult.success(data);
        this.queryNotStartScheduleMeeting(number, result);
        this.queryIsMemberScheduleMeeting(number, result);
        return result;
    }

    private void queryStartedScheduleMeeting(String number, AjaxResult<Map<String, Object>> ajaxResult) {
        LambdaQueryWrapper scheduleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)scheduleWrapper.eq(SsScheduleMeeting::getScheduler, (Object)number)).eq(SsScheduleMeeting::getMeetingStatus, (Object)SsScheduleMeetingEnum.MEETING_STATUS_GOING.getCode());
        ArrayList list = new ArrayList(this.ssScheduleMeetingService.list((Wrapper)scheduleWrapper));
        List distinctMeetingIds = this.queryIsMeetingMemberMeetingId(number);
        if (!CollectionUtils.isEmpty((Collection)distinctMeetingIds)) {
            scheduleWrapper.clear();
            ((LambdaQueryWrapper)scheduleWrapper.in(SsScheduleMeeting::getMeetingId, (Collection)distinctMeetingIds)).eq(SsScheduleMeeting::getMeetingStatus, (Object)SsScheduleMeetingEnum.MEETING_STATUS_GOING.getCode());
            list.addAll(this.ssScheduleMeetingService.list((Wrapper)scheduleWrapper));
        }
        ((Map)ajaxResult.data).put("scheduleMeetingStarted", list);
    }

    private void queryNotStartScheduleMeeting(String number, AjaxResult<Map<String, Object>> ajaxResult) {
        LambdaQueryWrapper scheduleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)scheduleWrapper.eq(SsScheduleMeeting::getScheduler, (Object)number)).gt(SsScheduleMeeting::getStartTime, (Object)new Date())).eq(SsScheduleMeeting::getMeetingStatus, (Object)SsScheduleMeetingEnum.MEETING_STATUS_NOT_START.getCode());
        ((Map)ajaxResult.data).put("scheduleMeeting", this.ssScheduleMeetingService.list((Wrapper)scheduleWrapper));
    }

    private void queryIsMemberScheduleMeeting(String number, AjaxResult<Map<String, Object>> ajaxResult) {
        List distinctMeetingIds = this.queryIsMeetingMemberMeetingId(number);
        if (CollectionUtils.isEmpty((Collection)distinctMeetingIds)) {
            ((Map)ajaxResult.data).put("scheduleMemberMeeting", new ArrayList());
            return;
        }
        LambdaQueryWrapper scheduleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)scheduleWrapper.in(SsScheduleMeeting::getMeetingId, (Collection)distinctMeetingIds)).gt(SsScheduleMeeting::getStartTime, (Object)new Date())).eq(SsScheduleMeeting::getMeetingStatus, (Object)SsScheduleMeetingEnum.MEETING_STATUS_NOT_START.getCode())).ne(SsScheduleMeeting::getScheduler, (Object)number);
        ((Map)ajaxResult.data).put("scheduleMemberMeeting", this.ssScheduleMeetingService.list((Wrapper)scheduleWrapper));
    }

    private List<String> queryIsMeetingMemberMeetingId(String number) {
        LambdaQueryWrapper memberWrapper = new LambdaQueryWrapper();
        memberWrapper.select(new SFunction[]{SsScheduleMeetingMember::getMeetingId}).eq(SsScheduleMeetingMember::getParticipantPhoneNumber, (Object)number);
        List meetingMemberList = this.ssScheduleMeetingMemberService.list((Wrapper)memberWrapper);
        ArrayList meetingIds = new ArrayList();
        meetingMemberList.forEach(item -> meetingIds.add(item.getMeetingId()));
        return meetingIds.stream().distinct().collect(Collectors.toList());
    }
}

