/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.system.domain.vo.DictVo;
import com.uscale.system.entity.SsMeetingTemplate;
import com.uscale.system.service.SsMeetingTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u8bae\u6a21\u677f"})
@RestController
@RequestMapping(value={"/self/meetingTemplate"})
public class MeetingTemplateController
extends BaseController {
    private final SsMeetingTemplateService ssMeetingTemplateService;

    @Autowired
    public MeetingTemplateController(SsMeetingTemplateService ssMeetingTemplateService) {
        this.ssMeetingTemplateService = ssMeetingTemplateService;
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u6a21\u677f\u540d\u79f0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="number", value="\u4f1a\u8bae\u53d1\u8d77\u8005\u53f7\u7801", required=true, dataType="String")})
    @GetMapping(value={"/getTemplateName"})
    public AjaxResult<List<DictVo>> getTemplateName() {
        return AjaxResult.success((Object)this.ssMeetingTemplateService.getTemplateName());
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u4f1a\u8bae\u6a21\u677f\u540d\u79f0", required=true, dataType="String")})
    @GetMapping(value={"/getTemplateList"})
    public TableDataInfo<SsMeetingTemplate> getTemplateList(SsMeetingTemplate ssMeetingTemplate) {
        this.startPage();
        List templateList = this.ssMeetingTemplateService.getTemplateList(ssMeetingTemplate);
        return this.getDataTable(templateList);
    }

    @ApiOperation(value="\u65b0\u589e\u4f1a\u8bae\u6a21\u677f")
    @PostMapping(value={"/saveMeetingTemplate"})
    public AjaxResult saveMeetingTemplate(@RequestBody SsMeetingTemplate vo) {
        return this.toAjax(this.ssMeetingTemplateService.saveMeetingTemplate(vo));
    }

    @ApiOperation(value="\u7f16\u8f91\u4f1a\u8bae\u6a21\u677f")
    @PutMapping(value={"/editMeetingTemplate"})
    public AjaxResult editMeetingTemplate(@RequestBody SsMeetingTemplate vo) {
        return this.toAjax(this.ssMeetingTemplateService.editMeetingTemplate(vo));
    }

    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u4f1a\u8bae\u6a21\u677fID", required=true, dataType="List")})
    @DeleteMapping(value={"/removeMeetingTemplate/{ids}"})
    public AjaxResult removeMeetingTemplate(@PathVariable(value="ids") List<Integer> ids) {
        return this.toAjax(this.ssMeetingTemplateService.removeMeetingTemplate(ids));
    }
}

