/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.self_service;

import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.system.domain.vo.DeleteMeetingMemberVo;
import com.uscale.system.domain.vo.JoinMeetingVo;
import com.uscale.system.entity.SsMeeting;
import com.uscale.system.entity.SsMeetingMember;
import com.uscale.system.service.SsMeetingMemberService;
import com.uscale.system.service.SsMeetingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7535\u8bdd\u4f1a\u8bae"})
@RestController
@RequestMapping(value={"/selfServer/meeting"})
public class MeetingController
extends BaseController {
    private final SsMeetingService ssMeetingService;
    private final SsMeetingMemberService ssMeetingMemberService;

    @Autowired
    public MeetingController(SsMeetingService ssMeetingService, SsMeetingMemberService ssMeetingMemberService) {
        this.ssMeetingService = ssMeetingService;
        this.ssMeetingMemberService = ssMeetingMemberService;
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String")})
    @GetMapping(value={"/getMeeting/{meetingCode}"})
    public AjaxResult<SsMeeting> getMeeting(@PathVariable(value="meetingCode") String meetingCode) {
        return AjaxResult.success((Object)this.ssMeetingService.getMeeting(meetingCode));
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u5217\u8868")
    @GetMapping(value={"/getMeetingList"})
    public TableDataInfo<SsMeeting> getMeetingList(SsMeeting meeting) {
        this.startPage();
        List meetingList = this.ssMeetingService.getMeetingList(meeting);
        return this.getDataTable(meetingList);
    }

    @ApiOperation(value="\u7f16\u8f91\u4f1a\u8bae")
    @PostMapping(value={"/editMeeting"})
    public AjaxResult editMeeting(@RequestBody SsMeeting ssMeeting) {
        return this.toAjax(this.ssMeetingService.editMeeting(ssMeeting));
    }

    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="ID", required=true, dataType="List")})
    @DeleteMapping(value={"/deleteMeeting/{ids}"})
    public AjaxResult deleteMeeting(@PathVariable(value="ids") List<Long> ids) {
        return this.toAjax(this.ssMeetingService.deleteMeeting(ids));
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u6210\u5458\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6210\u5458id", required=true, dataType="String")})
    @GetMapping(value={"/getMeetingMember/{id}"})
    public AjaxResult<SsMeetingMember> getMeetingMember(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.ssMeetingMemberService.getSsMeetingMember(id));
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u6210\u5458\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"/getMeetingMemberList"})
    public TableDataInfo<SsMeetingMember> getMeetingMemberList(SsMeetingMember ssMeetingMember) {
        this.startPage();
        List meetingMemberList = this.ssMeetingMemberService.getMeetingMemberList(ssMeetingMember);
        return this.getDataTable(meetingMemberList);
    }

    @ApiOperation(value="\u6dfb\u52a0\u4f1a\u8bae\u6210\u5458")
    @PostMapping(value={"/saveMeetingMember"})
    public AjaxResult saveMeetingMember(@RequestBody List<SsMeetingMember> meetingMemberList) {
        return this.toAjax(this.ssMeetingMemberService.saveMeetingMember(meetingMemberList));
    }

    @ApiOperation(value="\u7f16\u8f91\u4f1a\u8bae\u6210\u5458")
    @PutMapping(value={"/editMeetingMember"})
    public AjaxResult editMeetingMember(@RequestBody SsMeetingMember meetingMember) {
        return this.toAjax(this.ssMeetingMemberService.editMeetingMember(meetingMember));
    }

    @ApiOperation(value="\u8f6c\u79fb\u4e3b\u5e2d\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String"), @ApiImplicitParam(name="memberNumber", value="\u8f6c\u79fb\u4e3b\u5e2d\u6210\u5458\u53f7\u7801", required=true, dataType="String")})
    @PostMapping(value={"/transferPermissionsToMaster/{meetingCode}/{memberNumber}"})
    public AjaxResult transferPermissionsToMaster(@PathVariable(value="meetingCode") String meetingCode, @PathVariable(value="memberNumber") String memberNumber) {
        return this.toAjax(this.ssMeetingMemberService.transferPermissionsToMaster(meetingCode, memberNumber));
    }

    @ApiOperation(value="\u53d6\u6d88\u4e3b\u5e2d\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String"), @ApiImplicitParam(name="memberNumber", value="\u53d6\u6d88\u4e3b\u5e2d\u6210\u5458\u53f7\u7801", required=true, dataType="String")})
    @PostMapping(value={"/removeMasterPermissions/{meetingCode}/{memberNumber}"})
    public AjaxResult removeMasterPermissions(@PathVariable(value="meetingCode") String meetingCode, @PathVariable(value="memberNumber") String memberNumber) {
        return this.toAjax(this.ssMeetingMemberService.removeMasterPermissions(meetingCode, memberNumber));
    }

    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae\u6210\u5458")
    @DeleteMapping(value={"/deleteMeetingMember"})
    public AjaxResult deleteMeetingMember(@RequestBody DeleteMeetingMemberVo vo) {
        return this.toAjax(this.ssMeetingMemberService.deleteMeetingMember(vo));
    }

    @ApiOperation(value="\u9759\u97f3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String"), @ApiImplicitParam(name="memberNumber", value="\u8f6c\u79fb\u4e3b\u5e2d\u6210\u5458\u53f7\u7801", required=true, dataType="String")})
    @PostMapping(value={"/mute/{meetingCode}/{memberNumber}"})
    public AjaxResult mute(@PathVariable(value="meetingCode") String meetingCode, @PathVariable(value="memberNumber") String memberNumber) {
        return this.toAjax(this.ssMeetingMemberService.mute(meetingCode, memberNumber));
    }

    @ApiOperation(value="\u53d6\u6d88\u9759\u97f3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String"), @ApiImplicitParam(name="memberNumber", value="\u8f6c\u79fb\u4e3b\u5e2d\u6210\u5458\u53f7\u7801", required=true, dataType="String")})
    @PostMapping(value={"/unMute/{meetingCode}/{memberNumber}"})
    public AjaxResult unMute(@PathVariable(value="meetingCode") String meetingCode, @PathVariable(value="memberNumber") String memberNumber) {
        return this.toAjax(this.ssMeetingMemberService.unMute(meetingCode, memberNumber));
    }

    @ApiOperation(value="\u5f00\u59cb\u4f1a\u8bae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String")})
    @PostMapping(value={"/startMeeting/{meetingCode}"})
    public AjaxResult startMeeting(@PathVariable(value="meetingCode") String meetingCode) {
        return this.toAjax(this.ssMeetingService.startMeeting(meetingCode));
    }

    @ApiOperation(value="\u53d6\u6d88\u4f1a\u8bae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String")})
    @PostMapping(value={"/stopMeeting/{meetingCode}"})
    public AjaxResult stopMeeting(@PathVariable(value="meetingCode") String meetingCode) {
        return this.toAjax(this.ssMeetingService.stopMeeting(meetingCode));
    }

    @ApiOperation(value="\u52a0\u5165\u4f1a\u8bae")
    @PostMapping(value={"/joinMeeting"})
    public AjaxResult joinMeeting(@RequestBody JoinMeetingVo joinMeetingVo) {
        return this.toAjax(this.ssMeetingService.joinMeeting(joinMeetingVo));
    }

    @ApiOperation(value="\u7ed3\u675f\u4f1a\u8bae")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String")})
    @PostMapping(value={"/endMeeting/{meetingCode}"})
    public AjaxResult endMeeting(@PathVariable(value="meetingCode") String meetingCode) {
        return this.toAjax(this.ssMeetingService.endMeeting(meetingCode));
    }

    @ApiOperation(value="\u8e22\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="meetingCode", value="\u4f1a\u8baeID", required=true, dataType="String"), @ApiImplicitParam(name="memberNumber", value="\u6210\u5458\u53f7\u7801", required=true, dataType="String")})
    @PostMapping(value={"/kick/{meetingCode}/{memberNumber}"})
    public AjaxResult kick(@PathVariable(value="meetingCode") String meetingCode, @PathVariable(value="memberNumber") String memberNumber) {
        return this.toAjax(this.ssMeetingMemberService.kick(meetingCode, memberNumber));
    }
}

