/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.resource;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.gson.Gson;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.system.entity.ReMemStatus;
import com.uscale.system.service.IReMemStatusService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resource/memStatus"})
public class ReMemStatusController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Gson GSON = new Gson();
    private static final Pattern PATTERN_FOR_DATE_TIME = Pattern.compile("(?<dateTime>\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})");
    private final IReMemStatusService reMemStatusService;

    @Autowired
    public ReMemStatusController(IReMemStatusService reMemStatusService) {
        this.reMemStatusService = reMemStatusService;
    }

    @PostMapping
    public AjaxResult queryCpuStatus(@RequestBody Map<String, String> param) throws ParseException {
        this.LOGGER.debug("\u67e5\u8be2\u5185\u5b58\u72b6\u6001\uff0c\u63a5\u6536\u5230\u65f6\u95f4\u53c2\u6570\u4e3a\uff1aparam=[{}], date=[{}]", (Object)GSON.toJson(param), (Object)param.get("dateTime"));
        String dateTime = param.get("dateTime");
        Matcher matcher = PATTERN_FOR_DATE_TIME.matcher(dateTime);
        if (ObjectUtils.isEmpty((Object)dateTime) || !matcher.find()) {
            return AjaxResult.error();
        }
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = sp.parse(matcher.group("dateTime"));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{ReMemStatus::getCollectTime, ReMemStatus::getValue, ReMemStatus::getResourceId}).eq(ReMemStatus::getResourceId, (Object)param.get("slot"))).eq(ReMemStatus::getCollectTime, (Object)now);
        return AjaxResult.success((Object)this.reMemStatusService.list((Wrapper)wrapper));
    }

    @PostMapping(value={"/history"})
    public AjaxResult queryCpuHistoryStatus(@RequestBody Map<String, String> param) throws ParseException {
        this.LOGGER.debug("\u67e5\u8be2\u5185\u5b58\u5386\u53f2\u72b6\u6001\uff0c\u63a5\u6536\u5230\u65f6\u95f4\u53c2\u6570\u4e3a\uff1aparam=[{}], date=[{}]", (Object)GSON.toJson(param), (Object)param.get("dateTime"));
        String dateTime = param.get("dateTime");
        Matcher matcher = PATTERN_FOR_DATE_TIME.matcher(dateTime);
        if (ObjectUtils.isEmpty((Object)dateTime) || !matcher.find()) {
            return AjaxResult.error();
        }
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeTag = matcher.group("dateTime");
        Date now = sp.parse(timeTag);
        Date oneHourAgo = sp.parse(timeTag);
        long oneHour = 3600000L;
        oneHourAgo.setTime(oneHourAgo.getTime() - oneHour);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.select(new SFunction[]{ReMemStatus::getCollectTime, ReMemStatus::getValue, ReMemStatus::getResourceId}).eq(ReMemStatus::getResourceId, (Object)param.get("slot"))).between(ReMemStatus::getCollectTime, (Object)oneHourAgo, (Object)now)).orderByAsc(ReMemStatus::getCollectTime);
        return AjaxResult.success((Object)this.reMemStatusService.list((Wrapper)wrapper));
    }
}

