/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.resource;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.gson.Gson;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.system.entity.ReCpuStatus;
import com.uscale.system.entity.SysMonitor;
import com.uscale.system.service.IReCpuStatusService;
import com.uscale.system.service.SysMonitorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e3b\u63a7\u677f\u72b6\u6001"})
@RestController
@RequestMapping(value={"/resource/cpuStatus"})
public class ReCpuStatusController
extends BaseController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Gson GSON = new Gson();
    private static final Pattern PATTERN_FOR_DATE_TIME = Pattern.compile("(?<dateTime>\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})");
    private static final String CSV_COLUMN_SEPARATOR = ",";
    private static final String CSV_RN = "\r\n";
    private final IReCpuStatusService reCpuStatusService;
    private final SysMonitorService sysMonitorService;

    @Autowired
    public ReCpuStatusController(IReCpuStatusService reCpuStatusService, SysMonitorService sysMonitorService) {
        this.reCpuStatusService = reCpuStatusService;
        this.sysMonitorService = sysMonitorService;
    }

    @PostMapping
    public AjaxResult queryCpuStatus(@RequestBody Map<String, String> param) throws ParseException {
        this.LOGGER.debug("\u67e5\u8be2CPU\u72b6\u6001\uff0c\u63a5\u6536\u5230\u65f6\u95f4\u53c2\u6570\u4e3a\uff1aparam=[{}], date=[{}]", (Object)GSON.toJson(param), (Object)param.get("dateTime"));
        String dateTime = param.get("dateTime");
        Matcher matcher = PATTERN_FOR_DATE_TIME.matcher(dateTime);
        if (ObjectUtils.isEmpty((Object)dateTime) || !matcher.find()) {
            return AjaxResult.error();
        }
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = sp.parse(matcher.group("dateTime"));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{ReCpuStatus::getCollectTime, ReCpuStatus::getValue, ReCpuStatus::getResourceId});
        return AjaxResult.success((Object)this.reCpuStatusService.list((Wrapper)wrapper));
    }

    @PostMapping(value={"/history"})
    public AjaxResult queryCpuHistoryStatus(@RequestBody Map<String, String> param) throws ParseException {
        this.LOGGER.debug("\u67e5\u8be2CPU\u5386\u53f2\u72b6\u6001\uff0c\u63a5\u6536\u5230\u65f6\u95f4\u53c2\u6570\u4e3a\uff1aparam=[{}], date=[{}]", (Object)GSON.toJson(param), (Object)param.get("dateTime"));
        String dateTime = param.get("dateTime");
        Matcher matcher = PATTERN_FOR_DATE_TIME.matcher(dateTime);
        if (ObjectUtils.isEmpty((Object)dateTime) || !matcher.find()) {
            return AjaxResult.error();
        }
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeTag = matcher.group("dateTime");
        Date now = sp.parse(timeTag);
        Date oneHourAgo = sp.parse(timeTag);
        long oneHour = 3600000L;
        oneHourAgo.setTime(oneHourAgo.getTime() - oneHour);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.select(new SFunction[]{ReCpuStatus::getCollectTime, ReCpuStatus::getValue, ReCpuStatus::getResourceId}).eq(ReCpuStatus::getResourceId, (Object)param.get("slot"))).between(ReCpuStatus::getCollectTime, (Object)oneHourAgo, (Object)now)).orderByAsc(ReCpuStatus::getCollectTime);
        return AjaxResult.success((Object)this.reCpuStatusService.list((Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u63a7\u677f\u76d1\u63a7")
    @PostMapping(value={"/getSapmleMasterInfo"})
    public AjaxResult<List<SysMonitor>> getSapmleMasterInfo() {
        List sysMonitors = this.sysMonitorService.lastToLine(Integer.valueOf(300));
        if (sysMonitors != null && sysMonitors.size() < 10) {
            int count = sysMonitors.size();
            for (int i = 0; i < 10 - count; ++i) {
                SysMonitor sysMonitor = new SysMonitor();
                sysMonitor.setSampleTime(String.valueOf("0"));
                sysMonitors.add(sysMonitor);
            }
        }
        return AjaxResult.success((Object)sysMonitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5bfc\u51fa\u4e3b\u63a7\u677f\u76d1\u63a7\u6570\u636e")
    @GetMapping(value={"/export"})
    public void exportData(HttpServletResponse response) {
        List hourSysMonitor = this.sysMonitorService.get24HourSysMonitor();
        if (hourSysMonitor != null) {
            String result = this.csvFormat(hourSysMonitor);
            response.setContentType("application/octet-stream; charset=UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=cpuStatus.csv");
            ServletOutputStream outputStream = null;
            try {
                outputStream = response.getOutputStream();
                outputStream.write(result.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.LOGGER.debug("\u5bfc\u51fa\u7cfb\u7edf\u76d1\u63a7\u6570\u636e\u5f02\u5e38:{}", (Throwable)e);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String csvFormat(List<SysMonitor> hourSysMonitor) {
        StringBuffer result = new StringBuffer();
        for (SysMonitor bean : hourSysMonitor) {
            result.append(bean.getId()).append(CSV_COLUMN_SEPARATOR).append(bean.getCpuValue()).append(CSV_COLUMN_SEPARATOR).append(bean.getMemValue()).append(CSV_COLUMN_SEPARATOR).append(bean.getSampleTime()).append(CSV_RN);
        }
        return result.toString();
    }
}

