/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.resource;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.DateUtils;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.system.entity.Cdr;
import com.uscale.system.model.cdr.CdrQueryRequest;
import com.uscale.system.service.ICdrService;
import com.uscale.system.vo.CdrResponseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"CDR\u8bdd\u5355"})
@RestController
@RequestMapping(value={"/resource/cdr"})
public class CdrController
extends BaseController {
    @Resource
    private ICdrService cdrService;

    @ApiOperation(value="\u67e5\u8be2CDR\u8bb0\u5f55\u5217\u8868")
    @PostMapping(value={"/list"})
    public TableDataInfo<Cdr> list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") CdrQueryRequest recordQueryVo) {
        this.startPage();
        List pageInfo = this.cdrService.getCdrPageList(recordQueryVo);
        return this.getDataTable(pageInfo);
    }

    @ApiOperation(value="\u5220\u9664cdr\u8bdd\u5355")
    @Log(title="cdr\u8bdd\u5355\u5220\u9664", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/remove/{ids}"})
    public AjaxResult<?> remove(@PathVariable List<Integer> ids) {
        return this.cdrService.delete(ids);
    }

    @ApiOperation(value="\u5bfc\u51facdr\u8bdd\u5355")
    @Log(title="cdr\u8bdd\u5355\u5bfc\u51fa", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/exportCdrRecord/{ids}"})
    public AjaxResult<?> exportCdrRecord(@PathVariable List<Integer> ids, HttpServletResponse response) {
        List cdrData = this.cdrService.getCdrData(ids);
        ExcelUtil util = new ExcelUtil(CdrResponseVO.class);
        String date = DateUtils.getDateString();
        return util.exportExcel(cdrData, "cdrData_" + date);
    }

    @ApiOperation(value="\u6e05\u7a7acdr\u8bdd\u5355")
    @Log(title="cdr\u8bdd\u5355\u6e05\u7a7a", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/clearCdr"})
    public AjaxResult<?> clearCdr() {
        return this.cdrService.clearCdr();
    }
}

