/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.monitor;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.system.entity.SysCallLog;
import com.uscale.system.service.SysCallLogService;
import com.uscale.system.service.SysLogSwitchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u547c\u53eb\u65e5\u5fd7"})
@RestController
@RequestMapping(value={"/monitor/callLog"})
public class SysCallLogController
extends BaseController {
    private final SysCallLogService sysCallLogService;
    private final SysLogSwitchService sysLogSwitchService;

    @Autowired
    public SysCallLogController(SysCallLogService sysCallLogService, SysLogSwitchService sysLogSwitchService) {
        this.sysCallLogService = sysCallLogService;
        this.sysLogSwitchService = sysLogSwitchService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysCallLog sysCallLog) {
        this.startPage();
        String language = MessageUtils.getHeaderLanguage();
        if (StringUtils.equals((CharSequence)language, (CharSequence)"en")) {
            sysCallLog.setLang("en");
        } else {
            sysCallLog.setLang("zh");
        }
        List list = this.sysCallLogService.getSysCallLogs(sysCallLog);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u5220\u9664\u547c\u53eb\u65e5\u5fd7")
    @Log(title="\u547c\u53eb\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/remove/{ids}"})
    public AjaxResult remove(@PathVariable List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return this.toAjax(false);
        }
        return this.toAjax(this.sysCallLogService.removeSysCallLogByIds(ids));
    }

    @ApiOperation(value="\u5220\u9664\u5168\u90e8\u547c\u53eb\u65e5\u5fd7")
    @Log(title="\u547c\u53eb\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/removeAll"})
    public AjaxResult removeAll() {
        return this.toAjax(this.sysCallLogService.removeSysCallLogAll());
    }

    @ApiOperation(value="\u5bfc\u51fa\u547c\u53eb\u65e5\u5fd7")
    @Log(title="\u5bfc\u51fa\u547c\u53eb\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SysCallLog sysCallLog) {
        String language = MessageUtils.getHeaderLanguage();
        if (StringUtils.equals((CharSequence)language, (CharSequence)"en")) {
            sysCallLog.setLang("en");
        } else {
            sysCallLog.setLang("zh");
        }
        List list = this.sysCallLogService.getSysCallLogs(sysCallLog);
        ExcelUtil util = new ExcelUtil(SysCallLog.class);
        return util.exportExcel(list, MessageUtils.message((String)"SysCallLogController.call.log", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u83b7\u53d6\u547c\u53eb\u65e5\u5fd7\u5f00\u5173\u72b6\u6001")
    @GetMapping(value={"/getSysLogSwitchById"})
    public AjaxResult<String> getSysLogSwitchById() {
        String sysLogSwitch = this.sysLogSwitchService.getSysLogSwitchById();
        return AjaxResult.success((String)"ok", (Object)sysLogSwitch);
    }

    @ApiOperation(value="\u66f4\u65b0\u547c\u53eb\u65e5\u5fd7\u5f00\u5173")
    @Log(title="\u547c\u53eb\u65e5\u5fd7", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updateSysLogSwitchStatusById/{state}"})
    public AjaxResult<Void> updateSysLogSwitchStatusById(@PathVariable String state) {
        this.sysLogSwitchService.updateSysLogSwitchStatusById(state);
        return AjaxResult.success();
    }
}

