/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.monitor;

import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.common.utils.poi.ExcelUtil;
import com.uscale.system.entity.api.SysApiOperLog;
import com.uscale.system.service.ISysApiOperLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/monitor/apiOperlog"})
public class SysApiOperlogController
extends BaseController {
    @Autowired
    private ISysApiOperLogService operLogService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo<SysApiOperLog> list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SysApiOperLog operLog) {
        this.startPage();
        List list = this.operLogService.selectOperLogList(operLog);
        return this.getDataTable(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757")
    @GetMapping(value={"/getTitles"})
    public AjaxResult<List<HashMap<String, String>>> getTitles() {
        List list = this.operLogService.getTitles();
        return AjaxResult.success((Object)list);
    }

    @ApiOperation(value="\u5bfc\u51fa\u64cd\u4f5c\u65e5\u5fd7")
    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult<Object> export(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SysApiOperLog operLog) {
        List list = this.operLogService.selectOperLogList(operLog);
        if (!StringUtils.equals((CharSequence)MessageUtils.getHeaderLanguage(), (CharSequence)"zh")) {
            for (SysApiOperLog sysApiOperLog : list) {
                if (!StringUtils.equals((CharSequence)"\u5185\u7f51IP", (CharSequence)sysApiOperLog.getOperLocation())) continue;
                sysApiOperLog.setOperLocation("Intranet IP");
            }
        }
        ExcelUtil util = new ExcelUtil(SysApiOperLog.class);
        return util.exportExcel(list, MessageUtils.message((String)"SysOperlogController.Operation.log", (Object[])new Object[0]));
    }

    @ApiOperation(value="\u5220\u9664\u64cd\u4f5c\u8bb0\u5f55")
    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{operIds}"})
    public AjaxResult<Object> remove(@ApiParam(value="\u5220\u9664\u7684id") @PathVariable Long[] operIds) {
        return this.toAjax(this.operLogService.deleteOperLogByIds(operIds));
    }

    @ApiOperation(value="\u6e05\u7a7a\u64cd\u4f5c\u8bb0\u5f55")
    @Log(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/clean"})
    public AjaxResult<Object> clean() {
        this.operLogService.cleanOperLog();
        return AjaxResult.success();
    }
}

