/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.groupService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.GsSoftConsoleGroup;
import com.uscale.system.entity.GsSoftConsoleGroupMember;
import com.uscale.system.entity.SipUser;
import com.uscale.system.entity.TmCalleePrefixConfiguration;
import com.uscale.system.service.IGsSoftConsoleGroupMemberService;
import com.uscale.system.service.IGsSoftConsoleGroupService;
import com.uscale.system.service.ILocalNumberService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.ITmCalleePrefixConfigurationService;
import com.uscale.system.service.QueueMembersService;
import com.uscale.system.service.SsTelephoneBookService;
import com.uscale.system.tool.FormatStateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Api(tags={"\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u7ec4"})
@RestController
@RequestMapping(value={"/groupService/softConsoleGroup"})
public class GsSoftConsoleGroupController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsSoftConsoleGroupController.class);
    private static final Gson GSON = new Gson();
    private final JedisPool jedisPool;
    private final ISipUserService sipUserService;
    private final QueueMembersService queueMembersService;
    private final SsTelephoneBookService ssTelephoneBookService;
    private final IGsSoftConsoleGroupService gsSoftConsoleGroupService;
    private final IGsSoftConsoleGroupMemberService gsSoftConsoleGroupMemberService;
    private final ILocalNumberService iLocalNumberService;
    private final ITmCalleePrefixConfigurationService tmCalleePrefixConfigurationService;

    @Autowired
    public GsSoftConsoleGroupController(ISipUserService sipUserService, JedisPool jedisPool, QueueMembersService queueMembersService, SsTelephoneBookService ssTelephoneBookService, IGsSoftConsoleGroupService gsSoftConsoleGroupService, IGsSoftConsoleGroupMemberService gsSoftConsoleGroupMemberService, ILocalNumberService iLocalNumberService, ITmCalleePrefixConfigurationService tmCalleePrefixConfigurationService) {
        this.sipUserService = sipUserService;
        this.jedisPool = jedisPool;
        this.queueMembersService = queueMembersService;
        this.gsSoftConsoleGroupService = gsSoftConsoleGroupService;
        this.gsSoftConsoleGroupMemberService = gsSoftConsoleGroupMemberService;
        this.ssTelephoneBookService = ssTelephoneBookService;
        this.iLocalNumberService = iLocalNumberService;
        this.tmCalleePrefixConfigurationService = tmCalleePrefixConfigurationService;
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u7ec4\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u8d77\u59cb\u7ec4\u53f7") Integer startGroupNumber, @ApiParam(value="\u7ed3\u675f\u7ec4\u53f7") Integer endGroupNumber, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)startGroupNumber)) {
            wrapper.ge(GsSoftConsoleGroup::getGroupNumber, (Object)startGroupNumber);
        }
        if (!ObjectUtils.isEmpty((Object)endGroupNumber)) {
            wrapper.le(GsSoftConsoleGroup::getGroupNumber, (Object)endGroupNumber);
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        this.gsSoftConsoleGroupService.page((IPage)page, (Wrapper)wrapper);
        List records = page.getRecords();
        for (GsSoftConsoleGroup record : records) {
            record.setPassword("******");
            TmCalleePrefixConfiguration configuration = (TmCalleePrefixConfiguration)this.tmCalleePrefixConfigurationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"group_concat(prefix order by prefix ASC) AS prefix"}).eq((Object)"call_property", (Object)SipUserBusinessEnum.CALL_SOFT_CONSOLE_GROUP.getCode())).eq((Object)"soft_console_group_id", (Object)record.getGroupNumber()));
            record.setAccessPrefix(configuration != null ? configuration.getPrefix() : "");
        }
        return this.getDataTable(page);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u7ec4\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@ApiParam(value="\u8bdd\u52a1\u7ec4ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.gsSoftConsoleGroupService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u8bdd\u52a1\u7ec4", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsSoftConsoleGroup gsSoftConsoleGroup) {
        return this.gsSoftConsoleGroupService.create(gsSoftConsoleGroup);
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u8bdd\u52a1\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return AjaxResult.error((String)MessageUtils.message((String)"GsSoftConsoleGroupController.select.data", (Object[])new Object[0]));
        }
        return this.toAjax(this.gsSoftConsoleGroupService.deleteByIds(ids));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u7ec4\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/member/list"})
    public TableDataInfo listMember(@ApiParam(value="\u8bdd\u52a1\u7ec4\u7ec4\u53f7") Integer groupNumber, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LOGGER.debug("\u67e5\u8be2\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u7ec4\u6210\u5458\u5217\u8868,groupNumber=[{}]", (Object)groupNumber);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GsSoftConsoleGroupMember::getGroupNumber, (Object)groupNumber);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        this.gsSoftConsoleGroupMemberService.page((IPage)page, (Wrapper)wrapper);
        List deviceIds = page.getRecords().stream().map(GsSoftConsoleGroupMember::getMemberNumber).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deviceIds)) {
            LambdaQueryWrapper userWrapper = new LambdaQueryWrapper();
            userWrapper.select(new SFunction[]{SipUser::getNumber, SipUser::getDeviceId}).in(SipUser::getDeviceId, deviceIds);
            List userList = this.sipUserService.list((Wrapper)userWrapper);
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.select(1);
                userList.forEach(item -> page.getRecords().forEach(row -> {
                    if (row.getMemberNumber().equals(item.getDeviceId())) {
                        row.setMemberNumber(item.getNumber());
                        String json = jedis.get(RedisKeyEnum.EXTENSION_STATE.getKey() + item.getDeviceId());
                        json = FormatStateUtils.formatState((String)json);
                        row.setState(json);
                    }
                }));
            }
        }
        return this.getDataTable(page);
    }

    @ApiOperation(value="\u65b0\u589e\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u53f0\u7ec4\u6210\u5458")
    @Log(title="\u7ec4\u4e1a\u52a1:\u8bdd\u52a1\u7ec4:\u8bdd\u52a1\u53f0\u7ec4\u6210\u5458", businessType=BusinessType.INSERT)
    @PostMapping(value={"/member"})
    public AjaxResult addMember(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsSoftConsoleGroupMember member) {
        return this.gsSoftConsoleGroupMemberService.create(member);
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u4e1a\u52a1\uff1a\u8bdd\u52a1\u53f0\u7ec4\u6210\u5458")
    @Log(title="\u7ec4\u4e1a\u52a1:\u8bdd\u52a1\u7ec4:\u8bdd\u52a1\u53f0\u7ec4\u6210\u5458", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/member/{ids}"})
    public AjaxResult removeMember(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.in(GsSoftConsoleGroupMember::getId, ids)).select(new SFunction[]{GsSoftConsoleGroupMember::getMemberNumber});
        List list = this.gsSoftConsoleGroupMemberService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return AjaxResult.error((String)MessageUtils.message((String)"SipUserController.user.no", (Object[])new Object[0]));
        }
        List deviceIds = list.stream().map(item -> "PJSIP/" + item.getMemberNumber()).collect(Collectors.toList());
        this.queueMembersService.deleteMembers(deviceIds);
        return this.toAjax(this.gsSoftConsoleGroupMemberService.removeByIds(ids));
    }

    @ApiOperation(value="\u4fee\u6539\u8bdd\u52a1\u53f0\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u8bdd\u52a1\u7ec4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody GsSoftConsoleGroup gsSoftConsoleGroup) {
        return this.toAjax(this.gsSoftConsoleGroupService.updateById((Object)gsSoftConsoleGroup));
    }
}

