/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.groupService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.GsPagingGroup;
import com.uscale.system.entity.GsPagingGroupInitiators;
import com.uscale.system.entity.GsPagingGroupMember;
import com.uscale.system.enums.GsPagingGroupOuterOfficeInitiatorsEnum;
import com.uscale.system.service.GsPagingGroupInitiatorsService;
import com.uscale.system.service.GsPagingGroupMemberService;
import com.uscale.system.service.GsPagingGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u4e1a\u52a1\uff1a\u5bfb\u547c\u7ec4"})
@RestController
@RequestMapping(value={"/groupService/pagingGroup"})
public class GsPagingGroupController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsPagingGroupController.class);
    private final GsPagingGroupService gsPagingGroupService;
    private final GsPagingGroupMemberService gsPagingGroupMemberService;
    private final GsPagingGroupInitiatorsService gsPagingGroupInitiatorsService;

    @Autowired
    public GsPagingGroupController(GsPagingGroupService gsPagingGroupService, GsPagingGroupMemberService gsPagingGroupMemberService, GsPagingGroupInitiatorsService gsPagingGroupInitiatorsService) {
        this.gsPagingGroupService = gsPagingGroupService;
        this.gsPagingGroupMemberService = gsPagingGroupMemberService;
        this.gsPagingGroupInitiatorsService = gsPagingGroupInitiatorsService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfb\u547c\u7ec4\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u8d77\u59cb\u53f7\u7801") Integer startNumber, @ApiParam(value="\u7ed3\u675f\u53f7\u7801") Integer endNumber, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)startNumber)) {
            wrapper.ge(GsPagingGroup::getGroupId, (Object)startNumber);
        }
        if (!ObjectUtils.isEmpty((Object)endNumber)) {
            wrapper.le(GsPagingGroup::getGroupId, (Object)endNumber);
        }
        wrapper.orderByAsc(GsPagingGroup::getGroupId);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        this.gsPagingGroupService.page((IPage)page, (Wrapper)wrapper);
        return this.getDataTable(page);
    }

    @ApiOperation(value="\u5bfb\u547c\u7ec4\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{groupId}"})
    public AjaxResult getInfo(@ApiParam(value="\u5bfb\u547c\u7ec4ID") @PathVariable(value="groupId") Integer groupId) {
        return AjaxResult.success((Object)this.gsPagingGroupService.getById((Serializable)groupId));
    }

    @ApiOperation(value="\u65b0\u589e\u5bfb\u547c\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u547c\u7ec4", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsPagingGroup gsPagingGroup) {
        return this.toAjax(this.gsPagingGroupService.save((Object)gsPagingGroup));
    }

    @ApiOperation(value="\u4fee\u6539\u5bfb\u547c\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u547c\u7ec4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public AjaxResult edit(@RequestBody GsPagingGroup gsPagingGroup) {
        if (ObjectUtils.isEmpty((Object)gsPagingGroup)) {
            return AjaxResult.error();
        }
        if (gsPagingGroup.getId() < 0L) {
            return AjaxResult.error();
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(GsPagingGroup::getId, (Object)gsPagingGroup.getId());
        updateWrapper.set(GsPagingGroup::getName, (Object)gsPagingGroup.getName());
        updateWrapper.set(GsPagingGroup::getIntraOfficeInitiators, (Object)gsPagingGroup.getIntraOfficeInitiators());
        updateWrapper.set(GsPagingGroup::getOuterOfficeInitiators, (Object)(gsPagingGroup.getOuterOfficeInitiators() == GsPagingGroupOuterOfficeInitiatorsEnum.OUTER_OFFICE_INITIATORS_NONE ? "" : gsPagingGroup.getOuterOfficeInitiators()));
        updateWrapper.set(GsPagingGroup::getPriority, (Object)gsPagingGroup.getPriority());
        updateWrapper.set(GsPagingGroup::getPlayPromptTone, (Object)gsPagingGroup.getPlayPromptTone());
        return this.toAjax(this.gsPagingGroupService.update((Wrapper)updateWrapper));
    }

    @ApiOperation(value="\u5220\u9664\u5bfb\u547c\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u547c\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636e") @PathVariable List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return AjaxResult.error((String)MessageUtils.message((String)"GsPagingGroupController.select.data", (Object[])new Object[0]));
        }
        return this.toAjax(this.gsPagingGroupService.deleteByIds(ids));
    }

    @ApiOperation(value="\u5bfb\u547c\u7ec4\u5b57\u5178")
    @GetMapping(value={"/pagingGroupDict"})
    public AjaxResult getPagingGroupDict() {
        return AjaxResult.success((Object)this.gsPagingGroupService.getPagingGroupDict());
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/member/list"})
    public TableDataInfo listMember(@ApiParam(value="\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458\u7ec4\u53f7") Integer groupId, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LOGGER.debug("\u67e5\u8be2\u7ec4\u4e1a\u52a1\uff1a\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458\u5217\u8868,groupId=[{}]", (Object)groupId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GsPagingGroupMember::getGroupId, (Object)groupId);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.gsPagingGroupMemberService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/member/{id}"})
    public AjaxResult getMember(@ApiParam(value="\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.gsPagingGroupMemberService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u547c\u7ec4:\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458", businessType=BusinessType.INSERT)
    @PostMapping(value={"/member/add"})
    public AjaxResult addMember(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsPagingGroupMember member) {
        return AjaxResult.success((Object)this.gsPagingGroupMemberService.saveMember(member));
    }

    @ApiOperation(value="\u4fee\u6539\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458")
    @PostMapping(value={"/member/edit"})
    public AjaxResult updateMember(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody GsPagingGroupMember member) {
        return this.toAjax(this.gsPagingGroupMemberService.updateById((Object)member));
    }

    @ApiOperation(value="\u4fee\u6539\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u547c\u7ec4:\u5bfb\u547c\u7ec4\u7ec4\u5185\u6210\u5458", businessType=BusinessType.UPDATE)
    @DeleteMapping(value={"/member/{ids}"})
    public AjaxResult removeMember(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        return this.toAjax(this.gsPagingGroupMemberService.removeMember(ids));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u4e1a\u52a1\uff1a\u5bfb\u547c\u7ec4\u53d1\u8d77\u65b9\u6210\u5458")
    @GetMapping(value={"/initiators/list"})
    public TableDataInfo listInitiators(@ApiParam(value="\u53d1\u8d77\u65b9\u6210\u5458\u7ec4\u7ec4\u53f7") Integer groupId, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LOGGER.debug("\u67e5\u8be2\u7ec4\u4e1a\u52a1\uff1a\u5bfb\u547c\u7ec4\u53d1\u8d77\u65b9\u6210\u5458\u5217\u8868,groupId=[{}]", (Object)groupId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GsPagingGroupInitiators::getGroupId, (Object)groupId);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.gsPagingGroupInitiatorsService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u65b0\u589e\u7ec4\u4e1a\u52a1\uff1a\u5bfb\u547c\u7ec4\u53d1\u8d77\u65b9\u6210\u5458")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u547c\u7ec4:\u5bfb\u547c\u7ec4\u53d1\u8d77\u65b9\u6210\u5458", businessType=BusinessType.INSERT)
    @PostMapping(value={"/initiators"})
    public AjaxResult addInitiators(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsPagingGroupInitiators initiators) {
        Integer memberNumber = initiators.getMemberNumber();
        Integer count = initiators.getCount();
        for (int i = 0; i < count; ++i) {
            Integer newMemberNumber = memberNumber + i;
            initiators.setMemberNumber(newMemberNumber);
            this.gsPagingGroupInitiatorsService.save((Object)initiators);
        }
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u4e1a\u52a1\uff1a\u5bfb\u547c\u7ec4\u53d1\u8d77\u65b9\u6210\u5458")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u547c\u7ec4:\u5bfb\u547c\u7ec4\u53d1\u8d77\u65b9\u6210\u5458", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/initiators/{ids}"})
    public AjaxResult removeInitiators(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        return this.toAjax(this.gsPagingGroupInitiatorsService.removeByIds(ids));
    }
}

