/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.groupService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.GsMla;
import com.uscale.system.entity.SipUser;
import com.uscale.system.service.GsMlaService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u4e1a\u52a1"})
@RestController
@RequestMapping(value={"/groupService/mla"})
public class GsMlaController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsMlaController.class);
    private static final Gson GSON = new Gson();
    private final GsMlaService gsMlaServices;
    private final ISipUserService iSipUserService;

    @Autowired
    public GsMlaController(GsMlaService gsMlaServices, ISipUserService iSipUserService) {
        this.gsMlaServices = gsMlaServices;
        this.iSipUserService = iSipUserService;
    }

    @ApiOperation(value="\u67e5\u8be2MLA\u7ec4\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u5f00\u59cb\u53f7\u7801") Integer startNumber, @ApiParam(value="\u7ed3\u675f\u53f7\u7801") Integer endNumber, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)startNumber)) {
            wrapper.ge(GsMla::getMainNumber, (Object)endNumber);
        }
        if (!ObjectUtils.isEmpty((Object)endNumber)) {
            wrapper.le(GsMla::getMainNumber, (Object)endNumber);
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        this.gsMlaServices.page((IPage)page, (Wrapper)wrapper);
        return this.getDataTable(page);
    }

    @ApiOperation(value="\u83b7\u53d6MLA\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@ApiParam(value="MLA\u6570\u636eID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.gsMlaServices.getById((Serializable)id));
    }

    @Log(title="MLA", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsMla gsMla) {
        SipUser sipUser = this.iSipUserService.getSipUserByNumber(gsMla.getMainNumber());
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"GsMlaController.primaryNumber.notExist", (Object[])new Object[0]));
        }
        UserBusinessUtils.addComplexBusiness((String)SipUserBusinessEnum.GROUP_MLA.getCode(), (SipUser)sipUser);
        this.iSipUserService.updateById((Object)sipUser);
        gsMla.setMemberDeviceId(sipUser.getDeviceId());
        return this.toAjax(this.gsMlaServices.save((Object)gsMla));
    }

    @Log(title="MLA", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody GsMla gsMla) {
        return this.toAjax(this.gsMlaServices.updateById((Object)gsMla));
    }

    @Log(title="MLA", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return AjaxResult.error((String)MessageUtils.message((String)"GsMlaController.data.isEmpty", (Object[])new Object[0]));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{GsMla::getMemberDeviceId}).in(GsMla::getId, ids);
        List list = this.gsMlaServices.list((Wrapper)wrapper);
        HashSet deviceIds = new HashSet();
        list.forEach(item -> deviceIds.add(item.getMemberDeviceId()));
        return this.toAjax(this.gsMlaServices.removeByIds(ids));
    }
}

