/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.groupService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.enums.SipUserBusinessEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.GsHuntGroupMember;
import com.uscale.system.entity.LocalNumber;
import com.uscale.system.entity.SipUser;
import com.uscale.system.service.IGsHuntGroupMemberService;
import com.uscale.system.service.ILocalNumberService;
import com.uscale.system.service.ISipUserService;
import com.uscale.system.service.QueueMembersService;
import com.uscale.system.tool.UserBusinessUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458"})
@RestController
@RequestMapping(value={"/groupService/huntGroupMember"})
public class GsHuntGroupMemberController
extends BaseController {
    private final IGsHuntGroupMemberService gsHuntGroupMemberService;
    private final ISipUserService iSipUserService;
    private final ILocalNumberService iLocalNumberService;
    private final QueueMembersService queueMembersService;

    @Autowired
    public GsHuntGroupMemberController(IGsHuntGroupMemberService gsHuntGroupMemberService, ISipUserService iSipUserService, ILocalNumberService iLocalNumberService, QueueMembersService queueMembersService) {
        this.gsHuntGroupMemberService = gsHuntGroupMemberService;
        this.iSipUserService = iSipUserService;
        this.iLocalNumberService = iLocalNumberService;
        this.queueMembersService = queueMembersService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") GsHuntGroupMember gsHuntGroupMember, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (gsHuntGroupMember.getGroupNumber() != null) {
            wrapper.eq(GsHuntGroupMember::getGroupNumber, (Object)gsHuntGroupMember.getGroupNumber());
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.gsHuntGroupMemberService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@ApiParam(value="\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.gsHuntGroupMemberService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u7ebf\u7ec4:\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsHuntGroupMember gsHuntGroupMember) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.in(SipUser::getNumber, new Object[]{gsHuntGroupMember.getMemberNumber()})).or()).in(SipUser::getReplaceOldNumber, new Object[]{gsHuntGroupMember.getMemberNumber()});
        SipUser sipUser = (SipUser)this.iSipUserService.getOne((Wrapper)lambdaQueryWrapper);
        if (ObjectUtils.isEmpty((Object)sipUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"GsHuntGroupMemberController.user.notExist", (Object[])new Object[0]));
        }
        if (UserBusinessUtils.isOpenSimpleBusiness((String)SipUserBusinessEnum.SIMPLE_TELEPHONIST.getCode(), (SipUser)sipUser)) {
            return AjaxResult.error((String)MessageUtils.message((String)"GsHuntGroupMemberController.operator.activate", (Object[])new Object[0]));
        }
        gsHuntGroupMember.setMemberDeviceId(sipUser.getDeviceId());
        return this.gsHuntGroupMemberService.create(gsHuntGroupMember);
    }

    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u7ebf\u7ec4:\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458", businessType=BusinessType.UPDATE)
    @PostMapping(value={"edit"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody GsHuntGroupMember gsHuntGroupMember) {
        return this.toAjax(this.gsHuntGroupMemberService.updateById((Object)gsHuntGroupMember));
    }

    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u7ebf\u7ec4:\u5bfb\u7ebf\u7ec4\u7ec4\u5185\u6210\u5458", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.in(GsHuntGroupMember::getId, ids)).select(new SFunction[]{GsHuntGroupMember::getMemberDeviceId});
        List list = this.gsHuntGroupMemberService.list((Wrapper)lambdaQueryWrapper);
        ArrayList<String> deviceIds = new ArrayList<String>();
        List localNumberList = this.iLocalNumberService.queryLocalNumberByHuntGroupDeviceIds(list);
        for (LocalNumber item : localNumberList) {
            deviceIds.add(item.getDeviceProtocol() + "/" + item.getAccountcode());
        }
        this.queueMembersService.deleteMembers(deviceIds);
        return this.toAjax(this.gsHuntGroupMemberService.removeByIds(ids));
    }
}

