/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.groupService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.system.entity.GsHuntGroup;
import com.uscale.system.entity.GsHuntGroupMember;
import com.uscale.system.entity.QueueMembers;
import com.uscale.system.model.groupService.QueryGsHuntGroup;
import com.uscale.system.service.IGsHuntGroupMemberService;
import com.uscale.system.service.IGsHuntGroupService;
import com.uscale.system.service.QueueMembersService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfb\u7ebf\u7ec4"})
@RestController
@RequestMapping(value={"/groupService/huntGroup"})
public class GsHuntGroupController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsHuntGroupController.class);
    private final IGsHuntGroupService gsHuntGroupService;
    private final IGsHuntGroupMemberService iGsHuntGroupMemberService;
    private final QueueMembersService queueMembersService;

    @Autowired
    public GsHuntGroupController(IGsHuntGroupService gsHuntGroupService, IGsHuntGroupMemberService iGsHuntGroupMemberService, QueueMembersService queueMembersService) {
        this.gsHuntGroupService = gsHuntGroupService;
        this.iGsHuntGroupMemberService = iGsHuntGroupMemberService;
        this.queueMembersService = queueMembersService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5bfb\u7ebf\u7ec4\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") QueryGsHuntGroup gsHuntGroup, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable(this.gsHuntGroupService.queryByPage(page, gsHuntGroup));
    }

    @ApiOperation(value="\u83b7\u53d6\u5bfb\u7ebf\u7ec4\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@ApiParam(value="\u5bfb\u7ebf\u7ec4ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.gsHuntGroupService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589e\u5bfb\u7ebf\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u7ebf\u7ec4", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult add(@ApiParam(value="\u5f85\u6dfb\u52a0\u6570\u636e") @RequestBody GsHuntGroup gsHuntGroup) {
        return this.gsHuntGroupService.create(gsHuntGroup);
    }

    @ApiOperation(value="\u4fee\u6539\u5bfb\u7ebf\u7ec4")
    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u7ebf\u7ec4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fee\u6539\u6570\u636e") @RequestBody GsHuntGroup gsHuntGroup) {
        GsHuntGroup oldGsHuntGroup = (GsHuntGroup)this.gsHuntGroupService.getById((Serializable)gsHuntGroup.getId());
        if (!"3".equals(oldGsHuntGroup.getRingType()) && "3".equals(gsHuntGroup.getRingType())) {
            LambdaUpdateWrapper queueMembersWrapper = new LambdaUpdateWrapper();
            String queueName = "huntGroup:" + gsHuntGroup.getGroupNumber();
            queueMembersWrapper.eq(QueueMembers::getQueueName, (Object)queueName);
            queueMembersWrapper.set(QueueMembers::getPenalty, (Object)0);
            this.queueMembersService.update((Wrapper)queueMembersWrapper);
        } else if ("3".equals(oldGsHuntGroup.getRingType()) && !"3".equals(gsHuntGroup.getRingType())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(GsHuntGroupMember::getGroupNumber, (Object)gsHuntGroup.getGroupNumber());
            List huntGroupMemberList = this.iGsHuntGroupMemberService.list((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)huntGroupMemberList)) {
                for (GsHuntGroupMember gsHuntGroupMember : huntGroupMemberList) {
                    String queueName = "huntGroup:" + gsHuntGroup.getGroupNumber();
                    String inter = "PJSIP/" + gsHuntGroupMember.getMemberDeviceId();
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(QueueMembers::getQueueName, (Object)queueName);
                    updateWrapper.eq(QueueMembers::getInter, (Object)inter);
                    updateWrapper.set(QueueMembers::getPenalty, (Object)gsHuntGroupMember.getPriority());
                    this.queueMembersService.update((Wrapper)updateWrapper);
                }
            }
        }
        return this.toAjax(this.gsHuntGroupService.updateById((Object)gsHuntGroup));
    }

    @Log(title="\u7ec4\u4e1a\u52a1:\u5bfb\u7ebf\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable List<Long> ids) {
        return this.toAjax(this.gsHuntGroupService.deleteByIds(ids));
    }
}

