/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.groupService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.entity.GsBlfGroup;
import com.uscale.system.entity.SipUser;
import com.uscale.system.model.groupService.InsertGsBlfGroup;
import com.uscale.system.service.IGsBlfGroupService;
import com.uscale.system.service.ISipUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BLF\u7ec4"})
@RestController
@RequestMapping(value={"/groupService/blfGroup"})
public class GsBlfGroupController
extends BaseController {
    private final IGsBlfGroupService gsBlfGroupService;
    private final ISipUserService iSipUserService;

    @Autowired
    public GsBlfGroupController(IGsBlfGroupService gsBlfGroupService, ISipUserService iSipUserService) {
        this.gsBlfGroupService = gsBlfGroupService;
        this.iSipUserService = iSipUserService;
    }

    @ApiOperation(value="\u67e5\u8be2BLF\u7ec4\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") GsBlfGroup gsBlfGroup, @ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)gsBlfGroup.getBlfGroupName())) {
            wrapper.eq(GsBlfGroup::getBlfGroupName, (Object)gsBlfGroup.getBlfGroupName());
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.gsBlfGroupService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6BLF\u7ec4\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@ApiParam(value="BLF\u7ec4ID") @PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.gsBlfGroupService.getById((Serializable)id));
    }

    @ApiOperation(value="\u65b0\u589eBLF\u7ec4")
    @Log(title="BLF\u7ec4", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody InsertGsBlfGroup gsBlfGroup) {
        ArrayList<GsBlfGroup> gsBlfGroups = new ArrayList<GsBlfGroup>();
        Integer userNumber = new Integer(gsBlfGroup.getUserNumber());
        ArrayList<Integer> userNumbers = new ArrayList<Integer>();
        for (int i = 0; i < gsBlfGroup.getUserCount(); ++i) {
            userNumbers.add(userNumber);
            userNumber = gsBlfGroup.getNumberStep() + userNumber;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(SipUser::getNumber, userNumbers)).or()).in(SipUser::getReplaceOldNumber, userNumbers);
        int a = this.iSipUserService.count((Wrapper)wrapper);
        int b = gsBlfGroup.getUserCount();
        if (a != b) {
            return AjaxResult.error((int)500, (String)MessageUtils.message((String)"GsBlfGroupController.number.Illegal", (Object[])new Object[0]));
        }
        List deviceIds = this.iSipUserService.queryDeviceIdsByNumbers(userNumbers);
        for (int j = 0; j < userNumbers.size(); ++j) {
            GsBlfGroup g = new GsBlfGroup();
            g.setBlfGroupName(gsBlfGroup.getBlfGroupName());
            g.setUserNumber(String.valueOf(userNumbers.get(j)));
            g.setDeviceId((String)deviceIds.get(j));
            gsBlfGroups.add(g);
        }
        return this.toAjax(this.gsBlfGroupService.saveBatch(gsBlfGroups));
    }

    @ApiOperation(value="\u4fee\u6539BLF\u7ec4")
    @Log(title="BLF\u7ec4", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    public AjaxResult edit(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GsBlfGroup gsBlfGroup) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.in(SipUser::getNumber, new Object[]{gsBlfGroup.getUserNumber()})).or()).in(SipUser::getReplaceOldNumber, new Object[]{gsBlfGroup.getUserNumber()});
        SipUser one = (SipUser)this.iSipUserService.getOne((Wrapper)lambdaQueryWrapper);
        gsBlfGroup.setDeviceId(one.getDeviceId());
        return this.toAjax(this.gsBlfGroupService.updateById((Object)gsBlfGroup));
    }

    @ApiOperation(value="\u5220\u9664BLF\u7ec4")
    @Log(title="BLF\u7ec4", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@ApiParam(value="\u5f85\u5220\u9664\u6570\u636eID") @PathVariable Long[] ids) {
        return this.toAjax(this.gsBlfGroupService.removeByIds(Arrays.asList((Object[])ids.clone())));
    }
}

