/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.globalService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.config.TydicConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.common.utils.file.FileUtils;
import com.uscale.common.utils.file.MimeTypeUtils;
import com.uscale.common.utils.file.VoiceUtils;
import com.uscale.system.entity.GlsExternalRbt;
import com.uscale.system.service.IGlsExternalRbtService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5916\u7f6e\u5f69\u94c3"})
@RestController
@RequestMapping(value={"/externalRBT"})
public class GlsExternalRbtController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(GlsExternalRbtController.class);
    private final IGlsExternalRbtService glsExternalRbtService;

    @Autowired
    public GlsExternalRbtController(IGlsExternalRbtService glsExternalRbtService) {
        this.glsExternalRbtService = glsExternalRbtService;
    }

    @ApiOperation(value="\u4e0a\u4f20\u5916\u7f6e\u5f69\u94c3")
    @Log(title="\u5f69\u94c3:\u4e0a\u4f20", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/rbt"})
    public AjaxResult audio(@RequestParam(value="rbtType") String rbtType, MultipartFile file) {
        try {
            String filePath = TydicConfig.getMohFile();
            if (file == null) {
                return AjaxResult.error((String)MessageUtils.message((String)"GlsExternalRbtController.uploadedFile.isEmpty", (Object[])new Object[0]));
            }
            String originalFilename = file.getOriginalFilename();
            if (StringUtils.isBlank((CharSequence)originalFilename)) {
                return AjaxResult.error((String)MessageUtils.message((String)"GlsExternalRbtController.uploadedFile.isEmpty", (Object[])new Object[0]));
            }
            if (!StringUtils.endsWith((CharSequence)originalFilename, (CharSequence)".wav")) {
                return AjaxResult.error((String)MessageUtils.message((String)"GlsExternalRbtController.uploadedFile.formatError", (Object[])new Object[0]));
            }
            if (!StringUtils.equalsAny((CharSequence)rbtType, (CharSequence[])new CharSequence[]{"local", "trunk"})) {
                log.warn("\u5f69\u94c3\u7c7b\u578b\u6709\u8bef");
                return AjaxResult.error();
            }
            log.info("\u4e0a\u4f20\u5f69\u94c3\u6587\u4ef6\uff0c\u811a\u672c\u6587\u4ef6\u540d,fileName=[{}]", (Object)originalFilename);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"rbt_type", (Object)rbtType);
            GlsExternalRbt glsExternalRbt = (GlsExternalRbt)this.glsExternalRbtService.getOne((Wrapper)wrapper);
            if (glsExternalRbt == null) {
                glsExternalRbt = new GlsExternalRbt();
            }
            glsExternalRbt.setRbtType(rbtType);
            glsExternalRbt.setRbtName(originalFilename);
            glsExternalRbt.setRbtDate(new Date());
            FileUploadUtils.uploadMoh((String)filePath, (MultipartFile)file, (String[])MimeTypeUtils.RBT_EXTENSION, (String)(rbtType + ".wav"));
            this.glsExternalRbtService.saveOrUpdate((Object)glsExternalRbt);
            return AjaxResult.success((Object)glsExternalRbt);
        }
        catch (Exception e) {
            log.error("\u8bed\u97f3\u8d44\u6e90\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return AjaxResult.error((String)MessageUtils.message((String)"GlsExternalRbtController.voiceResource.uploadFailed", (Object[])new Object[0]));
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5916\u7f6e\u5f69\u94c3\u5217\u8868")
    @GetMapping(value={"/list"})
    public TableDataInfo list(@ApiParam(value="\u9875\u6570") Integer pageNum, @ApiParam(value="\u9875\u6761\u6570") Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.glsExternalRbtService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5916\u7f6e\u5f69\u94c3")
    @Log(title="\u5f69\u94c3", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/delRbt/{id}"})
    public AjaxResult deleteRbt(@PathVariable Long id) {
        GlsExternalRbt externalRbt = (GlsExternalRbt)this.glsExternalRbtService.getById((Serializable)id);
        if (externalRbt == null) {
            return AjaxResult.error();
        }
        String rbtType = externalRbt.getRbtType();
        String fileWavPath = TydicConfig.getMohFile() + File.separator + rbtType + ".wav";
        FileUtils.deleteFile((String)fileWavPath);
        this.glsExternalRbtService.removeById((Serializable)id);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2sip\u5bf9\u63a5\u670d\u52a1\u5668\u4fe1\u606f")
    @GetMapping(value={"/getSip"})
    public AjaxResult getSip() {
        return AjaxResult.success((Object)this.glsExternalRbtService.getSip());
    }

    @ApiOperation(value="\u83b7\u53d6\u5916\u7f6e\u5f69\u94c3\u4fe1\u606f")
    @GetMapping(value={"/get"})
    public AjaxResult getInfo() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        return AjaxResult.success((Object)this.glsExternalRbtService.getOne((Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u914d\u7f6e\u5916\u7f6e\u5f69\u94c3")
    @Log(title="\u5f69\u94c3", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") @RequestBody GlsExternalRbt glsExternalRbt) {
        return this.toAjax(this.glsExternalRbtService.saveOrUpdate((Object)glsExternalRbt));
    }

    @GetMapping(value={"/playbackRbt/{id}"})
    public void getRecordingFile(@ApiParam(value="id") @PathVariable(value="id") Integer id, HttpServletRequest request, HttpServletResponse response) {
        GlsExternalRbt glsExternalRbt = (GlsExternalRbt)this.glsExternalRbtService.getById((Serializable)id);
        if (ObjectUtils.isEmpty((Object)glsExternalRbt)) {
            return;
        }
        String path = TydicConfig.getMohFile() + File.separator + glsExternalRbt.getRbtType() + ".wav";
        VoiceUtils.play((String)path, (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

