/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.globalService;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.system.entity.Acltable;
import com.uscale.system.service.AcltableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ip\u5730\u5740\u8bbf\u95ee\u63a7\u5236"})
@RestController
@RequestMapping(value={"/globalService/acltable"})
public class AcltableController
extends BaseController {
    private final AcltableService acltableService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list/{page}/{size}"})
    @PreAuthorize(value="@ss.hasPermi('userMng:globalService:ipAddrPool:list')")
    public TableDataInfo list(@RequestBody Acltable acltable, @ApiParam(value="\u9875\u6761\u6570") @PathVariable Integer page, @ApiParam(value="\u9875\u6570") @PathVariable Integer size) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotEmpty((String)acltable.getName()), Acltable::getName, (Object)acltable.getName());
        wrapper.eq(Acltable::getSense, (Object)"permit");
        wrapper.ne(Acltable::getName, (Object)"all");
        wrapper.groupBy(Acltable::getName);
        wrapper.orderByAsc(Acltable::getName);
        wrapper.orderByAsc(Acltable::getRuleOrder);
        Page pageData = new Page((long)page.intValue(), (long)size.intValue());
        Page acltablePage = (Page)this.acltableService.page((IPage)pageData, (Wrapper)wrapper);
        for (Acltable record : acltablePage.getRecords()) {
            ArrayList list = new ArrayList();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(Acltable::getName, (Object)record.getName());
            queryWrapper.eq(Acltable::getSense, (Object)record.getSense());
            List acltableList = this.acltableService.list((Wrapper)queryWrapper);
            acltableList.forEach(obj -> list.add(obj.getRule()));
            record.setRules(list);
            record.setRule(StringUtils.join(list, (String)","));
        }
        return this.getDataTable(acltablePage);
    }

    @ApiOperation(value="\u6dfb\u52a0ip\u5730\u5740")
    @Log(title="ip\u5730\u5740\u6c60", businessType=BusinessType.INSERT)
    @PutMapping(value={""})
    @PreAuthorize(value="@ss.hasPermi('userMng:globalService:ipAddrPool:add')")
    public AjaxResult save(@RequestBody Acltable acltable) {
        if (StringUtils.equals((CharSequence)acltable.getName(), (CharSequence)"all")) {
            return AjaxResult.error((String)MessageUtils.message((String)"AclTableController.name.notAll", (Object[])new Object[0]));
        }
        return this.toAjax(this.acltableService.saveAcltable(acltable));
    }

    @ApiOperation(value="\u5220\u9664ip\u5730\u5740")
    @Log(title="ip\u5730\u5740\u6c60", businessType=BusinessType.DELETE)
    @DeleteMapping(value={""})
    @PreAuthorize(value="@ss.hasPermi('userMng:globalService:ipAddrPool:remove')")
    public AjaxResult delete(@RequestBody List<Acltable> acltableList) {
        return this.toAjax(this.acltableService.removeAcltables(acltableList));
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709")
    @GetMapping(value={"/allIndex"})
    public AjaxResult getAllIndex() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(Acltable::getName, (Object)"all");
        wrapper.groupBy(Acltable::getName);
        wrapper.orderByAsc(Acltable::getName);
        List list = this.acltableService.list((Wrapper)wrapper);
        ArrayList indexList = new ArrayList();
        list.forEach(obj -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("dictLabel", obj.getName());
            map.put("dictValue", obj.getName());
            indexList.add(map);
        });
        return AjaxResult.success(indexList);
    }

    public AcltableController(AcltableService acltableService) {
        this.acltableService = acltableService;
    }
}

