/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.common;

import com.uscale.common.config.TydicConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.exception.CustomException;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.StringUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.common.utils.file.FileUtils;
import com.uscale.framework.config.ServerConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class CommonController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Autowired
    private ServerConfig serverConfig;

    @GetMapping(value={"/"})
    public void root(HttpServletResponse response) throws IOException {
        response.sendRedirect("/index.html");
    }

    @GetMapping(value={"/index"})
    public void rootIndex(HttpServletResponse response) throws IOException {
        response.sendRedirect("/index.html");
    }

    @GetMapping(value={"common/download"})
    public void fileDownload(String fileName, Boolean delete, HttpServletResponse response, HttpServletRequest request) {
        try {
            if (!FileUtils.checkAllowDownload((String)fileName)) {
                throw new CustomException(MessageUtils.message((String)"CommonController.fileName.illegal", (Object[])new Object[]{fileName}));
            }
            String realFileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("_") + 1);
            String filePath = TydicConfig.getDownloadPath() + fileName;
            response.setContentType("application/octet-stream");
            FileUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)realFileName);
            FileUtils.writeBytes((String)filePath, (OutputStream)response.getOutputStream());
            if (delete.booleanValue()) {
                FileUtils.deleteFile((String)filePath);
            }
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @PostMapping(value={"/common/upload"})
    public AjaxResult<Map<String, Object>> uploadFile(MultipartFile file) {
        try {
            String filePath = TydicConfig.getUploadPath();
            String fileName = FileUploadUtils.upload((String)filePath, (MultipartFile)file);
            String url = this.serverConfig.getUrl() + fileName;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fileName", fileName);
            data.put("url", url);
            return AjaxResult.success(data);
        }
        catch (Exception e) {
            return AjaxResult.error((String)MessageUtils.message((String)"CommonController.upload.fail", (Object[])new Object[0]));
        }
    }

    @GetMapping(value={"/common/download/resource"})
    public void resourceDownload(String resource, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!FileUtils.checkAllowDownload((String)resource)) {
                throw new CustomException(MessageUtils.message((String)"CommonController.resourceFile.illegal", (Object[])new Object[]{resource}));
            }
            String localPath = TydicConfig.getProfile();
            String downloadPath = localPath + StringUtils.substringAfter((String)resource, (String)"/profile");
            String downloadName = StringUtils.substringAfterLast((String)downloadPath, (String)"/");
            response.setContentType("application/octet-stream");
            FileUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)downloadName);
            FileUtils.writeBytes((String)downloadPath, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

