/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.common;

import com.google.code.kaptcha.Producer;
import com.uscale.common.constant.Constants;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.enums.RedisKeyEnum;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.sign.Base64;
import com.uscale.common.utils.uuid.IdUtils;
import com.uscale.system.entity.SysMasterSlave;
import com.uscale.system.service.SysMasterSlaveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Api(value="\u9a8c\u8bc1\u7801\u64cd\u4f5c\u5904\u7406")
@RestController
public class CaptchaController {
    @Resource(name="captchaProducer")
    private Producer captchaProducer;
    @Resource(name="captchaProducerMath")
    private Producer captchaProducerMath;
    private static final String CAPTCHA_TYPE_MATH = "math";
    private static final String CAPTCHA_TYPE_CHAR = "char";
    @Value(value="${system.captchaType}")
    private String captchaType;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private SysMasterSlaveService sysMasterSlaveService;
    @Autowired
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u751f\u6210\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/captchaImage"})
    public AjaxResult<Map<String, Object>> getCode() {
        String uuid = IdUtils.simpleUUID();
        String verifyKey = "captcha_codes:" + uuid;
        String code = null;
        BufferedImage image = null;
        if (CAPTCHA_TYPE_MATH.equals(this.captchaType)) {
            String capText = this.captchaProducerMath.createText();
            String capStr = capText.substring(0, capText.lastIndexOf("@"));
            code = capText.substring(capText.lastIndexOf("@") + 1);
            image = this.captchaProducerMath.createImage(capStr);
        } else if (CAPTCHA_TYPE_CHAR.equals(this.captchaType)) {
            String capStr = code = this.captchaProducer.createText();
            image = this.captchaProducer.createImage(capStr);
        }
        this.redisTemplate.opsForValue().set((Object)verifyKey, (Object)code, (long)Constants.CAPTCHA_EXPIRATION.intValue(), TimeUnit.MINUTES);
        try (FastByteArrayOutputStream os = new FastByteArrayOutputStream();){
            if (image == null) {
                throw new IOException(MessageUtils.message((String)"CaptchaController.captcha.fail", (Object[])new Object[0]));
            }
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)os);
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("uuid", uuid);
        data.put("img", Base64.encode((byte[])os.toByteArray()));
        String mode = "";
        SysMasterSlave sysMasterSlave = this.sysMasterSlaveService.getMasterSlave();
        if (ObjectUtils.isNotEmpty((Object)sysMasterSlave)) {
            mode = sysMasterSlave.getType();
        }
        data.put("mode", mode);
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(1);
            String expirationDate = jedis.get(RedisKeyEnum.LICENSE_STATUS_ALARM.getKey());
            data.put("expirationDate", StringUtils.isBlank((CharSequence)expirationDate) ? "" : expirationDate);
            String status = jedis.get(RedisKeyEnum.LICENSE_STATUS.getKey());
            data.put("status", StringUtils.isBlank((CharSequence)status) ? "" : status);
        }
        return AjaxResult.success(data);
    }
}

