/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller.automatic;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.uscale.common.annotation.Log;
import com.uscale.common.config.TydicConfig;
import com.uscale.common.core.controller.BaseController;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.core.page.TableDataInfo;
import com.uscale.common.enums.AutomaticType;
import com.uscale.common.enums.BusinessType;
import com.uscale.common.utils.MessageUtils;
import com.uscale.common.utils.file.FileUploadUtils;
import com.uscale.common.utils.file.MimeTypeUtils;
import com.uscale.common.utils.file.VoiceUtils;
import com.uscale.system.entity.TmAutomatic;
import com.uscale.system.entity.TmAutomaticMenu;
import com.uscale.system.entity.TmAutomaticResource;
import com.uscale.system.service.ICommonDictService;
import com.uscale.system.service.TmAutomaticMenuService;
import com.uscale.system.service.TmAutomaticResourceService;
import com.uscale.system.service.TmAutomaticService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u81ea\u5b9a\u4e49\u603b\u673a"})
@RestController
@RequestMapping(value={"/systemMng/automatic"})
public class AutomaticController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomaticController.class);
    private final TmAutomaticResourceService tmAutomaticResourceService;
    private final TmAutomaticMenuService tmAutomaticMenuService;
    private final TmAutomaticService tmAutomaticService;
    private final ICommonDictService commonDictService;

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u81ea\u52a8\u603b\u673a\u5217\u8868")
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:menu:list')")
    @GetMapping(value={"/listAutomaticMenu"})
    public AjaxResult listAutomaticMenu(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") TmAutomaticMenu menu) {
        List menus = this.tmAutomaticMenuService.listAutomaticMenu(menu);
        return AjaxResult.success((Object)menus);
    }

    @ApiOperation(value="\u65b0\u589e\u81ea\u52a8\u603b\u673a\u6309\u952e")
    @Log(title="\u81ea\u52a8\u603b\u673a:\u65b0\u589e\u81ea\u52a8\u603b\u673a\u6309\u952e", businessType=BusinessType.INSERT)
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:menu:add')")
    @PostMapping(value={"/addAutomaticMenu"})
    public AjaxResult addAutomaticMenu(@RequestBody TmAutomaticMenu tmAutomaticMenu) {
        Long parentId;
        if (tmAutomaticMenu.getParentId() != 0L) {
            TmAutomaticMenu one;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            if (!ObjectUtils.isEmpty((Object)tmAutomaticMenu)) {
                wrapper.eq(TmAutomaticMenu::getParentId, (Object)tmAutomaticMenu.getParentId());
                wrapper.eq(TmAutomaticMenu::getDigit, (Object)tmAutomaticMenu.getDigit());
            }
            if ((one = (TmAutomaticMenu)this.tmAutomaticMenuService.getOne((Wrapper)wrapper)) != null) {
                return AjaxResult.error((String)MessageUtils.message((String)"AutomaticController.repeated.keys", (Object[])new Object[0]));
            }
        }
        if ((parentId = tmAutomaticMenu.getParentId()) != 0L) {
            LambdaQueryWrapper parentWrapper = new LambdaQueryWrapper();
            parentWrapper.eq(TmAutomaticMenu::getMenuId, (Object)parentId);
            TmAutomaticMenu parent = (TmAutomaticMenu)this.tmAutomaticMenuService.getOne((Wrapper)parentWrapper);
            if (!AutomaticType.VIDEOMENU.getCode().equals(parent.getMenuType())) {
                return AjaxResult.error((String)MessageUtils.message((String)"AutomaticController.superior.menu", (Object[])new Object[0]));
            }
        } else if (!AutomaticType.VIDEOMENU.getCode().equals(tmAutomaticMenu.getMenuType())) {
            tmAutomaticMenu.setExtensionMode(AutomaticType.EXTENSION_MODE_OFF.getCode());
        }
        this.tmAutomaticMenuService.saveOrUpdate((Object)tmAutomaticMenu);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u81ea\u52a8\u603b\u673a\u6309\u952e")
    @Log(title="\u81ea\u52a8\u603b\u673a", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:menu:edit')")
    @PutMapping(value={"/updateAutomaticMenu"})
    public AjaxResult updateAutomaticMenu(@RequestBody TmAutomaticMenu tmAutomaticMenu) {
        return this.toAjax(this.tmAutomaticMenuService.updateAutomaticMenu(tmAutomaticMenu));
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u81ea\u52a8\u603b\u673a")
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:menu:query')")
    @GetMapping(value={"/{menuId}"})
    public AjaxResult getInfo(@PathVariable Long menuId) {
        return AjaxResult.success((Object)this.tmAutomaticMenuService.getById((Serializable)menuId));
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u81ea\u52a8\u603b\u673a\u6309\u952e")
    @Log(title="\u81ea\u52a8\u603b\u673a", businessType=BusinessType.DELETE)
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:menu:remove')")
    @DeleteMapping(value={"/delAutomaticMenu/{id}"})
    public AjaxResult delAutomaticMenu(@PathVariable Long id) {
        this.tmAutomaticMenuService.removeById((Serializable)id);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u751f\u6210\u811a\u672c\u5b57\u5178")
    @GetMapping(value={"/gatAutomatic"})
    public AjaxResult gatAutomatic() {
        LOGGER.debug("\u751f\u6210\u811a\u672c\u5b57\u5178");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)0);
        List list = this.tmAutomaticMenuService.list((Wrapper)wrapper);
        ArrayList scriptDict = new ArrayList();
        list.forEach(item -> {
            HashMap<String, String> tmp = new HashMap<String, String>(2);
            tmp.put("dictValue", item.getMenuId().toString());
            tmp.put("dictLabel", item.getMenuId().toString());
            scriptDict.add(tmp);
        });
        return AjaxResult.success(scriptDict);
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u81ea\u52a8\u603b\u673a")
    @Log(title="\u81ea\u52a8\u603b\u673a", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/delAutomic/{id}"})
    public AjaxResult delAutomic(@PathVariable Long id) {
        this.tmAutomaticService.removeById((Serializable)id);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u4fee\u6539\u81ea\u52a8\u603b\u673a")
    @Log(title="\u81ea\u52a8\u603b\u673a", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/updateAutomic"})
    public AjaxResult updateAutomic(@RequestBody TmAutomatic tmAutomatic) {
        this.tmAutomaticService.updateById((Object)tmAutomatic);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u65b0\u589e\u81ea\u52a8\u603b\u673a")
    @Log(title="\u81ea\u52a8\u603b\u673a", businessType=BusinessType.INSERT)
    @PostMapping(value={"/addAutomic"})
    public AjaxResult addAutomic(@RequestBody TmAutomatic tmAutomatic) {
        this.tmAutomaticService.saveOrUpdate((Object)tmAutomatic);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u81ea\u52a8\u603b\u673a")
    @GetMapping(value={"/initAutomic"})
    public AjaxResult initAutomic() {
        HashMap<String, List> data = new HashMap<String, List>(16);
        List timeSegmentDict = this.commonDictService.getTimeSegmentDict();
        List audioResouece = this.commonDictService.getAudioResoueceDict();
        List consoleNumberDict = this.commonDictService.getConsoleNumberDict();
        data.put("audioResouece", audioResouece);
        data.put("timeSegmentDict", timeSegmentDict);
        data.put("consoleNumberDict", consoleNumberDict);
        return AjaxResult.success(data);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u81ea\u52a8\u603b\u673a\u5217\u8868")
    @GetMapping(value={"/listAutomatic"})
    public TableDataInfo listAutomatic(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") TmAutomatic automatic, @ApiParam(value="\u9875\u6761\u6570") Integer pageNum, @ApiParam(value="\u9875\u6570") Integer pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!ObjectUtils.isEmpty((Object)automatic.getAutomaticName())) {
            wrapper.eq(TmAutomatic::getAutomaticName, (Object)automatic.getAutomaticName());
        }
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.tmAutomaticService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u6839\u636eautomaticId\u67e5\u8be2\u81ea\u52a8\u603b\u673a")
    @GetMapping(value={"/getAutomatic/{automaticId}"})
    public AjaxResult getAutomatic(@PathVariable Long automaticId) {
        return AjaxResult.success((Object)this.tmAutomaticService.getById((Serializable)automaticId));
    }

    @ApiOperation(value="\u6839\u636eresourceId\u5220\u9664\u81ea\u52a8\u603b\u673a\u8d44\u6e90")
    @Log(title="\u81ea\u52a8\u603b\u673a", businessType=BusinessType.DELETE)
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:resource:remove')")
    @PostMapping(value={"/deleteResource/{resourceId}"})
    public AjaxResult deleteResource(@PathVariable Long resourceId) {
        TmAutomaticResource resource = (TmAutomaticResource)this.tmAutomaticResourceService.getById((Serializable)resourceId);
        File file = new File(TydicConfig.getAudioPath() + File.separator + resource.getResourceName());
        file.delete();
        this.tmAutomaticResourceService.removeById((Serializable)resourceId);
        return AjaxResult.success();
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u81ea\u52a8\u603b\u673a\u8d44\u6e90")
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:resource:list')")
    @GetMapping(value={"/queryAudio"})
    public TableDataInfo queryAudio(Integer pageNum, Integer pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        return this.getDataTable((Page)this.tmAutomaticResourceService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u4e0a\u4f20\u81ea\u52a8\u603b\u673a\u8d44\u6e90")
    @Log(title="\u81ea\u52a8\u603b\u673a:\u4e0a\u4f20", businessType=BusinessType.IMPORT)
    @PreAuthorize(value="@ss.hasPermi('systemMng:automatic:resource:upload')")
    @PostMapping(value={"/audio"})
    public AjaxResult audio(MultipartFile file) {
        try {
            String filePath = TydicConfig.getAudioPath();
            if (file == null) {
                return AjaxResult.error((String)MessageUtils.message((String)"AutomaticController.uploaded.file.is.empty", (Object[])new Object[0]));
            }
            String originalFilename = file.getOriginalFilename();
            if (StringUtils.isBlank((CharSequence)originalFilename)) {
                return AjaxResult.error((String)MessageUtils.message((String)"AutomaticController.uploaded.file.is.empty", (Object[])new Object[0]));
            }
            LOGGER.debug("\u4e0a\u4f20\u8bed\u97f3\u6587\u4ef6\uff0c\u811a\u672c\u6587\u4ef6\u540d,fileName=[{}]", (Object)originalFilename);
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"resource_name", (Object)originalFilename)).last("limit 1");
            TmAutomaticResource tmAutomaticResource = (TmAutomaticResource)this.tmAutomaticResourceService.getOne((Wrapper)wrapper);
            if (tmAutomaticResource != null) {
                return AjaxResult.error((String)MessageUtils.message((String)"AutomaticController.file.already.exists", (Object[])new Object[0]));
            }
            FileUploadUtils.uploadAudio((String)filePath, (MultipartFile)file, (String[])MimeTypeUtils.MEDIA_EXTENSION);
            tmAutomaticResource = new TmAutomaticResource();
            tmAutomaticResource.setResourceClass(originalFilename.substring(0, originalFilename.lastIndexOf(".")));
            tmAutomaticResource.setResourceName(originalFilename);
            tmAutomaticResource.setResourceDate(new Date());
            this.tmAutomaticResourceService.saveOrUpdate((Object)tmAutomaticResource);
            return AjaxResult.success((Object)tmAutomaticResource);
        }
        catch (Exception e) {
            LOGGER.error("\u8bed\u97f3\u8d44\u6e90\u4e0a\u4f20\u5931\u8d25");
            return AjaxResult.error((String)MessageUtils.message((String)"AutomaticController.voiceResource.uploadFailed", (Object[])new Object[0]));
        }
    }

    @GetMapping(value={"/playbackAudio/{resourceId}"})
    public AjaxResult getRecordingFile(@ApiParam(value="resourceId") @PathVariable(value="resourceId") Integer resourceId, HttpServletRequest request, HttpServletResponse response) {
        TmAutomaticResource tmAutomaticResource = (TmAutomaticResource)this.tmAutomaticResourceService.getById((Serializable)resourceId);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)tmAutomaticResource)) {
            return AjaxResult.error();
        }
        String path = TydicConfig.getAudioPath() + File.separator + tmAutomaticResource.getResourceName();
        VoiceUtils.play((String)path, (HttpServletRequest)request, (HttpServletResponse)response);
        return AjaxResult.success();
    }

    public AutomaticController(TmAutomaticResourceService tmAutomaticResourceService, TmAutomaticMenuService tmAutomaticMenuService, TmAutomaticService tmAutomaticService, ICommonDictService commonDictService) {
        this.tmAutomaticResourceService = tmAutomaticResourceService;
        this.tmAutomaticMenuService = tmAutomaticMenuService;
        this.tmAutomaticService = tmAutomaticService;
        this.commonDictService = commonDictService;
    }
}

