/*
 * Decompiled with CFR 0.152.
 */
package com.uscale.web.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.uscale.common.core.domain.AjaxResult;
import com.uscale.common.utils.MessageUtils;
import com.uscale.system.service.I18nLangService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pl.jalokim.propertiestojson.util.PropertiesToJsonConverter;

@Api(tags={"\u56fd\u9645\u5316"})
@RestController
@RequestMapping(value={"/i18n"})
public class LanguageController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageController.class);
    private static final PropertiesToJsonConverter CONVERTER = new PropertiesToJsonConverter();
    private final I18nLangService i18nLangService;

    @Autowired
    public LanguageController(I18nLangService i18nLangService) {
        this.i18nLangService = i18nLangService;
    }

    @ApiOperation(value="\u83b7\u53d6\u8bed\u8a00\u5305")
    @GetMapping(value={"/getLanguagePackage"})
    public AjaxResult<Object> getLanguagePackage(@ApiParam(value="\u8bed\u8a00\u7c7b\u578b") String lang) {
        LOGGER.debug("\u5207\u6362\u8bed\u8a00\u7c7b\u578b\uff0c\u5f53\u524d\uff1alocal=[{}], \u76ee\u6807\uff1alang=[{}]", (Object)MessageUtils.getHeaderLanguage(), (Object)lang);
        if (!StringUtils.containsAny((CharSequence)lang, (CharSequence[])new CharSequence[]{"zh", "en"})) {
            lang = "zh";
        }
        if (MessageUtils.LANG_CACHE.containsKey(lang)) {
            return AjaxResult.success((String)((String)MessageUtils.LANG_CACHE.get(lang)));
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"code", "val"}).eq((Object)"lang", (Object)lang);
        List langList = this.i18nLangService.list((Wrapper)wrapper);
        Properties properties = new Properties();
        langList.forEach(lan -> properties.setProperty(lan.getCode(), lan.getVal()));
        String json = CONVERTER.convertToJson(properties);
        MessageUtils.LANG_CACHE.put(lang, json);
        return AjaxResult.success((String)json);
    }
}

