-- 创建用户（如果不存在）
CREATE USER IF NOT EXISTS 'cgrates'@'localhost' IDENTIFIED BY 'CGRateS.org';
-- 授予权限
GRANT ALL PRIVILEGES ON cgrates.* TO 'cgrates'@'localhost' WITH GRANT OPTION;
-- 刷新权限
FLUSH PRIVILEGES;

USE `cgrates`;

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;
-- 删除SQL监控,文件上传菜单
delete from `sys_menu` where `menu_id` in(5, 30);
-- 定时任务
update `sys_menu` set `disable` = '1' where `menu_id` = 6;
-- 参数管理
update `sys_menu` set `disable` = '1' where `menu_id` = 27;
-- 费率管理
update `sys_menu` set `icon` = 'config' where `menu_id` = 32;
-- 动作规则
update `sys_menu` set `icon` = 'mudedi' where `menu_id` = 33;
-- 时间段
update `sys_menu` set `name_en` = 'Time Range' where `menu_id` = 42;
-- 计费器
update `sys_menu` set `disable` = '1',`icon` = 'mudedi' where `menu_id` = 43;
-- 动作
update `sys_menu` set `icon` = 'mudedi' where `menu_id` = 45;
-- 动作计划
update `sys_menu` set `icon` = 'config' where `menu_id` = 46;
-- 动作触发器
update `sys_menu` set `disable` = '1' where `menu_id` = 47;
-- 资源配置
update `sys_menu` set `disable` = '1' where `menu_id` = 51;
-- 会话监控
update `sys_menu` set `icon` = 'sousuo' where `menu_id` = 54;
-- 阈值管理
update `sys_menu` set `disable` = '1' where `menu_id` = 55;
-- 路由管理
update `sys_menu` set `disable` = '1' where `menu_id` = 56;
-- 过滤器
update `sys_menu` set `disable` = '1' where `menu_id` = 57;
-- 统计分析
update `sys_menu` set `disable` = '1' where `menu_id` = 58;
-- 高级配置
update `sys_menu` set `disable` = '1' where `menu_id` = 59;
-- 基础配置
update `sys_menu` set `icon` = 'shezhi' where `menu_id` = 61;
-- 报表管理
update `sys_menu` set `icon` = 'zhedie' where `menu_id` = 62;
-- 使用统计
update `sys_menu` set `icon` = 'tubiao' where `menu_id` = 63;
-- 系统备份
INSERT INTO `sys_menu` (`menu_id`, `parent_id`, `name_cn`, `url`, `perms`, `type`, `icon`, `order_num`, `name_en`, `disable`)
VALUES (64, 1, '系统备份', 'sys/backup', '', 1, 'config', 8, 'System backup', 0);

-- 租户表增加自动删除标志
ALTER TABLE `tb_tenant` ADD COLUMN `auto_delete` tinyint(1) NOT NULL DEFAULT 0;

-- 备份记录表
DROP TABLE IF EXISTS `sys_backup_record`;
CREATE TABLE `sys_backup_record` (
`id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '备份ID',
`backup_type` varchar(20) NOT NULL COMMENT '备份类型',
`file_path` varchar(500) NOT NULL COMMENT '备份文件路径',
`file_size` bigint DEFAULT NULL COMMENT '文件大小(字节)',
`status` varchar(20) NOT NULL COMMENT '备份状态',
`description` varchar(200) DEFAULT NULL COMMENT '备份描述',
`create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '备份时间',
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='系统备份记录';

SET FOREIGN_KEY_CHECKS = 1;