/*
 * Decompiled with CFR 0.152.
 */
package com.bms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.utils.FtpUtils;
import com.bms.entity.FileRecord;
import com.bms.mapper.FileRecordMapper;
import com.bms.service.FileRecordService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class FileRecordServiceImpl
extends ServiceImpl<FileRecordMapper, FileRecord>
implements FileRecordService {
    public List<FtpUtils.FileInfo> filterByNameAndChecksums(List<FtpUtils.FileInfo> fileInfos, String tenant) {
        if (fileInfos == null || fileInfos.isEmpty()) {
            return Collections.emptyList();
        }
        List filenames = fileInfos.stream().map(FtpUtils.FileInfo::getFullPath).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(FileRecord::getFilename, filenames);
        queryWrapper.eq(FileRecord::getTenant, (Object)tenant);
        List existingRecords = this.list((Wrapper)queryWrapper);
        if (existingRecords.isEmpty()) {
            return fileInfos;
        }
        Map<String, String> map = existingRecords.stream().collect(Collectors.toMap(FileRecord::getFilename, FileRecord::getChecksum));
        return fileInfos.stream().filter(record -> !map.containsKey(record.getFullPath()) || !((String)map.get(record.getFullPath())).equals(record.getChecksum())).collect(Collectors.toList());
    }

    public void saveOrUpdateRecord(String name, String checksum, String tenant) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FileRecord::getFilename, (Object)name);
        queryWrapper.eq(FileRecord::getTenant, (Object)tenant);
        FileRecord fileRecord = (FileRecord)this.getOne((Wrapper)queryWrapper, false);
        if (fileRecord == null) {
            fileRecord = new FileRecord();
            fileRecord.setFilename(name);
            fileRecord.setChecksum(checksum);
            fileRecord.setTenant(tenant);
            this.save((Object)fileRecord);
        } else {
            fileRecord.setChecksum(checksum);
            this.updateById((Object)fileRecord);
        }
    }
}

