/*
 * Decompiled with CFR 0.152.
 */
package com.bms.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.utils.SpringContextUtils;
import com.bms.entity.Bill;
import com.bms.mapper.BillMapper;
import com.bms.service.BillService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="billService")
public class BillServiceImpl
extends ServiceImpl<BillMapper, Bill>
implements BillService {
    public List<Long> getBillIdByTenant(String tenant) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{Bill::getId}).eq(Bill::getTenant, (Object)tenant)).eq(Bill::getProcessed, (Object)false)).list().stream().map(Bill::getId).collect(Collectors.toList());
    }

    public void saveBillBatch(List<Bill> bills) {
        if (bills == null || bills.isEmpty()) {
            return;
        }
        List filterBill = bills.stream().filter(item -> ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Bill::getSerialNumber, (Object)item.getSerialNumber())).eq(Bill::getOriginFilename, (Object)item.getOriginFilename())).eq(Bill::getTenant, (Object)item.getTenant())).count() == 0).collect(Collectors.toList());
        BillService billService = (BillService)SpringContextUtils.getBean((String)"billService", BillService.class);
        billService.saveBatch(filterBill);
    }

    public String billDealPercentage(String tenant) {
        int total = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(Bill::getTenant, (Object)tenant)).count();
        int processed = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Bill::getTenant, (Object)tenant)).eq(Bill::getProcessed, (Object)true)).count();
        if (total > 0) {
            return String.format("%.2f%%", (double)processed / (double)total * 100.0);
        }
        return "";
    }
}

