/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.enums.RedisKeyEnum;
import com.bms.common.utils.R;
import com.bms.common.utils.RedisUtils;
import com.bms.modules.sys.dao.SysUserTokenDao;
import com.bms.modules.sys.entity.SysUserTokenEntity;
import com.bms.modules.sys.jwt.TokenGenerator;
import com.bms.modules.sys.service.SysUserTokenService;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysUserTokenService")
public class SysUserTokenServiceImpl
extends ServiceImpl<SysUserTokenDao, SysUserTokenEntity>
implements SysUserTokenService {
    private static final int EXPIRE = 43200;
    @Autowired
    private RedisUtils redisUtils;

    public R createToken(long userId) {
        String token = TokenGenerator.generateValue();
        Date now = Date.from(Instant.now());
        Date expireTime = new Date(now.getTime() + 43200000L);
        Boolean open = this.redisUtils.getOpen();
        if (open.booleanValue()) {
            this.redisUtils.set(RedisKeyEnum.LOGIN_TOKEN.getKey() + userId, (Object)token, (long)RedisKeyEnum.LOGIN_TOKEN.getExpireTime().intValue());
        } else {
            SysUserTokenEntity tokenEntity = (SysUserTokenEntity)this.getById((Serializable)Long.valueOf(userId));
            if (tokenEntity == null) {
                tokenEntity = new SysUserTokenEntity();
                tokenEntity.setUserId(Long.valueOf(userId));
                tokenEntity.setToken(token);
                tokenEntity.setUpdateTime(now);
                tokenEntity.setExpireTime(expireTime);
                this.save((Object)tokenEntity);
            } else {
                tokenEntity.setToken(token);
                tokenEntity.setUpdateTime(now);
                tokenEntity.setExpireTime(expireTime);
                this.updateById((Object)tokenEntity);
            }
        }
        R r = R.ok().put("token", (Object)token).put("expire", (Object)43200);
        return r;
    }

    public void logout(long userId) {
        Boolean open = this.redisUtils.getOpen();
        if (open.booleanValue()) {
            this.redisUtils.delete(RedisKeyEnum.LOGIN_TOKEN.getKey() + userId);
        } else {
            String token = TokenGenerator.generateValue();
            SysUserTokenEntity tokenEntity = new SysUserTokenEntity();
            tokenEntity.setUserId(Long.valueOf(userId));
            tokenEntity.setToken(token);
            this.updateById((Object)tokenEntity);
        }
    }

    public Long getUserIdByToken(String token) {
        Boolean open = this.redisUtils.getOpen();
        if (open.booleanValue()) {
            Set keys = this.redisUtils.keys(RedisKeyEnum.LOGIN_TOKEN.getKey() + "*");
            for (String key : keys) {
                String storedToken = (String)this.redisUtils.get(key, String.class);
                if (!token.equals(storedToken)) continue;
                String userIdStr = key.replace(RedisKeyEnum.LOGIN_TOKEN.getKey(), "");
                return Long.parseLong(userIdStr);
            }
            return null;
        }
        SysUserTokenEntity tokenEntity = (SysUserTokenEntity)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().lt((Object)"expire_time", (Object)Date.from(Instant.now()))).eq((Object)"token", (Object)token));
        return tokenEntity != null ? tokenEntity.getUserId() : null;
    }
}

