/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.exception.RRException;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.Query;
import com.bms.modules.sys.dao.SysRoleDao;
import com.bms.modules.sys.dao.SysUserDao;
import com.bms.modules.sys.entity.SysRoleEntity;
import com.bms.modules.sys.service.SysRoleMenuService;
import com.bms.modules.sys.service.SysRoleService;
import com.bms.modules.sys.service.SysUserRoleService;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysRoleService")
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleDao, SysRoleEntity>
implements SysRoleService {
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysUserDao sysUserDao;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    public PageUtils queryPage(Map<String, Object> params) {
        String roleName = (String)params.get("roleName");
        Long createUserId = (Long)params.get("createUserId");
        IPage page = this.page(new Query().getPage(params), (Wrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((String)roleName), (Object)"role_name", (Object)roleName)).eq(createUserId != null, (Object)"create_user_id", (Object)createUserId));
        return new PageUtils(page);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveRole(SysRoleEntity role) {
        role.setCreateTime(Date.from(Instant.now()));
        this.save((Object)role);
        this.checkPrems(role);
        this.sysRoleMenuService.saveOrUpdate(role.getRoleId(), role.getMenuIdList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(SysRoleEntity role) {
        this.updateById((Object)role);
        this.checkPrems(role);
        this.sysRoleMenuService.saveOrUpdate(role.getRoleId(), role.getMenuIdList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] roleIds) {
        this.removeByIds(Arrays.asList(roleIds));
        this.sysRoleMenuService.deleteBatch(roleIds);
        this.sysUserRoleService.deleteBatch(roleIds);
    }

    public List<Long> queryRoleIdList(Long createUserId) {
        return ((SysRoleDao)this.baseMapper).queryRoleIdList(createUserId);
    }

    private void checkPrems(SysRoleEntity role) {
        if (role.getCreateUserId() == 1L) {
            return;
        }
        List menuIdList = this.sysUserDao.queryAllMenuId(role.getCreateUserId());
        if (!menuIdList.containsAll(role.getMenuIdList())) {
            throw new RRException(MessageUtils.getMessage((String)"role.add.exceed.permission", (Object[])new Object[0]));
        }
    }
}

