/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.utils.Constant;
import com.bms.common.utils.MapUtils;
import com.bms.modules.sys.dao.SysMenuDao;
import com.bms.modules.sys.entity.SysMenuEntity;
import com.bms.modules.sys.service.SysMenuService;
import com.bms.modules.sys.service.SysRoleMenuService;
import com.bms.modules.sys.service.SysUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysMenuService")
public class SysMenuServiceImpl
extends ServiceImpl<SysMenuDao, SysMenuEntity>
implements SysMenuService {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;

    public List<SysMenuEntity> queryListParentId(Long parentId, List<Long> menuIdList) {
        List menuList = this.queryListParentId(parentId);
        if (menuIdList == null) {
            return menuList;
        }
        ArrayList<SysMenuEntity> userMenuList = new ArrayList<SysMenuEntity>();
        for (SysMenuEntity menu : menuList) {
            if (!menuIdList.contains(menu.getMenuId())) continue;
            userMenuList.add(menu);
        }
        return userMenuList;
    }

    public List<SysMenuEntity> queryListParentId(Long parentId) {
        return ((SysMenuDao)this.baseMapper).queryListParentId(parentId);
    }

    public List<SysMenuEntity> queryNotButtonList() {
        return ((SysMenuDao)this.baseMapper).queryNotButtonList();
    }

    public List<SysMenuEntity> getUserMenuList(Long userId) {
        if (userId == 1L) {
            return this.getMenuList(null);
        }
        List menuIdList = this.sysUserService.queryAllMenuId(userId);
        return CollectionUtil.isNotEmpty((Collection)menuIdList) ? this.getMenuList(menuIdList) : new ArrayList();
    }

    private List<SysMenuEntity> getMenuList(List<Long> menuIdList) {
        List menus = ((SysMenuDao)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in(CollectionUtil.isNotEmpty(menuIdList), (Object)"menu_id", menuIdList)).ne((Object)"disable", (Object)true)).in((Object)"type", new Object[]{0, 1}));
        Collections.sort(menus);
        HashMap<Long, SysMenuEntity> menuMap = new HashMap<Long, SysMenuEntity>(12);
        for (SysMenuEntity s : menus) {
            menuMap.put(s.getMenuId(), s);
        }
        Iterator iterator = menus.iterator();
        while (iterator.hasNext()) {
            SysMenuEntity menu = (SysMenuEntity)iterator.next();
            SysMenuEntity parent = (SysMenuEntity)menuMap.get(menu.getParentId());
            if (!Objects.nonNull(parent)) continue;
            parent.getList().add(menu);
            iterator.remove();
        }
        return menus;
    }

    public void delete(Long menuId) {
        this.removeById((Serializable)menuId);
        this.sysRoleMenuService.removeByMap((Map)new MapUtils().put("menu_id", (Object)menuId));
    }

    private List<SysMenuEntity> getAllMenuList(List<Long> menuIdList) {
        List menuList = this.queryListParentId(Long.valueOf(0L), menuIdList);
        this.getMenuTreeList(menuList, menuIdList);
        return menuList;
    }

    private List<SysMenuEntity> getMenuTreeList(List<SysMenuEntity> menuList, List<Long> menuIdList) {
        ArrayList<SysMenuEntity> subMenuList = new ArrayList<SysMenuEntity>();
        for (SysMenuEntity entity : menuList) {
            if (entity.getType().intValue() == Constant.MenuType.CATALOG.getValue()) {
                entity.setList(this.getMenuTreeList(this.queryListParentId(entity.getMenuId(), menuIdList), menuIdList));
            }
            subMenuList.add(entity);
        }
        return subMenuList;
    }
}

