/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.exception.RRException;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.Query;
import com.bms.modules.sys.dao.SysConfigDao;
import com.bms.modules.sys.entity.SysConfigEntity;
import com.bms.modules.sys.redis.SysConfigRedis;
import com.bms.modules.sys.service.SysConfigService;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysConfigService")
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigDao, SysConfigEntity>
implements SysConfigService {
    @Autowired
    private SysConfigRedis sysConfigRedis;

    public PageUtils queryPage(Map<String, Object> params) {
        String paramKey = (String)params.get("paramKey");
        IPage page = this.page(new Query().getPage(params), (Wrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((String)paramKey), (Object)"param_key", (Object)paramKey)).eq((Object)"status", (Object)1));
        return new PageUtils(page);
    }

    public void saveConfig(SysConfigEntity config) {
        this.save((Object)config);
        this.sysConfigRedis.saveOrUpdate(config);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(SysConfigEntity config) {
        this.updateById((Object)config);
        this.sysConfigRedis.saveOrUpdate(config);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateValueByKey(String key, String value) {
        ((SysConfigDao)this.baseMapper).updateValueByKey(key, value);
        this.sysConfigRedis.delete(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] ids) {
        for (Long id : ids) {
            SysConfigEntity config = (SysConfigEntity)this.getById((Serializable)id);
            this.sysConfigRedis.delete(config.getParamKey());
        }
        this.removeByIds(Arrays.asList(ids));
    }

    public String getValue(String key) {
        SysConfigEntity config = this.sysConfigRedis.get(key);
        if (config == null) {
            config = ((SysConfigDao)this.baseMapper).queryByKey(key);
            this.sysConfigRedis.saveOrUpdate(config);
        }
        return config == null ? null : config.getParamValue();
    }

    public <T> T getConfigObject(String key, Class<T> clazz) {
        String value = this.getValue(key);
        if (StringUtils.isNotBlank((String)value)) {
            return (T)new Gson().fromJson(value, clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RRException(MessageUtils.getMessage((String)"config.getFail", (Object[])new Object[0]));
        }
    }
}

