/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.controller;

import com.bms.common.annotation.SysLog;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.R;
import com.bms.common.validator.Assert;
import com.bms.common.validator.ValidatorUtils;
import com.bms.common.validator.group.AddGroup;
import com.bms.common.validator.group.UpdateGroup;
import com.bms.modules.sys.controller.AbstractController;
import com.bms.modules.sys.entity.SysUserEntity;
import com.bms.modules.sys.form.PasswordForm;
import com.bms.modules.sys.service.SysUserRoleService;
import com.bms.modules.sys.service.SysUserService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController
extends AbstractController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sys:user:list"})
    public R list(@RequestParam Map<String, Object> params) {
        if (this.getUserId() != 1L) {
            params.put("createUserId", this.getUserId());
        }
        PageUtils page = this.sysUserService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @GetMapping(value={"/info"})
    public R info() {
        return R.ok().put("user", (Object)this.getUser());
    }

    @SysLog(value="Update Password")
    @PostMapping(value={"/password"})
    public R password(@RequestBody PasswordForm form) {
        Assert.isBlank((String)form.getNewPassword(), (String)MessageUtils.getMessage((String)"user.newPassword.Notnull", (Object[])new Object[0]));
        String password = new Sha256Hash((Object)form.getPassword(), (Object)this.getUser().getSalt()).toHex();
        String newPassword = new Sha256Hash((Object)form.getNewPassword(), (Object)this.getUser().getSalt()).toHex();
        boolean flag = this.sysUserService.updatePassword(this.getUserId(), password, newPassword);
        if (!flag) {
            return R.error((String)MessageUtils.getMessage((String)"user.oldPassword.incorrect", (Object[])new Object[0]));
        }
        return R.ok();
    }

    @GetMapping(value={"/info/{userId}"})
    @RequiresPermissions(value={"sys:user:info"})
    public R info(@PathVariable(value="userId") Long userId) {
        SysUserEntity user = (SysUserEntity)this.sysUserService.getById((Serializable)userId);
        List roleIdList = this.sysUserRoleService.queryRoleIdList(userId);
        user.setRoleIdList(roleIdList);
        return R.ok().put("user", (Object)user);
    }

    @SysLog(value="Save User")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"sys:user:save"})
    public R save(@RequestBody SysUserEntity user) {
        ValidatorUtils.validateEntity((Object)user, (Class[])new Class[]{AddGroup.class});
        user.setCreateUserId(this.getUserId());
        this.sysUserService.saveUser(user);
        return R.ok();
    }

    @SysLog(value="Update User")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"sys:user:update"})
    public R update(@RequestBody SysUserEntity user) {
        ValidatorUtils.validateEntity((Object)user, (Class[])new Class[]{UpdateGroup.class});
        user.setCreateUserId(this.getUserId());
        this.sysUserService.update(user);
        return R.ok();
    }

    @SysLog(value="Delete User")
    @PostMapping(value={"/delete"})
    @RequiresPermissions(value={"sys:user:delete"})
    public R delete(@RequestBody Long[] userIds) {
        if (ArrayUtils.contains((Object[])userIds, (Object)1L)) {
            return R.error((String)MessageUtils.getMessage((String)"user.sysAdmin.cannot.delete", (Object[])new Object[0]));
        }
        if (ArrayUtils.contains((Object[])userIds, (Object)this.getUserId())) {
            return R.error((String)MessageUtils.getMessage((String)"user.cannot.delete.self", (Object[])new Object[0]));
        }
        this.sysUserService.deleteBatch(userIds);
        return R.ok();
    }
}

