/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.sys.controller;

import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.R;
import com.bms.modules.sys.controller.AbstractController;
import com.bms.modules.sys.entity.SysUserEntity;
import com.bms.modules.sys.form.SysLoginForm;
import com.bms.modules.sys.service.SysCaptchaService;
import com.bms.modules.sys.service.SysUserService;
import com.bms.modules.sys.service.SysUserTokenService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysLoginController
extends AbstractController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private SysCaptchaService sysCaptchaService;

    @GetMapping(value={"captcha.jpg"})
    public void captcha(HttpServletResponse response, String uuid) throws IOException {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setContentType("image/jpeg");
        BufferedImage image = this.sysCaptchaService.getCaptcha(uuid);
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @PostMapping(value={"/sys/login"})
    public Map<String, Object> login(@RequestBody SysLoginForm form) throws IOException {
        boolean captcha = this.sysCaptchaService.validate(form.getUuid(), form.getCaptcha());
        if (!captcha) {
            return R.error((String)MessageUtils.getMessage((String)"captcha.error", (Object[])new Object[0]));
        }
        SysUserEntity user = this.sysUserService.queryByUserName(form.getUsername());
        if (user == null || !user.getPassword().equals(new Sha256Hash((Object)form.getPassword(), (Object)user.getSalt()).toHex())) {
            return R.error((String)MessageUtils.getMessage((String)"user.password.error", (Object[])new Object[0]));
        }
        if (user.getStatus() == 0) {
            return R.error((String)MessageUtils.getMessage((String)"user.account.locked", (Object[])new Object[0]));
        }
        R r = this.sysUserTokenService.createToken(user.getUserId().longValue());
        return r;
    }

    @PostMapping(value={"/sys/logout"})
    public R logout() {
        this.sysUserTokenService.logout(this.getUserId().longValue());
        return R.ok((String)MessageUtils.getMessage((String)"user.logout.success", (Object[])new Object[0]));
    }
}

