/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.oss.cloud;

import com.aliyun.oss.OSSClient;
import com.bms.common.exception.RRException;
import com.bms.modules.oss.cloud.CloudStorageConfig;
import com.bms.modules.oss.cloud.CloudStorageService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AliyunCloudStorageService
extends CloudStorageService {
    private OSSClient client;

    public AliyunCloudStorageService(CloudStorageConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.client = new OSSClient(this.config.getAliyunEndPoint(), this.config.getAliyunAccessKeyId(), this.config.getAliyunAccessKeySecret());
    }

    public String upload(byte[] data, String path) {
        return this.upload((InputStream)new ByteArrayInputStream(data), path);
    }

    public String upload(InputStream inputStream, String path) {
        try {
            this.client.putObject(this.config.getAliyunBucketName(), path, inputStream);
        }
        catch (Exception e) {
            throw new RRException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f", (Throwable)e);
        }
        return this.config.getAliyunDomain() + "/" + path;
    }

    public String uploadSuffix(byte[] data, String suffix) {
        return this.upload(data, this.getPath(this.config.getAliyunPrefix(), suffix));
    }

    public String uploadSuffix(InputStream inputStream, String suffix) {
        return this.upload(inputStream, this.getPath(this.config.getAliyunPrefix(), suffix));
    }
}

