/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.job.task;

import com.bms.common.utils.RedisUtils;
import com.bms.common.utils.SystemStatusUtils;
import com.bms.modules.job.task.ITask;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="systemStatusReadTask")
public class SystemStatusReadTask
implements ITask {
    private static final Logger log = LoggerFactory.getLogger(SystemStatusReadTask.class);
    @Autowired
    RedisUtils redisUtils;
    private static final String SYSTEM_STATUS_PREFIX = "bms:system:status:";
    private static final String CPU_STATUS_PREFIX = "bms:system:cpu:";
    private static final String MEMORY_STATUS_PREFIX = "bms:system:memory:";
    private static final String DISK_STATUS_PREFIX = "bms:system:disk:";
    private static final long EXPIRE_TIME = 46800L;

    public void run(String params) {
        try {
            LocalDateTime now = LocalDateTime.now();
            String timeKey = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd:HH"));
            Map systemStatus = this.collectSystemStatus();
            this.redisUtils.set(CPU_STATUS_PREFIX + timeKey, systemStatus.get("cpu"), 46800L);
            this.redisUtils.set(MEMORY_STATUS_PREFIX + timeKey, systemStatus.get("memory"), 46800L);
            this.redisUtils.set(DISK_STATUS_PREFIX + timeKey, systemStatus.get("disk"), 46800L);
            this.redisUtils.set(SYSTEM_STATUS_PREFIX + timeKey, (Object)systemStatus, 46800L);
            log.info("\u7cfb\u7edf\u72b6\u6001\u6570\u636e\u6536\u96c6\u5b8c\u6210: {}", (Object)timeKey);
        }
        catch (Exception e) {
            log.error("\u7cfb\u7edf\u72b6\u6001\u8bfb\u53d6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, Object> collectSystemStatus() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        try {
            java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            double cpuUsage = this.getCpuUsage(osBean);
            status.put("cpu", SystemStatusUtils.getCpuUsageByCommand());
            status.put("memory", SystemStatusUtils.getSystemMemoryLoad());
            int diskUsage = SystemStatusUtils.getDiskUsage();
            status.put("disk", diskUsage);
            double systemLoad = osBean.getSystemLoadAverage();
            status.put("systemLoad", systemLoad);
            int processors = osBean.getAvailableProcessors();
            status.put("processors", processors);
            status.put("timestamp", System.currentTimeMillis());
        }
        catch (Exception e) {
            log.error("\u6536\u96c6\u7cfb\u7edf\u72b6\u6001\u6570\u636e\u5931\u8d25", (Throwable)e);
            status.put("cpu", 0.0);
            status.put("memory", 0.0);
            status.put("disk", 0.0);
            status.put("systemLoad", 0.0);
            status.put("processors", 1);
            status.put("timestamp", System.currentTimeMillis());
        }
        return status;
    }

    private double getCpuUsage(java.lang.management.OperatingSystemMXBean osBean) {
        try {
            OperatingSystemMXBean sunOsBean;
            double cpuLoad;
            if (osBean instanceof OperatingSystemMXBean && (cpuLoad = (sunOsBean = (OperatingSystemMXBean)osBean).getProcessCpuLoad()) >= 0.0) {
                return Math.min(cpuLoad * 100.0, 100.0);
            }
            double systemLoad = osBean.getSystemLoadAverage();
            if (systemLoad > 0.0) {
                int processors = osBean.getAvailableProcessors();
                return Math.min(systemLoad / (double)processors * 100.0, 100.0);
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6CPU\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
        }
        return 0.0;
    }

    private double getMemoryUsage(MemoryMXBean memoryBean) {
        try {
            MemoryUsage heapMemory = memoryBean.getHeapMemoryUsage();
            long used = heapMemory.getUsed();
            long max = heapMemory.getMax();
            if (max > 0L) {
                return Math.min((double)used / (double)max * 100.0, 100.0);
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5185\u5b58\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
        }
        return 0.0;
    }

    public ArrayList<Double> getLast12HoursCpuStatus() {
        ArrayList<Double> cpuData = new ArrayList<Double>();
        LocalDateTime now = LocalDateTime.now();
        for (int i = 11; i >= 0; --i) {
            LocalDateTime timePoint = now.minusHours(i);
            String timeKey = timePoint.format(DateTimeFormatter.ofPattern("yyyy-MM-dd:HH"));
            String hourLabel = timePoint.format(DateTimeFormatter.ofPattern("HH:mm"));
            Double cpuUsage = (Double)this.redisUtils.get(CPU_STATUS_PREFIX + timeKey, Double.class);
            cpuData.add(cpuUsage != null ? cpuUsage : 0.0);
        }
        return cpuData;
    }

    public ArrayList<Double> getLast12HoursMemoryStatus() {
        ArrayList<Double> memoryData = new ArrayList<Double>();
        LocalDateTime now = LocalDateTime.now();
        for (int i = 11; i >= 0; --i) {
            LocalDateTime timePoint = now.minusHours(i);
            String timeKey = timePoint.format(DateTimeFormatter.ofPattern("yyyy-MM-dd:HH"));
            String hourLabel = timePoint.format(DateTimeFormatter.ofPattern("HH:mm"));
            Double memoryUsage = (Double)this.redisUtils.get(MEMORY_STATUS_PREFIX + timeKey, Double.class);
            memoryData.add(memoryUsage != null ? memoryUsage : 0.0);
        }
        return memoryData;
    }

    public ArrayList<Double> getLast12HoursDiskStatus() {
        ArrayList<Double> diskData = new ArrayList<Double>();
        LocalDateTime now = LocalDateTime.now();
        for (int i = 11; i >= 0; --i) {
            LocalDateTime timePoint = now.minusHours(i);
            String timeKey = timePoint.format(DateTimeFormatter.ofPattern("yyyy-MM-dd:HH"));
            String hourLabel = timePoint.format(DateTimeFormatter.ofPattern("HH:mm"));
            Double diskUsage = (Double)this.redisUtils.get(DISK_STATUS_PREFIX + timeKey, Double.class);
            diskData.add(diskUsage != null ? diskUsage : 0.0);
        }
        return diskData;
    }

    public Map<String, Object> getLast12HoursSystemStatus() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LocalDateTime now = LocalDateTime.now();
        ArrayList<String> hourLabels = new ArrayList<String>();
        for (int i = 11; i >= 0; --i) {
            LocalDateTime timePoint = now.minusHours(i);
            String hourLabel = timePoint.format(DateTimeFormatter.ofPattern("HH:00"));
            hourLabels.add(hourLabel);
        }
        result.put("cpu", this.getLast12HoursCpuStatus());
        result.put("memory", this.getLast12HoursMemoryStatus());
        result.put("disk", this.getLast12HoursDiskStatus());
        result.put("hourLabels", hourLabels);
        return result;
    }
}

