/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.job.task;

import com.alibaba.fastjson.JSON;
import com.bms.common.model.CgCdr;
import com.bms.common.model.CgResult;
import com.bms.entity.Bill;
import com.bms.entity.Tenant;
import com.bms.modules.job.task.ITask;
import com.bms.service.BillService;
import com.bms.service.CgRatesService;
import com.bms.service.TenantService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component(value="processBillTask")
public class ProcessBillTask
implements ITask {
    private static final Logger log = LoggerFactory.getLogger(ProcessBillTask.class);
    @Autowired
    private BillService billService;
    @Resource
    private CgRatesService cgratesService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private TenantService tenantService;

    public void run(String params) {
        log.debug("\u5f00\u59cb\u5904\u7406\u8bdd\u5355");
        List tenants = this.tenantService.filePushList();
        for (Tenant tenant : tenants) {
            this.threadPoolTaskExecutor.execute(() -> this.processBill(tenant.getTenant()));
        }
    }

    private void processBill(String tenant) {
        List billIds = this.billService.getBillIdByTenant(tenant);
        for (List billIdList : Lists.partition((List)billIds, (int)500)) {
            this.threadPoolTaskExecutor.execute(() -> {
                List bills = this.billService.listByIds((Collection)billIdList);
                for (Bill bill : bills) {
                    CgCdr cgCdr = new CgCdr();
                    this.transform(bill, cgCdr);
                    cgCdr.setTenant(tenant);
                    Object[] params = new Object[]{cgCdr};
                    CgResult cgResult = this.cgratesService.callCgRatesApiWithResult("CDRsV1.ProcessCDR", (Object)params, String.class);
                    log.info("cgResult - {}", (Object)JSON.toJSONString((Object)cgResult));
                    if (StringUtils.equals((CharSequence)((CharSequence)cgResult.getResult()), (CharSequence)"OK")) {
                        bill.setProcessed(Boolean.valueOf(true));
                        bill.setError("");
                        continue;
                    }
                    bill.setError(cgResult.getError());
                }
                this.billService.updateBatchById((Collection)bills);
            });
        }
    }

    private void transform(Bill bill, CgCdr cgCdr) {
        cgCdr.setCGRID(UUID.randomUUID().toString());
        cgCdr.setOriginID(String.valueOf(bill.getSerialNumber()));
        cgCdr.setSource("UScale BMS");
        cgCdr.setRequestType("*prepaid");
        cgCdr.setAccount(bill.getCallerNumber());
        cgCdr.setCategory("call");
        cgCdr.setSubject(bill.getCallerNumber());
        cgCdr.setDestination(bill.getCalleeNumber());
        byte answerYear = bill.getAnswerYear();
        byte answerMonth = bill.getAnswerMonth();
        byte answerDay = bill.getAnswerDay();
        byte answerHour = bill.getAnswerHour();
        byte answerMinute = bill.getAnswerMinute();
        byte answerSecond = bill.getAnswerSecond();
        int fullYear = 2000 + answerYear;
        LocalDateTime answerDateTime = LocalDateTime.of(fullYear, answerMonth, (int)answerDay, (int)answerHour, (int)answerMinute, (int)answerSecond);
        ZonedDateTime zonedDateTime = answerDateTime.atZone(ZoneId.systemDefault());
        String isoAnswerTime = zonedDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        cgCdr.setAnswerTime(isoAnswerTime);
        cgCdr.setSetupTime(isoAnswerTime);
        int duration = bill.getDuration();
        Long usage = (long)duration * 1000000000L;
        cgCdr.setUsage(usage);
    }
}

