/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.job.task;

import com.bms.common.utils.BillTool;
import com.bms.common.utils.FtpUtils;
import com.bms.entity.Bill;
import com.bms.entity.Tenant;
import com.bms.modules.job.task.ITask;
import com.bms.modules.job.task.ProcessBillTask;
import com.bms.service.BillService;
import com.bms.service.CgRatesService;
import com.bms.service.FileRecordService;
import com.bms.service.TenantService;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component(value="cdrReadTask")
public class CdrReadTask
implements ITask {
    private static final Logger log = LoggerFactory.getLogger(CdrReadTask.class);
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private FileRecordService fileRecordService;
    @Autowired
    private BillService billService;
    @Resource
    private CgRatesService cgRatesService;
    @Autowired
    private ProcessBillTask processBillTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String params) {
        log.debug("\u5f00\u59cb\u8bfb\u53d6\u8bdd\u5355\u6570\u636e");
        List tenants = this.tenantService.filePushList();
        boolean hasNewBill = false;
        for (Tenant tenant : tenants) {
            FtpUtils.FtpConfig ftpConfig = new FtpUtils.FtpConfig();
            ftpConfig.setProtocol(tenant.getProtocol());
            ftpConfig.setHost(tenant.getHost());
            ftpConfig.setPort(tenant.getPort().intValue());
            ftpConfig.setUsername(tenant.getUsername());
            ftpConfig.setPassword(tenant.getPassword());
            ftpConfig.setRemotePath(tenant.getPath());
            boolean connected = FtpUtils.testConnection((FtpUtils.FtpConfig)ftpConfig);
            if (!connected) {
                log.error("\u8fde\u63a5FTP/SFTP\u670d\u52a1\u5668\u5931\u8d25: {}", (Object)tenant.getHost());
                continue;
            }
            log.debug("\u5f00\u59cb\u9012\u5f52\u83b7\u53d6\u6240\u6709Bill_*.bill\u6587\u4ef6\uff0c\u8def\u5f84: {}", (Object)tenant.getPath());
            List billFiles = FtpUtils.listFilesRecursively((FtpUtils.FtpConfig)ftpConfig, (String)"Bill_*.bill");
            log.debug("\u627e\u5230{}\u4e2aBill_*.bill\u6587\u4ef6", (Object)billFiles.size());
            List filterByNameAndChecksums = this.fileRecordService.filterByNameAndChecksums(billFiles, tenant.getTenant());
            log.debug("\u8fc7\u6ee4\u540e\u9700\u8981\u5904\u7406{}\u4e2a\u65b0\u6587\u4ef6", (Object)filterByNameAndChecksums.size());
            hasNewBill = hasNewBill || !filterByNameAndChecksums.isEmpty();
            for (FtpUtils.FileInfo fileInfo : filterByNameAndChecksums) {
                String filePath = fileInfo.getFullPath();
                String originalPath = ftpConfig.getRemotePath();
                if (!fileInfo.getSubPath().isEmpty()) {
                    String subDirPath = originalPath + (originalPath.endsWith("/") ? "" : "/") + fileInfo.getSubPath();
                    ftpConfig.setRemotePath(subDirPath);
                }
                try {
                    String fileContent = FtpUtils.downloadFileToString((FtpUtils.FtpConfig)ftpConfig, (String)fileInfo.getName());
                    List<Bill> bills = BillTool.readBillFromString((String)fileContent).stream().filter(bill -> bill.getCallerAccessSignaling() == 15).collect(Collectors.toList());
                    bills.forEach(item -> {
                        item.setTenant(tenant.getTenant());
                        item.setOriginFilename(filePath);
                    });
                    String name = filePath;
                    String checksum = fileInfo.getChecksum();
                    this.billService.saveBillBatch(bills);
                    this.fileRecordService.saveOrUpdateRecord(name, checksum, tenant.getTenant());
                    List callerNumbers = bills.stream().map(Bill::getCallerNumber).distinct().collect(Collectors.toList());
                    List calleeNumbers = bills.stream().filter(bill -> bill.getCalleeAccessSignaling() == 15).map(Bill::getCalleeNumber).distinct().collect(Collectors.toList());
                    HashSet numberSet = new HashSet(callerNumbers);
                    numberSet.addAll(calleeNumbers);
                    Boolean createAccountByCdr = tenant.getCreateAccountByCdr();
                    if (!createAccountByCdr.booleanValue()) continue;
                    this.cgRatesService.saveCgRatesUser(numberSet, tenant);
                }
                catch (Exception e) {
                    log.error("\u5904\u7406\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath, (Object)e);
                }
                finally {
                    ftpConfig.setRemotePath(originalPath);
                }
            }
        }
        if (hasNewBill) {
            this.processBillTask.run("");
        }
    }

    public static void main(String[] args) {
        List bills = BillTool.readBillFromFile((String)"D:\\download\\ftp-test\\20250702\\Bill__20250702_00000000.bill");
        log.info("bills size - {}", (Object)bills.size());
    }
}

