/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bms.common.utils.Constant;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.Query;
import com.bms.modules.job.dao.ScheduleJobDao;
import com.bms.modules.job.entity.ScheduleJobEntity;
import com.bms.modules.job.service.ScheduleJobService;
import com.bms.modules.job.utils.ScheduleUtils;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scheduleJobService")
public class ScheduleJobServiceImpl
extends ServiceImpl<ScheduleJobDao, ScheduleJobEntity>
implements ScheduleJobService {
    @Autowired
    private Scheduler scheduler;

    @PostConstruct
    public void init() {
        List scheduleJobList = this.list();
        for (ScheduleJobEntity scheduleJob : scheduleJobList) {
            CronTrigger cronTrigger = ScheduleUtils.getCronTrigger((Scheduler)this.scheduler, (Long)scheduleJob.getJobId());
            if (cronTrigger == null) {
                ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
                continue;
            }
            ScheduleUtils.updateScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
        }
    }

    public PageUtils queryPage(Map<String, Object> params) {
        String beanName = (String)params.get("beanName");
        IPage page = this.page(new Query().getPage(params), (Wrapper)new QueryWrapper().like(StringUtils.isNotBlank((String)beanName), (Object)"bean_name", (Object)beanName));
        return new PageUtils(page);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveJob(ScheduleJobEntity scheduleJob) {
        scheduleJob.setCreateTime(Date.from(Instant.now()));
        scheduleJob.setStatus(Integer.valueOf(Constant.ScheduleStatus.NORMAL.getValue()));
        this.save((Object)scheduleJob);
        ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ScheduleJobEntity scheduleJob) {
        ScheduleUtils.updateScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
        this.updateById((Object)scheduleJob);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (Long)jobId);
        }
        this.removeByIds(Arrays.asList(jobIds));
    }

    public int updateBatch(Long[] jobIds, int status) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("list", Arrays.asList(jobIds));
        map.put("status", status);
        return ((ScheduleJobDao)this.baseMapper).updateBatch(map);
    }

    @Transactional(rollbackFor={Exception.class})
    public void run(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.run((Scheduler)this.scheduler, (ScheduleJobEntity)((ScheduleJobEntity)this.getById((Serializable)jobId)));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void pause(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.pauseJob((Scheduler)this.scheduler, (Long)jobId);
        }
        this.updateBatch(jobIds, Constant.ScheduleStatus.PAUSE.getValue());
    }

    @Transactional(rollbackFor={Exception.class})
    public void resume(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.resumeJob((Scheduler)this.scheduler, (Long)jobId);
        }
        this.updateBatch(jobIds, Constant.ScheduleStatus.NORMAL.getValue());
    }
}

