/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.dashboard.controller;

import com.bms.common.utils.R;
import com.bms.modules.dashboard.service.DashboardService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard"})
public class DashboardController {
    private static final Logger log = LoggerFactory.getLogger(DashboardController.class);
    @Autowired
    private DashboardService dashboardService;

    @GetMapping(value={"/overview"})
    public R getOverview() {
        try {
            Map overview = this.dashboardService.getSystemOverview();
            return R.ok().put("data", (Object)overview);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7cfb\u7edf\u6982\u89c8\u6570\u636e\u5931\u8d25", (Throwable)e);
            return R.error();
        }
    }

    @GetMapping(value={"/alerts"})
    public R getAlerts() {
        try {
            return R.ok().put("data", (Object)this.dashboardService.getSystemAlerts());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f02\u5e38\u8b66\u62a5\u5931\u8d25", (Throwable)e);
            return R.error();
        }
    }

    @GetMapping(value={"/metrics"})
    public R getMetrics() {
        try {
            Map metrics = this.dashboardService.getKeyMetrics();
            return R.ok().put("data", (Object)metrics);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5173\u952e\u6307\u6807\u6570\u636e\u5931\u8d25", (Throwable)e);
            return R.error();
        }
    }
}

