/*
 * Decompiled with CFR 0.152.
 */
package com.bms.modules.app.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="bms.jwt")
@Component
public class JwtUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String secret;
    private long expire;
    private String header;

    public String generateToken(long userId) {
        Date nowDate = Date.from(Instant.now());
        Date expireDate = new Date(nowDate.getTime() + this.expire * 1000L);
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setSubject(userId + "").setIssuedAt(nowDate).setExpiration(expireDate).signWith(SignatureAlgorithm.HS512, this.secret).compact();
    }

    public Claims getClaimByToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            this.logger.debug("validate is token error ", (Throwable)e);
            return null;
        }
    }

    public boolean isTokenExpired(Date expiration) {
        return expiration.before(Date.from(Instant.now()));
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

