/*
 * Decompiled with CFR 0.152.
 */
package com.bms.datasource.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.bms.datasource.config.DynamicDataSource;
import com.bms.datasource.config.DynamicDataSourceFactory;
import com.bms.datasource.properties.DataSourceProperties;
import com.bms.datasource.properties.DynamicDataSourceProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
public class DynamicDataSourceConfig {
    @Autowired
    private DynamicDataSourceProperties properties;

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.druid")
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public DynamicDataSource dynamicDataSource(DataSourceProperties dataSourceProperties) {
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        dynamicDataSource.setTargetDataSources(this.getDynamicDataSource());
        DruidDataSource defaultDataSource = DynamicDataSourceFactory.buildDruidDataSource((DataSourceProperties)dataSourceProperties);
        dynamicDataSource.setDefaultTargetDataSource((Object)defaultDataSource);
        return dynamicDataSource;
    }

    private Map<Object, Object> getDynamicDataSource() {
        Map dataSourcePropertiesMap = this.properties.getDatasource();
        HashMap<Object, Object> targetDataSources = new HashMap<Object, Object>(dataSourcePropertiesMap.size());
        dataSourcePropertiesMap.forEach((k, v) -> {
            DruidDataSource druidDataSource = DynamicDataSourceFactory.buildDruidDataSource((DataSourceProperties)v);
            targetDataSources.put(k, druidDataSource);
        });
        return targetDataSources;
    }
}

