/*
 * Decompiled with CFR 0.152.
 */
package com.bms.controller;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.bms.common.annotation.SysLog;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.PageUtils;
import com.bms.common.utils.R;
import com.bms.common.validator.ValidatorUtils;
import com.bms.entity.Tenant;
import com.bms.service.CgRatesService;
import com.bms.service.TenantService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
public class TenantController {
    private static final Logger log = LoggerFactory.getLogger(TenantController.class);
    @Autowired
    private TenantService tenantService;
    @Autowired
    private CgRatesService cgRatesService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"cgrate:tenant:list"})
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = this.tenantService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @RequestMapping(value={"/enableList"})
    public R enableList() {
        return R.ok().put("data", (Object)((LambdaQueryChainWrapper)this.tenantService.lambdaQuery().eq(Tenant::getEnable, (Object)true)).list());
    }

    @RequestMapping(value={"/allList"})
    public R allList() {
        return R.ok().put("data", (Object)this.tenantService.lambdaQuery().select(new SFunction[]{Tenant::getTenant, Tenant::getType}).list());
    }

    @RequestMapping(value={"/info/{jobId}"})
    @RequiresPermissions(value={"cgrate:tenant:info"})
    public R info(@PathVariable(value="jobId") Long jobId) {
        Tenant tenant = (Tenant)this.tenantService.getById((Serializable)jobId);
        return R.ok().put("tenant", (Object)tenant);
    }

    @SysLog(value="Save Pbx")
    @RequestMapping(value={"/save"})
    @RequiresPermissions(value={"cgrate:tenant:save"})
    public R save(@RequestBody Tenant tenant) {
        ValidatorUtils.validateEntity((Object)tenant, (Class[])new Class[0]);
        Long id = tenant.getId();
        if (id == null || id == 0L) {
            try {
                this.cgRatesService.initCgConfig(tenant.getTenant());
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316CGRates\u914d\u7f6e\u5931\u8d25", (Throwable)e);
                return R.error((String)MessageUtils.getMessage((String)"common.cgrates.not.connected", (Object[])new Object[0]));
            }
        }
        this.tenantService.saveOrUpdate((Object)tenant);
        return R.ok();
    }

    @SysLog(value="Delete Pbx")
    @RequestMapping(value={"/delete"})
    @RequiresPermissions(value={"cgrate:tenant:delete"})
    public R delete(@RequestBody Long[] ids) {
        this.tenantService.removeBatch(Arrays.asList(ids));
        return R.ok();
    }

    @SysLog(value="Update Pbx Status")
    @PostMapping(value={"/status/{status}"})
    public R status(@PathVariable(value="status") Boolean status, @RequestBody Long[] ids) {
        this.tenantService.updateBatchById((Collection)Arrays.stream(ids).map(id -> {
            Tenant tenant = new Tenant();
            tenant.setId(id);
            tenant.setEnable(status);
            return tenant;
        }).collect(Collectors.toList()));
        return R.ok();
    }
}

