/*
 * Decompiled with CFR 0.152.
 */
package com.bms.controller;

import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bms.common.annotation.SysLog;
import com.bms.common.enums.RedisKeyEnum;
import com.bms.common.exception.RRException;
import com.bms.common.model.AccountVo;
import com.bms.common.model.CdrSummaryVo;
import com.bms.common.model.CdrVo;
import com.bms.common.model.CgResult;
import com.bms.common.model.CgSession;
import com.bms.common.utils.ExcelUtils;
import com.bms.common.utils.LocaleUtils;
import com.bms.common.utils.MessageUtils;
import com.bms.common.utils.R;
import com.bms.common.utils.RedisUtils;
import com.bms.entity.Tenant;
import com.bms.service.CgRatesService;
import com.bms.service.TenantService;
import com.bms.service.TpStatsService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/cg"})
public class CGController {
    private static final Logger log = LoggerFactory.getLogger(CGController.class);
    @Resource
    private CgRatesService cgratesService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private TpStatsService tpStatsService;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/exportCDRs"})
    public void exportCDRs(HttpServletResponse response, @RequestBody Map<String, Object> params) throws IOException {
        List cdrs;
        Locale locale = LocaleUtils.getCurrentLocale();
        String language = locale.getLanguage();
        List tenants = (List)params.get("tenants");
        String tenant = (String)tenants.get(0);
        String tplFileName = "cdr_report_" + tenant + "_" + language + "_" + System.currentTimeMillis() + ".xlsx";
        String tplSheet = "cdr_report";
        try {
            CgResult listCgResult = this.cgratesService.callCgRatesApiWithTypeReference("APIerSv2.GetCDRs", (Object)new Object[]{params}, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            cdrs = (List)listCgResult.getResult();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6CDR\u5931\u8d25", (Throwable)e);
            cdrs = new ArrayList();
        }
        ExcelUtils.writeExcel2Stream((HttpServletResponse)response, CdrVo.class, cdrs, (String)tplFileName, (String)tplSheet);
    }

    @PostMapping(value={"/APIerSv1.GetTPStatIDs"})
    public R getTPStatIDs(@RequestBody Map<String, String> params) {
        String tpid = params.get("TPid");
        String tenant = params.get("Tenant");
        List statIds = this.tpStatsService.getStatIds(tpid, tenant);
        return R.ok().put("data", (Object)statIds);
    }

    @PostMapping(value={"/SessionSv1.GetActiveSessions"})
    public R getActiveSessions(@RequestBody Map<String, Object> params) {
        ArrayList cgSessions = new ArrayList();
        Set keys = this.redisUtils.keys(RedisKeyEnum.ACTIVE_SESSION.getKey() + "*");
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            keys.forEach(key -> {
                CgSession cgSession = (CgSession)this.redisUtils.get(key, CgSession.class);
                if (cgSession != null) {
                    cgSessions.add(cgSession);
                }
            });
        }
        if (CollectionUtils.isEmpty(cgSessions)) {
            return R.ok().put("data", new ArrayList());
        }
        for (CgSession cgSession : cgSessions) {
            Long answerTime = cgSession.getAnswerTime();
            long lastUsage = (System.currentTimeMillis() - answerTime) / 1000L;
            cgSession.setUsage(this.formatUsage(Long.valueOf(lastUsage)));
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                LocalDateTime answerDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(answerTime), ZoneId.systemDefault());
                ZonedDateTime zonedAnswerDateTime = answerDateTime.atZone(ZoneId.systemDefault());
                String isoAnswerTime = zonedAnswerDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                map.put("AnswerTime", isoAnswerTime);
                map.put("Category", "call");
                map.put("Destination", cgSession.getDestination());
                map.put("Subject", cgSession.getSubject());
                map.put("Tenant", cgSession.getTenant());
                map.put("Usage", lastUsage + "s");
                HashMap hashMap = (HashMap)this.cgratesService.callCgRatesApiForResult("APIerSv1.GetCost", (Object)new Object[]{map}, HashMap.class);
                Object cost = hashMap.get("Cost");
                cgSession.setMaxCostSoFar(new BigDecimal(cost.toString()));
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6\u4f1a\u8bdd\u8d39\u7528\u5931\u8d25", (Throwable)e);
            }
        }
        return R.ok().put("data", cgSessions);
    }

    @PostMapping(value={"/{method}"})
    public Object callCgRatesApi(@PathVariable(value="method") String method, @RequestBody Map<String, Object> params) {
        try {
            return this.cgratesService.callCgRatesApi(method, params.get("params"), Object.class);
        }
        catch (Exception e) {
            log.error("CGRates \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return R.error();
        }
    }

    @PostMapping(value={"/ping"})
    public R ping(@RequestBody Map<String, Object> params) {
        this.validateToken(params);
        return R.ok();
    }

    @PostMapping(value={"/processCDR"})
    public R processCDR(@RequestBody Map<String, Object> params) {
        this.validateToken(params);
        Object cdrParams = params.get("params");
        if (cdrParams == null) {
            return R.error();
        }
        String jsonString = JSON.toJSONString((Object)cdrParams);
        HashMap map = (HashMap)cdrParams;
        this.redisUtils.delete(RedisKeyEnum.ACTIVE_SESSION.getKey() + map.get("CGRID").toString());
        log.info("cdrParams - {}", (Object)jsonString);
        CgResult cgResult = this.cgratesService.callCgRatesApiWithResult("CDRsV1.ProcessCDR", (Object)new Object[]{cdrParams}, String.class);
        if (cgResult.getError() != null && !cgResult.getError().isEmpty()) {
            return R.error((String)("CGRates request failed: " + cgResult.getError()));
        }
        return R.ok();
    }

    @PostMapping(value={"/maxSessionTime"})
    public R maxSessionTime(@RequestBody Map<String, Object> params) {
        this.validateToken(params);
        Object cgParams = params.get("params");
        if (cgParams == null) {
            return R.error();
        }
        CgResult cgResult = this.cgratesService.callCgRatesApiWithResult("Responder.GetMaxSessionTime", (Object)new Object[]{cgParams}, String.class);
        if (cgResult.getError() != null && !cgResult.getError().isEmpty()) {
            return R.error((String)("CGRates request failed: " + cgResult.getError()));
        }
        return R.ok().put("data", cgResult.getResult());
    }

    @PostMapping(value={"/syncAccount"})
    public R syncAccount(@RequestBody Map<String, Object> params) {
        Tenant tenant = this.validateToken(params);
        String pbx = params.get("pbx").toString();
        Object cgParams = params.get("numbers");
        if (cgParams == null) {
            return R.error();
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(cgParams.toString().split(",")));
        this.cgratesService.saveCgRatesUser(set, tenant);
        return R.ok();
    }

    private Tenant validateToken(Map<String, Object> params) {
        String pbx;
        String date;
        Object tokenObj = params.get("token");
        Object dateObj = params.get("date");
        Object pbxObj = params.get("pbx");
        if (tokenObj == null || dateObj == null || pbxObj == null) {
            throw new RRException("param is not valid");
        }
        String token = tokenObj.toString();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{token, date = dateObj.toString(), pbx = pbxObj.toString()})) {
            throw new RRException("param is not valid");
        }
        Tenant tenant = this.tenantService.getOneByTenant(pbx);
        if (tenant == null) {
            throw new RRException("pbx sign not found");
        }
        String tenantToken = tenant.getToken();
        String mded5Hex = DigestUtil.md5Hex((String)(tenantToken + date));
        if (!mded5Hex.equals(token)) {
            throw new RRException("token is not valid");
        }
        this.redisUtils.set(RedisKeyEnum.PBX_STATUS.getKey() + tenant.getTenant(), (Object)1, (long)RedisKeyEnum.PBX_STATUS.getExpireTime().intValue());
        return tenant;
    }

    @SysLog(value="Import Account")
    @PostMapping(value={"/importAccount"})
    public R importAccount(@RequestParam(value="file") MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        if (StringUtils.isBlank((CharSequence)fileName) || !StringUtils.endsWith((CharSequence)fileName, (CharSequence)".xlsx") && !StringUtils.endsWith((CharSequence)fileName, (CharSequence)".xls")) {
            return R.error((String)MessageUtils.getMessage((String)"account.file.error", (Object[])new Object[0]));
        }
        List accountVos = EasyExcel.read((InputStream)file.getInputStream(), AccountVo.class, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).sheet().doReadSync();
        if (CollectionUtils.isEmpty((Collection)accountVos)) {
            return R.error((String)MessageUtils.getMessage((String)"account.file.empty", (Object[])new Object[0]));
        }
        this.validateAccount(accountVos);
        this.cgratesService.batchAddAccount(accountVos);
        return R.ok();
    }

    private void validateAccount(List<AccountVo> accountVos) {
        accountVos.stream().map(AccountVo::getTenant).distinct().forEach(tenant -> {
            if (this.tenantService.count((Wrapper)new LambdaQueryWrapper().eq(Tenant::getTenant, tenant)) == 0) {
                throw new RRException(MessageUtils.getMessage((String)"account.tenant.not.exist", (Object[])new Object[]{tenant}));
            }
        });
    }

    @GetMapping(value={"/importAccountTemplate"})
    public void importAccountTemplate(HttpServletResponse response) throws IOException {
        Locale locale = LocaleUtils.getCurrentLocale();
        String language = locale.getLanguage();
        String tplFileName = System.currentTimeMillis() + "account_mode_" + language + ".xlsx";
        String tplSheet = "account_mode";
        ExcelUtils.writeExcel2Stream((HttpServletResponse)response, AccountVo.class, new ArrayList(), (String)tplFileName, (String)tplSheet);
    }

    @GetMapping(value={"/exportAccount"})
    public void exportAccount(HttpServletResponse response) throws IOException {
        List list;
        Locale locale = LocaleUtils.getCurrentLocale();
        String language = locale.getLanguage();
        String tplFileName = System.currentTimeMillis() + "account_mode_" + language + ".xlsx";
        String tplSheet = "account_mode";
        ArrayList<AccountVo> accountVos = new ArrayList<AccountVo>();
        try {
            CgResult listCgResult = this.cgratesService.callCgRatesApiWithResult("APIerSv2.GetAccounts", (Object)new Object[]{new HashMap()}, List.class);
            list = (List)listCgResult.getResult();
        }
        catch (Exception e) {
            list = new ArrayList();
        }
        if (list != null) {
            for (Map map : list) {
                List monetaryBalances;
                AccountVo accountVo = new AccountVo();
                String id = map.get("ID").toString();
                accountVo.setAccount(id.split(":")[1]);
                accountVo.setTenant(id.split(":")[0]);
                accountVo.setDisabled(Boolean.valueOf(map.get("Disabled").toString()));
                BigDecimal balance = BigDecimal.ZERO;
                Map balanceMap = (Map)map.get("BalanceMap");
                if (balanceMap != null && CollectionUtils.isNotEmpty((Collection)(monetaryBalances = (List)balanceMap.get("*monetary")))) {
                    List decimalList = monetaryBalances.stream().map(item -> item.get("Value") != null ? new BigDecimal(item.get("Value").toString()) : BigDecimal.ZERO).collect(Collectors.toList());
                    balance = decimalList.stream().reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
                }
                accountVo.setBalance(balance);
                accountVos.add(accountVo);
            }
        }
        ExcelUtils.writeExcel2Stream((HttpServletResponse)response, AccountVo.class, accountVos, (String)tplFileName, (String)tplSheet);
    }

    @PostMapping(value={"/cdrSummary"})
    public R cdrSummary(@RequestBody Map<String, Object> params) {
        ArrayList<CdrSummaryVo> result = new ArrayList<CdrSummaryVo>();
        CgResult listCgResult = this.cgratesService.callCgRatesApiWithTypeReference("APIerSv2.GetCDRs", (Object)new Object[]{params}, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List cdrVos = (List)listCgResult.getResult();
        if (CollectionUtils.isEmpty((Collection)cdrVos)) {
            return R.ok().put("data", result);
        }
        HashMap<String, BigDecimal> costMap = new HashMap<String, BigDecimal>();
        HashMap<String, Long> usageMap = new HashMap<String, Long>();
        for (CdrVo cdrVo : cdrVos) {
            String account = cdrVo.getAccount();
            long totalSeconds = 0L;
            String usageStr = cdrVo.getUsage();
            if (StringUtils.isNotBlank((CharSequence)usageStr)) {
                Pattern secondPattern;
                Matcher secondMatcher;
                Pattern minutePattern;
                Matcher minuteMatcher;
                Pattern hourPattern = Pattern.compile("(\\d+)h");
                Matcher hourMatcher = hourPattern.matcher(usageStr);
                if (hourMatcher.find()) {
                    totalSeconds += Long.parseLong(hourMatcher.group(1)) * 3600L;
                }
                if ((minuteMatcher = (minutePattern = Pattern.compile("(\\d+)m")).matcher(usageStr)).find()) {
                    totalSeconds += Long.parseLong(minuteMatcher.group(1)) * 60L;
                }
                if ((secondMatcher = (secondPattern = Pattern.compile("(\\d+)s")).matcher(usageStr)).find()) {
                    totalSeconds += Long.parseLong(secondMatcher.group(1));
                }
            }
            usageMap.put(account, usageMap.getOrDefault(account, 0L) + totalSeconds);
            BigDecimal cost = cdrVo.getCost().compareTo(BigDecimal.ZERO) > 0 ? cdrVo.getCost() : BigDecimal.ZERO;
            costMap.put(account, costMap.getOrDefault(account, BigDecimal.ZERO).add(cost));
        }
        List accounts = cdrVos.stream().map(CdrVo::getAccount).distinct().collect(Collectors.toList());
        for (String account : accounts) {
            CdrSummaryVo summaryVo = new CdrSummaryVo();
            summaryVo.setAccount(account);
            summaryVo.setCost((BigDecimal)costMap.get(account));
            Long longUsage = (Long)usageMap.get(account);
            summaryVo.setUsage(this.formatUsage(longUsage));
            result.add(summaryVo);
        }
        return R.ok().put("data", result);
    }

    private String formatUsage(Long longUsage) {
        long hour = longUsage / 3600L;
        long minute = longUsage % 3600L / 60L;
        long second = longUsage % 60L;
        String usage = "";
        if (hour > 0L) {
            usage = usage + hour + "h";
        }
        if (minute > 0L) {
            usage = usage + minute + "m";
        }
        if (second > 0L) {
            usage = usage + second + "s";
        }
        return StringUtils.isBlank((CharSequence)usage) ? "0s" : usage;
    }

    @PostMapping(value={"/sessionStartInfo"})
    public R sessionStartInfo(@RequestBody Map<String, Object> params) {
        this.validateToken(params);
        Object cgParamsObj = params.get("cgSession");
        if (cgParamsObj == null) {
            return R.error();
        }
        String json = new Gson().toJson(cgParamsObj);
        CgSession cgSession = (CgSession)new Gson().fromJson(json, CgSession.class);
        String cgrid = cgSession.getCGRID();
        this.redisUtils.set(RedisKeyEnum.ACTIVE_SESSION.getKey() + cgrid, (Object)cgSession, (long)RedisKeyEnum.ACTIVE_SESSION.getExpireTime().intValue());
        return R.ok();
    }

    @PostMapping(value={"/APIerSv2.GetAccounts"})
    public Object accounts(@RequestBody Map<String, Object> params) {
        List mapList = (List)params.get("params");
        HashMap map = (HashMap)mapList.get(0);
        Object tenant = map.get("Tenant");
        Object keyword = map.get("keyword");
        if (tenant != null && keyword != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{keyword.toString(), tenant.toString()})) {
            List accountIds = this.cgratesService.getAccountIdsByTenant(tenant.toString(), keyword.toString());
            if (accountIds.isEmpty()) {
                return new CgResult();
            }
            map.put("AccountIDs", accountIds);
        }
        return this.cgratesService.callCgRatesApi("APIerSv2.GetAccounts", (Object)mapList, Object.class);
    }
}

