/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemStatusUtils {
    private static final Logger log = LoggerFactory.getLogger(SystemStatusUtils.class);

    public static void main(String[] args) {
        System.out.println(SystemStatusUtils.getSystemMemoryLoad());
        System.out.println(SystemStatusUtils.getCpuUsageByCommand());
    }

    public static long getSystemMemoryLoad() {
        Map systemMemoryByCommand = SystemStatusUtils.getSystemMemoryByCommand();
        Long total = (Long)systemMemoryByCommand.get("total");
        Long available = (Long)systemMemoryByCommand.get("available");
        long usage = total - available;
        return usage * 100L / total;
    }

    private static Map<String, Long> getSystemMemoryByCommand() {
        HashMap<String, Long> memoryInfo = new HashMap<String, Long>();
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("linux")) {
                return SystemStatusUtils.getLinuxMemoryInfo();
            }
            if (os.contains("windows")) {
                return SystemStatusUtils.getWindowsMemoryInfo();
            }
            if (os.contains("mac")) {
                return SystemStatusUtils.getMacMemoryInfo();
            }
        }
        catch (Exception e) {
            log.error("\u901a\u8fc7\u7cfb\u7edf\u547d\u4ee4\u83b7\u53d6\u5185\u5b58\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return memoryInfo;
    }

    private static Map<String, Long> getLinuxMemoryInfo() {
        HashMap<String, Long> memoryInfo = new HashMap<String, Long>();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("cat /proc/meminfo");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.startsWith("MemTotal:")) {
                    parts = line.split("\\s+");
                    long totalKB = Long.parseLong(parts[1]);
                    memoryInfo.put("total", totalKB * 1024L);
                    continue;
                }
                if (line.startsWith("MemAvailable:")) {
                    parts = line.split("\\s+");
                    long availableKB = Long.parseLong(parts[1]);
                    memoryInfo.put("available", availableKB * 1024L);
                    continue;
                }
                if (!line.startsWith("MemFree:")) continue;
                parts = line.split("\\s+");
                long freeKB = Long.parseLong(parts[1]);
                memoryInfo.put("free", freeKB * 1024L);
            }
            reader.close();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6Linux\u5185\u5b58\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return memoryInfo;
    }

    private static Map<String, Long> getWindowsMemoryInfo() {
        HashMap<String, Long> memoryInfo = new HashMap<String, Long>();
        try {
            String line;
            Process totalProcess = Runtime.getRuntime().exec("wmic computersystem get TotalPhysicalMemory /value");
            BufferedReader totalReader = new BufferedReader(new InputStreamReader(totalProcess.getInputStream(), "GBK"));
            while ((line = totalReader.readLine()) != null) {
                if (!line.startsWith("TotalPhysicalMemory=")) continue;
                long totalBytes = Long.parseLong(line.split("=")[1]);
                memoryInfo.put("total", totalBytes);
                break;
            }
            totalReader.close();
            totalProcess.waitFor();
            Process availableProcess = Runtime.getRuntime().exec("wmic OS get FreePhysicalMemory /format:value");
            BufferedReader availableReader = new BufferedReader(new InputStreamReader(availableProcess.getInputStream(), "GBK"));
            while ((line = availableReader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("FreePhysicalMemory=")) continue;
                String value = line.split("=")[1].trim();
                if (value.isEmpty()) break;
                long freeKB = Long.parseLong(value);
                memoryInfo.put("available", freeKB * 1024L);
                break;
            }
            availableReader.close();
            availableProcess.waitFor();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6Windows\u5185\u5b58\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return memoryInfo;
    }

    private static Map<String, Long> getMacMemoryInfo() {
        HashMap<String, Long> memoryInfo = new HashMap<String, Long>();
        try {
            Process process = Runtime.getRuntime().exec("sysctl hw.memsize");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null && line.contains("hw.memsize:")) {
                long totalBytes = Long.parseLong(line.split(":")[1].trim());
                memoryInfo.put("total", totalBytes);
            }
            reader.close();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6macOS\u5185\u5b58\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return memoryInfo;
    }

    public static double getCpuUsageByCommand() {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("linux")) {
                return SystemStatusUtils.getLinuxCpuUsage();
            }
            if (os.contains("windows")) {
                return SystemStatusUtils.getWindowsCpuUsage();
            }
            if (os.contains("mac")) {
                return SystemStatusUtils.getMacCpuUsage();
            }
        }
        catch (Exception e) {
            log.error("\u901a\u8fc7\u7cfb\u7edf\u547d\u4ee4\u83b7\u53d6CPU\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
        }
        return -1.0;
    }

    private static double getLinuxCpuUsage() {
        try {
            Process process = Runtime.getRuntime().exec("top -bn1 | grep 'Cpu(s)'");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null) {
                String[] parts;
                for (String part : parts = line.split(",")) {
                    if (!part.contains("id")) continue;
                    String idleStr = part.trim().split("\\s+")[0];
                    double idle = Double.parseDouble(idleStr);
                    return 100.0 - idle;
                }
            }
            reader.close();
            process.waitFor();
            return SystemStatusUtils.getLinuxCpuUsageFromProcStat();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6Linux CPU\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
            return -1.0;
        }
    }

    private static double getLinuxCpuUsageFromProcStat() {
        try {
            long[] stat1 = SystemStatusUtils.readProcStat();
            Thread.sleep(1000L);
            long[] stat2 = SystemStatusUtils.readProcStat();
            if (stat1 != null && stat2 != null) {
                long idle1 = stat1[3];
                long total1 = 0L;
                for (long val : stat1) {
                    total1 += val;
                }
                long idle2 = stat2[3];
                long total2 = 0L;
                for (long val : stat2) {
                    total2 += val;
                }
                long totalDiff = total2 - total1;
                long idleDiff = idle2 - idle1;
                if (totalDiff > 0L) {
                    return (double)(totalDiff - idleDiff) / (double)totalDiff * 100.0;
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ece/proc/stat\u83b7\u53d6CPU\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
        }
        return -1.0;
    }

    private static long[] readProcStat() {
        try {
            Process process = Runtime.getRuntime().exec("cat /proc/stat");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null && line.startsWith("cpu ")) {
                String[] parts = line.split("\\s+");
                long[] values = new long[parts.length - 1];
                for (int i = 1; i < parts.length; ++i) {
                    values[i - 1] = Long.parseLong(parts[i]);
                }
                reader.close();
                process.waitFor();
                return values;
            }
            reader.close();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6/proc/stat\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private static double getWindowsCpuUsage() {
        try {
            String line;
            Process process = Runtime.getRuntime().exec("wmic cpu get loadpercentage /format:value");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
            while ((line = reader.readLine()) != null) {
                String value;
                if (!(line = line.trim()).startsWith("LoadPercentage=") || (value = line.split("=")[1].trim()).isEmpty()) continue;
                return Double.parseDouble(value);
            }
            reader.close();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6Windows CPU\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
            return SystemStatusUtils.getWindowsCpuUsageByPowerShell();
        }
        return -1.0;
    }

    private static double getWindowsCpuUsageByPowerShell() {
        try {
            Process process = Runtime.getRuntime().exec("powershell -Command \"Get-Counter '\\Processor(_Total)\\% Processor Time' | Select-Object -ExpandProperty CounterSamples | Select-Object -ExpandProperty CookedValue\"");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null && !line.trim().isEmpty()) {
                return Double.parseDouble(line.trim());
            }
            reader.close();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u4f7f\u7528PowerShell\u83b7\u53d6Windows CPU\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
        }
        return -1.0;
    }

    private static double getMacCpuUsage() {
        try {
            String line;
            Process process = Runtime.getRuntime().exec("top -l 1 -n 0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (!line.contains("CPU usage:")) continue;
                for (String part : parts = line.split(",")) {
                    if (!part.contains("idle")) continue;
                    String idleStr = part.trim().split("%")[0];
                    double idle = Double.parseDouble(idleStr);
                    return 100.0 - idle;
                }
            }
            reader.close();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6macOS CPU\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
        }
        return -1.0;
    }

    public static int getDiskUsage() {
        try {
            File root = new File("/");
            if (!root.exists()) {
                root = new File("C:");
            }
            long totalSpace = root.getTotalSpace();
            long freeSpace = root.getFreeSpace();
            if (totalSpace > 0L) {
                long usedSpace = totalSpace - freeSpace;
                return (int)Math.min((double)usedSpace / (double)totalSpace * 100.0, 100.0);
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u78c1\u76d8\u4f7f\u7528\u7387\u5931\u8d25", (Throwable)e);
        }
        return 0;
    }
}

