/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.utils;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocaleUtils {
    public static Locale getCurrentLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static String getCurrentLanguage() {
        Locale locale = LocaleUtils.getCurrentLocale();
        return locale.toString().replace("_", "-");
    }

    public static boolean isCn() {
        Locale locale = LocaleUtils.getCurrentLocale();
        return Locale.SIMPLIFIED_CHINESE.equals(locale) || Locale.CHINESE.equals(locale) || "zh".equals(locale.getLanguage());
    }

    public static boolean isEn() {
        Locale locale = LocaleUtils.getCurrentLocale();
        return Locale.ENGLISH.equals(locale) || Locale.US.equals(locale) || "en".equals(locale.getLanguage());
    }

    public static boolean isLanguage(String language) {
        String currentLang = LocaleUtils.getCurrentLanguage();
        return language.equalsIgnoreCase(currentLang) || language.equalsIgnoreCase(LocaleUtils.getCurrentLocale().getLanguage());
    }

    public static String getLanguageFromRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            String language = request.getHeader("language");
            if (language != null && !language.isEmpty()) {
                return language;
            }
            language = request.getParameter("lang");
            if (language != null && !language.isEmpty()) {
                return language;
            }
        }
        return LocaleUtils.getCurrentLanguage();
    }

    public static String getLanguageDisplayName() {
        Locale locale = LocaleUtils.getCurrentLocale();
        if (LocaleUtils.isCn()) {
            return "\u7b80\u4f53\u4e2d\u6587";
        }
        if (LocaleUtils.isEn()) {
            return "English";
        }
        return locale.getDisplayName();
    }

    public static Locale getLocaleByLanguage(String language) {
        if (language == null || language.isEmpty()) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        switch (language.toLowerCase()) {
            case "zh-cn": 
            case "zh_cn": 
            case "zh": {
                return Locale.SIMPLIFIED_CHINESE;
            }
            case "en": 
            case "en-us": 
            case "en_us": {
                return Locale.ENGLISH;
            }
        }
        return Locale.forLanguageTag(language);
    }

    public static boolean isSupportedLanguage(String language) {
        return "zh-CN".equalsIgnoreCase(language) || "en".equalsIgnoreCase(language) || "zh".equalsIgnoreCase(language);
    }
}

