/*
 * Decompiled with CFR 0.152.
 */
package com.bms.common.utils;

import com.bms.common.utils.FtpUtils;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FtpUtils {
    private static final Logger log = LoggerFactory.getLogger(FtpUtils.class);

    public static FTPClient connectFtp(FtpConfig config) throws IOException {
        FTPClient ftpClient = new FTPClient();
        ftpClient.setConnectTimeout(config.getConnectTimeout());
        ftpClient.setDataTimeout(config.getDataTimeout());
        ftpClient.setControlEncoding(config.getEncoding());
        try {
            ftpClient.connect(config.getHost(), config.getPort());
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftpClient.disconnect();
                throw new IOException("FTP\u670d\u52a1\u5668\u62d2\u7edd\u8fde\u63a5\uff0c\u54cd\u5e94\u7801: " + reply);
            }
            if (!ftpClient.login(config.getUsername(), config.getPassword())) {
                ftpClient.disconnect();
                throw new IOException("FTP\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d: " + config.getUsername());
            }
            ftpClient.setFileType(2);
            if (config.isPassiveMode()) {
                ftpClient.enterLocalPassiveMode();
            }
            if (config.getRemotePath() != null && !config.getRemotePath().isEmpty() && !ftpClient.changeWorkingDirectory(config.getRemotePath())) {
                throw new IOException("\u65e0\u6cd5\u5207\u6362\u5230\u8fdc\u7a0b\u76ee\u5f55: " + config.getRemotePath());
            }
            return ftpClient;
        }
        catch (IOException e) {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void disconnectFtp(FTPClient ftpClient) {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                ftpClient.logout();
                ftpClient.disconnect();
            }
            catch (IOException e) {
                log.error("\u5173\u95edFTP\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static Map<String, Object> connectSftp(FtpConfig config) throws JSchException {
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp channelSftp = null;
        try {
            session = jsch.getSession(config.getUsername(), config.getHost(), config.getPort());
            session.setPassword(config.getPassword());
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            session.setConfig(properties);
            session.setTimeout(config.getConnectTimeout());
            session.connect();
            channelSftp = (ChannelSftp)session.openChannel("sftp");
            channelSftp.connect(config.getConnectTimeout());
            if (config.getRemotePath() != null && !config.getRemotePath().isEmpty()) {
                try {
                    channelSftp.cd(config.getRemotePath());
                }
                catch (SftpException e) {
                    throw new JSchException("\u65e0\u6cd5\u5207\u6362\u5230\u8fdc\u7a0b\u76ee\u5f55: " + config.getRemotePath());
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("session", session);
            result.put("channel", channelSftp);
            return result;
        }
        catch (JSchException e) {
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
            throw e;
        }
    }

    public static void disconnectSftp(ChannelSftp channelSftp, Session session) {
        if (channelSftp != null && channelSftp.isConnected()) {
            channelSftp.disconnect();
        }
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileInfo> listFtpFiles(FtpConfig config, String filePattern) {
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            FTPFile[] ftpFiles = ftpClient.listFiles();
            WildcardFileFilter filter = new WildcardFileFilter(filePattern);
            for (FTPFile ftpFile : ftpFiles) {
                if (!filter.accept(null, ftpFile.getName())) continue;
                long modifyTime = ftpFile.getTimestamp() != null ? ftpFile.getTimestamp().getTimeInMillis() : 0L;
                FileInfo fileInfo = new FileInfo(ftpFile.getName(), ftpFile.getSize(), modifyTime, ftpFile.isDirectory());
                fileInfoList.add(fileInfo);
            }
        }
        catch (IOException e) {
            log.error("\u5217\u51faFTP\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
        return fileInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileInfo> listSftpFiles(FtpConfig config, String filePattern) {
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        Map connectionMap = null;
        try {
            connectionMap = FtpUtils.connectSftp((FtpConfig)config);
            ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
            Session session = (Session)connectionMap.get("session");
            Vector fileList = channelSftp.ls("*");
            WildcardFileFilter filter = new WildcardFileFilter(filePattern);
            for (ChannelSftp.LsEntry entry : fileList) {
                String filename = entry.getFilename();
                if (".".equals(filename) || "..".equals(filename) || !filter.accept(null, entry.getFilename())) continue;
                FileInfo fileInfo = new FileInfo(entry.getFilename(), entry.getAttrs().getSize(), (long)entry.getAttrs().getMTime() * 1000L, entry.getAttrs().isDir());
                fileInfoList.add(fileInfo);
            }
        }
        catch (JSchException | SftpException e) {
            log.error("\u5217\u51faSFTP\u6587\u4ef6\u5931\u8d25", e);
        }
        finally {
            if (connectionMap != null) {
                FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
            }
        }
        return fileInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean downloadFtpFile(FtpConfig config, String remoteFileName, String localFilePath) {
        FTPClient ftpClient = null;
        try {
            boolean bl;
            Throwable throwable;
            BufferedOutputStream outputStream;
            block25: {
                block26: {
                    block22: {
                        boolean bl2;
                        block23: {
                            block24: {
                                ftpClient = FtpUtils.connectFtp((FtpConfig)config);
                                File localFile = new File(localFilePath);
                                File parentDir = localFile.getParentFile();
                                if (parentDir != null && !parentDir.exists()) {
                                    parentDir.mkdirs();
                                }
                                outputStream = new BufferedOutputStream(new FileOutputStream(localFile));
                                throwable = null;
                                boolean success = ftpClient.retrieveFile(remoteFileName, (OutputStream)outputStream);
                                if (!success) break block22;
                                log.info("\u6210\u529f\u4eceFTP\u4e0b\u8f7d\u6587\u4ef6: {} \u5230 {}", (Object)remoteFileName, (Object)localFilePath);
                                bl2 = true;
                                if (outputStream == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    ((OutputStream)outputStream).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            ((OutputStream)outputStream).close();
                        }
                        return bl2;
                    }
                    log.error("\u4eceFTP\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25: {}", (Object)remoteFileName);
                    bl = false;
                    if (outputStream == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                ((OutputStream)outputStream).close();
            }
            return bl;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outputStream).close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                ((OutputStream)outputStream).close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (IOException e) {
                    log.error("\u4eceFTP\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadSftpFile(FtpConfig config, String remoteFileName, String localFilePath) {
        Map connectionMap = null;
        try {
            connectionMap = FtpUtils.connectSftp((FtpConfig)config);
            ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
            File localFile = new File(localFilePath);
            File parentDir = localFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            channelSftp.get(remoteFileName, localFilePath);
            log.info("\u6210\u529f\u4eceSFTP\u4e0b\u8f7d\u6587\u4ef6: {} \u5230 {}", (Object)remoteFileName, (Object)localFilePath);
            boolean bl = true;
            return bl;
        }
        catch (JSchException | SftpException e) {
            log.error("\u4eceSFTP\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connectionMap != null) {
                FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean uploadFtpFile(FtpConfig config, String localFilePath, String remoteFileName) {
        FTPClient ftpClient = null;
        try {
            boolean bl;
            Throwable throwable;
            BufferedInputStream inputStream;
            block24: {
                block25: {
                    block21: {
                        boolean bl2;
                        block22: {
                            block23: {
                                ftpClient = FtpUtils.connectFtp((FtpConfig)config);
                                inputStream = new BufferedInputStream(new FileInputStream(localFilePath));
                                throwable = null;
                                boolean success = ftpClient.storeFile(remoteFileName, (InputStream)inputStream);
                                if (!success) break block21;
                                log.info("\u6210\u529f\u4e0a\u4f20\u6587\u4ef6\u5230FTP: {} \u5230 {}", (Object)localFilePath, (Object)remoteFileName);
                                bl2 = true;
                                if (inputStream == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            ((InputStream)inputStream).close();
                        }
                        return bl2;
                    }
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5230FTP\u5931\u8d25: {}", (Object)localFilePath);
                    bl = false;
                    if (inputStream == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block24;
                }
                ((InputStream)inputStream).close();
            }
            return bl;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                ((InputStream)inputStream).close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (IOException e) {
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5230FTP\u5931\u8d25", (Throwable)e);
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadSftpFile(FtpConfig config, String localFilePath, String remoteFileName) {
        Map connectionMap = null;
        try {
            connectionMap = FtpUtils.connectSftp((FtpConfig)config);
            ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
            channelSftp.put(localFilePath, remoteFileName);
            log.info("\u6210\u529f\u4e0a\u4f20\u6587\u4ef6\u5230SFTP: {} \u5230 {}", (Object)localFilePath, (Object)remoteFileName);
            boolean bl = true;
            return bl;
        }
        catch (JSchException | SftpException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230SFTP\u5931\u8d25", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connectionMap != null) {
                FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFtpFile(FtpConfig config, String remoteFileName) {
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            boolean success = ftpClient.deleteFile(remoteFileName);
            if (success) {
                log.info("\u6210\u529f\u4eceFTP\u5220\u9664\u6587\u4ef6: {}", (Object)remoteFileName);
                boolean bl = true;
                return bl;
            }
            log.error("\u4eceFTP\u5220\u9664\u6587\u4ef6\u5931\u8d25: {}", (Object)remoteFileName);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("\u4eceFTP\u5220\u9664\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteSftpFile(FtpConfig config, String remoteFileName) {
        Map connectionMap = null;
        try {
            connectionMap = FtpUtils.connectSftp((FtpConfig)config);
            ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
            channelSftp.rm(remoteFileName);
            log.info("\u6210\u529f\u4eceSFTP\u5220\u9664\u6587\u4ef6: {}", (Object)remoteFileName);
            boolean bl = true;
            return bl;
        }
        catch (JSchException | SftpException e) {
            log.error("\u4eceSFTP\u5220\u9664\u6587\u4ef6\u5931\u8d25", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connectionMap != null) {
                FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createFtpDirectory(FtpConfig config, String directoryName) {
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            boolean success = ftpClient.makeDirectory(directoryName);
            if (success) {
                log.info("\u6210\u529f\u5728FTP\u521b\u5efa\u76ee\u5f55: {}", (Object)directoryName);
                boolean bl = true;
                return bl;
            }
            log.error("\u5728FTP\u521b\u5efa\u76ee\u5f55\u5931\u8d25: {}", (Object)directoryName);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("\u5728FTP\u521b\u5efa\u76ee\u5f55\u5931\u8d25", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSftpDirectory(FtpConfig config, String directoryName) {
        Map connectionMap = null;
        try {
            connectionMap = FtpUtils.connectSftp((FtpConfig)config);
            ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
            channelSftp.mkdir(directoryName);
            log.info("\u6210\u529f\u5728SFTP\u521b\u5efa\u76ee\u5f55: {}", (Object)directoryName);
            boolean bl = true;
            return bl;
        }
        catch (JSchException | SftpException e) {
            log.error("\u5728SFTP\u521b\u5efa\u76ee\u5f55\u5931\u8d25", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connectionMap != null) {
                FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String downloadFtpFileToString(FtpConfig config, String remoteFileName) {
        FTPClient ftpClient = null;
        try {
            String string;
            Throwable throwable;
            InputStream inputStream;
            block24: {
                block25: {
                    block21: {
                        String string2;
                        block22: {
                            block23: {
                                ftpClient = FtpUtils.connectFtp((FtpConfig)config);
                                inputStream = ftpClient.retrieveFileStream(remoteFileName);
                                throwable = null;
                                if (inputStream != null) break block21;
                                log.error("\u4eceFTP\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25: {}", (Object)remoteFileName);
                                string2 = null;
                                if (inputStream == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            inputStream.close();
                        }
                        return string2;
                    }
                    string = IOUtils.toString((InputStream)inputStream, (String)config.getEncoding());
                    if (inputStream == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block24;
                }
                inputStream.close();
            }
            return string;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (IOException e) {
                    log.error("\u4eceFTP\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String downloadSftpFileToString(FtpConfig config, String remoteFileName) {
        Map connectionMap = null;
        try {
            String string;
            Throwable throwable;
            InputStream inputStream;
            block18: {
                block19: {
                    connectionMap = FtpUtils.connectSftp((FtpConfig)config);
                    ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
                    inputStream = channelSftp.get(remoteFileName);
                    throwable = null;
                    string = IOUtils.toString((InputStream)inputStream, (String)config.getEncoding());
                    if (inputStream == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                inputStream.close();
            }
            return string;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (JSchException | SftpException | IOException e) {
                    log.error("\u4eceSFTP\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", e);
                    String string2 = null;
                    return string2;
                }
            }
        }
        finally {
            if (connectionMap != null) {
                FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean uploadStringToFtpFile(FtpConfig config, String content, String remoteFileName) {
        FTPClient ftpClient = null;
        try {
            boolean bl;
            Throwable throwable;
            InputStream inputStream;
            block24: {
                block25: {
                    block21: {
                        boolean bl2;
                        block22: {
                            block23: {
                                ftpClient = FtpUtils.connectFtp((FtpConfig)config);
                                inputStream = IOUtils.toInputStream((String)content, (String)config.getEncoding());
                                throwable = null;
                                boolean success = ftpClient.storeFile(remoteFileName, inputStream);
                                if (!success) break block21;
                                log.info("\u6210\u529f\u4e0a\u4f20\u5185\u5bb9\u5230FTP\u6587\u4ef6: {}", (Object)remoteFileName);
                                bl2 = true;
                                if (inputStream == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            inputStream.close();
                        }
                        return bl2;
                    }
                    log.error("\u4e0a\u4f20\u5185\u5bb9\u5230FTP\u6587\u4ef6\u5931\u8d25: {}", (Object)remoteFileName);
                    bl = false;
                    if (inputStream == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block24;
                }
                inputStream.close();
            }
            return bl;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (IOException e) {
                    log.error("\u4e0a\u4f20\u5185\u5bb9\u5230FTP\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean uploadStringToSftpFile(FtpConfig config, String content, String remoteFileName) {
        Map connectionMap = null;
        try {
            boolean bl;
            Throwable throwable;
            InputStream inputStream;
            block18: {
                block19: {
                    connectionMap = FtpUtils.connectSftp((FtpConfig)config);
                    ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
                    inputStream = IOUtils.toInputStream((String)content, (String)config.getEncoding());
                    throwable = null;
                    channelSftp.put(inputStream, remoteFileName);
                    log.info("\u6210\u529f\u4e0a\u4f20\u5185\u5bb9\u5230SFTP\u6587\u4ef6: {}", (Object)remoteFileName);
                    bl = true;
                    if (inputStream == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                inputStream.close();
            }
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (JSchException | SftpException | IOException e) {
                    log.error("\u4e0a\u4f20\u5185\u5bb9\u5230SFTP\u6587\u4ef6\u5931\u8d25", e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
        }
        finally {
            if (connectionMap != null) {
                FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
            }
        }
    }

    public static List<FileInfo> listFiles(FtpConfig config, String filePattern) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            return FtpUtils.listSftpFiles((FtpConfig)config, (String)filePattern);
        }
        return FtpUtils.listFtpFiles((FtpConfig)config, (String)filePattern);
    }

    public static boolean downloadFile(FtpConfig config, String remoteFileName, String localFilePath) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            return FtpUtils.downloadSftpFile((FtpConfig)config, (String)remoteFileName, (String)localFilePath);
        }
        return FtpUtils.downloadFtpFile((FtpConfig)config, (String)remoteFileName, (String)localFilePath);
    }

    public static boolean uploadFile(FtpConfig config, String localFilePath, String remoteFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            return FtpUtils.uploadSftpFile((FtpConfig)config, (String)localFilePath, (String)remoteFileName);
        }
        return FtpUtils.uploadFtpFile((FtpConfig)config, (String)localFilePath, (String)remoteFileName);
    }

    public static boolean deleteFile(FtpConfig config, String remoteFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            return FtpUtils.deleteSftpFile((FtpConfig)config, (String)remoteFileName);
        }
        return FtpUtils.deleteFtpFile((FtpConfig)config, (String)remoteFileName);
    }

    public static boolean createDirectory(FtpConfig config, String directoryName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            return FtpUtils.createSftpDirectory((FtpConfig)config, (String)directoryName);
        }
        return FtpUtils.createFtpDirectory((FtpConfig)config, (String)directoryName);
    }

    public static String downloadFileToString(FtpConfig config, String remoteFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            return FtpUtils.downloadSftpFileToString((FtpConfig)config, (String)remoteFileName);
        }
        return FtpUtils.downloadFtpFileToString((FtpConfig)config, (String)remoteFileName);
    }

    public static boolean uploadStringToFile(FtpConfig config, String content, String remoteFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            return FtpUtils.uploadStringToSftpFile((FtpConfig)config, (String)content, (String)remoteFileName);
        }
        return FtpUtils.uploadStringToFtpFile((FtpConfig)config, (String)content, (String)remoteFileName);
    }

    public static List<String> downloadFiles(FtpConfig config, String filePattern, String localDir) {
        ArrayList<String> downloadedFiles = new ArrayList<String>();
        File dir = new File(localDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        List fileInfoList = FtpUtils.listFiles((FtpConfig)config, (String)filePattern);
        for (FileInfo fileInfo : fileInfoList) {
            if (fileInfo.isDirectory()) continue;
            String localFilePath = localDir + File.separator + fileInfo.getName();
            boolean success = FtpUtils.downloadFile((FtpConfig)config, (String)fileInfo.getName(), (String)localFilePath);
            if (!success) continue;
            downloadedFiles.add(localFilePath);
        }
        return downloadedFiles;
    }

    public static List<String> downloadFilesSkipProcessed(FtpConfig config, String filePattern, String localDir, String processedRecordFile) {
        ArrayList<String> downloadedFiles = new ArrayList<String>();
        File dir = new File(localDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Set processedFiles = FtpUtils.loadProcessedFileRecords((String)processedRecordFile);
        log.info("\u5df2\u52a0\u8f7d {} \u4e2a\u5df2\u5904\u7406\u6587\u4ef6\u8bb0\u5f55", (Object)processedFiles.size());
        List fileInfoList = FtpUtils.listFiles((FtpConfig)config, (String)filePattern);
        HashSet<String> newProcessedFiles = new HashSet<String>();
        for (FileInfo fileInfo : fileInfoList) {
            if (fileInfo.isDirectory()) continue;
            String fileKey = fileInfo.getName() + ":" + fileInfo.getChecksum();
            if (!processedFiles.contains(fileKey)) {
                String localFilePath = localDir + File.separator + fileInfo.getName();
                boolean success = FtpUtils.downloadFile((FtpConfig)config, (String)fileInfo.getName(), (String)localFilePath);
                if (!success) continue;
                downloadedFiles.add(localFilePath);
                newProcessedFiles.add(fileKey);
                continue;
            }
            log.info("\u8df3\u8fc7\u5df2\u5904\u7406\u7684\u6587\u4ef6: {}", (Object)fileInfo.getName());
        }
        if (!newProcessedFiles.isEmpty()) {
            FtpUtils.saveProcessedFileRecords((String)processedRecordFile, (Set)processedFiles, newProcessedFiles);
            log.info("\u5df2\u66f4\u65b0\u5904\u7406\u8bb0\u5f55\u6587\u4ef6\uff0c\u65b0\u589e {} \u6761\u8bb0\u5f55", (Object)newProcessedFiles.size());
        }
        return downloadedFiles;
    }

    private static Set<String> loadProcessedFileRecords(String recordFilePath) {
        HashSet<String> processedFiles = new HashSet<String>();
        File recordFile = new File(recordFilePath);
        if (!recordFile.exists()) {
            try {
                recordFile.getParentFile().mkdirs();
                recordFile.createNewFile();
            }
            catch (IOException e) {
                log.error("\u521b\u5efa\u5904\u7406\u8bb0\u5f55\u6587\u4ef6\u5931\u8d25: {}", (Object)recordFilePath, (Object)e);
            }
            return processedFiles;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(recordFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                processedFiles.add(line.trim());
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u5904\u7406\u8bb0\u5f55\u6587\u4ef6\u5931\u8d25: {}", (Object)recordFilePath, (Object)e);
        }
        return processedFiles;
    }

    private static void saveProcessedFileRecords(String recordFilePath, Set<String> existingRecords, Set<String> newRecords) {
        HashSet<String> allRecords = new HashSet<String>(existingRecords);
        allRecords.addAll(newRecords);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(recordFilePath));){
            for (String record : allRecords) {
                writer.write(record);
                writer.newLine();
            }
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u5904\u7406\u8bb0\u5f55\u6587\u4ef6\u5931\u8d25: {}", (Object)recordFilePath, (Object)e);
        }
    }

    public static FtpConfig createConfigFromString(String configStr) {
        String[] pairs;
        FtpConfig config = new FtpConfig();
        if (configStr == null || configStr.trim().isEmpty()) {
            return config;
        }
        block30: for (String pair : pairs = configStr.split(",")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            switch (key) {
                case "protocol": {
                    config.setProtocol(value);
                    continue block30;
                }
                case "host": {
                    config.setHost(value);
                    continue block30;
                }
                case "port": {
                    try {
                        config.setPort(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u65e0\u6548\u7684\u7aef\u53e3\u53f7: {}", (Object)value);
                    }
                    continue block30;
                }
                case "username": {
                    config.setUsername(value);
                    continue block30;
                }
                case "password": {
                    config.setPassword(value);
                    continue block30;
                }
                case "remotePath": {
                    config.setRemotePath(value);
                    continue block30;
                }
                case "connectTimeout": {
                    try {
                        config.setConnectTimeout(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u65e0\u6548\u7684\u8fde\u63a5\u8d85\u65f6: {}", (Object)value);
                    }
                    continue block30;
                }
                case "dataTimeout": {
                    try {
                        config.setDataTimeout(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u65e0\u6548\u7684\u6570\u636e\u8d85\u65f6: {}", (Object)value);
                    }
                    continue block30;
                }
                case "passiveMode": {
                    config.setPassiveMode(Boolean.parseBoolean(value));
                    continue block30;
                }
                case "encoding": {
                    config.setEncoding(value);
                    continue block30;
                }
                default: {
                    log.warn("\u672a\u77e5\u7684\u914d\u7f6e\u9879: {}", (Object)key);
                }
            }
        }
        if (config.getPort() == 0) {
            if ("sftp".equalsIgnoreCase(config.getProtocol())) {
                config.setPort(22);
            } else {
                config.setPort(21);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnection(FtpConfig config) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            Map connectionMap = null;
            try {
                connectionMap = FtpUtils.connectSftp((FtpConfig)config);
                log.info("SFTP\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f: {}@{}:{}", new Object[]{config.getUsername(), config.getHost(), config.getPort()});
                boolean bl = true;
                return bl;
            }
            catch (JSchException e) {
                log.error("SFTP\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25: {}@{}:{}", new Object[]{config.getUsername(), config.getHost(), config.getPort(), e});
                boolean bl = false;
                return bl;
            }
            finally {
                if (connectionMap != null) {
                    FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
                }
            }
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            log.debug("FTP\u8fde\u63a5\u6d4b\u8bd5\u6210\u529f: {}@{}:{}", new Object[]{config.getUsername(), config.getHost(), config.getPort()});
            boolean e = true;
            return e;
        }
        catch (IOException e) {
            log.error("FTP\u8fde\u63a5\u6d4b\u8bd5\u5931\u8d25: {}@{}:{}", new Object[]{config.getUsername(), config.getHost(), config.getPort(), e});
            boolean bl = false;
            return bl;
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSize(FtpConfig config, String remoteFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            Map connectionMap = null;
            try {
                connectionMap = FtpUtils.connectSftp((FtpConfig)config);
                ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
                SftpATTRS attrs = channelSftp.stat(remoteFileName);
                long l = attrs.getSize();
                return l;
            }
            catch (JSchException | SftpException e) {
                log.error("\u83b7\u53d6SFTP\u6587\u4ef6\u5927\u5c0f\u5931\u8d25: {}", (Object)remoteFileName, (Object)e);
                long l = -1L;
                return l;
            }
            finally {
                if (connectionMap != null) {
                    FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
                }
            }
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            FTPFile[] files = ftpClient.listFiles(remoteFileName);
            if (files.length == 1) {
                long l = files[0].getSize();
                return l;
            }
            log.error("FTP\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u6709\u591a\u4e2a\u5339\u914d: {}", (Object)remoteFileName);
            long l = -1L;
            return l;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6FTP\u6587\u4ef6\u5927\u5c0f\u5931\u8d25: {}", (Object)remoteFileName, (Object)e);
            long l = -1L;
            return l;
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileExists(FtpConfig config, String remoteFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            Map connectionMap = null;
            try {
                connectionMap = FtpUtils.connectSftp((FtpConfig)config);
                ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
                try {
                    channelSftp.stat(remoteFileName);
                    boolean bl = true;
                    return bl;
                }
                catch (SftpException e) {
                    block16: {
                        boolean bl;
                        block17: {
                            if (e.id != 2) break block16;
                            bl = false;
                            if (connectionMap == null) break block17;
                            FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
                        }
                        return bl;
                    }
                    try {
                        throw e;
                    }
                    catch (JSchException | SftpException e2) {
                        log.error("\u68c0\u67e5SFTP\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25: {}", (Object)remoteFileName, (Object)e2);
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            finally {
                if (connectionMap != null) {
                    FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
                }
            }
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            FTPFile[] files = ftpClient.listFiles(remoteFileName);
            boolean bl = files.length > 0;
            return bl;
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5FTP\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25: {}", (Object)remoteFileName, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameFile(FtpConfig config, String oldFileName, String newFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            Map connectionMap = null;
            try {
                connectionMap = FtpUtils.connectSftp((FtpConfig)config);
                ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
                channelSftp.rename(oldFileName, newFileName);
                log.info("\u6210\u529f\u91cd\u547d\u540dSFTP\u6587\u4ef6: {} -> {}", (Object)oldFileName, (Object)newFileName);
                boolean bl = true;
                return bl;
            }
            catch (JSchException | SftpException e) {
                log.error("\u91cd\u547d\u540dSFTP\u6587\u4ef6\u5931\u8d25: {} -> {}", new Object[]{oldFileName, newFileName, e});
                boolean bl = false;
                return bl;
            }
            finally {
                if (connectionMap != null) {
                    FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
                }
            }
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            boolean success = ftpClient.rename(oldFileName, newFileName);
            if (success) {
                log.info("\u6210\u529f\u91cd\u547d\u540dFTP\u6587\u4ef6: {} -> {}", (Object)oldFileName, (Object)newFileName);
                boolean bl = true;
                return bl;
            }
            log.error("\u91cd\u547d\u540dFTP\u6587\u4ef6\u5931\u8d25: {} -> {}", (Object)oldFileName, (Object)newFileName);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("\u91cd\u547d\u540dFTP\u6587\u4ef6\u5931\u8d25: {} -> {}", new Object[]{oldFileName, newFileName, e});
            boolean bl = false;
            return bl;
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    public static boolean moveFile(FtpConfig config, String sourceFileName, String targetDirectory) {
        String fileName = new File(sourceFileName).getName();
        String targetFileName = targetDirectory;
        if (!targetDirectory.endsWith("/")) {
            targetFileName = targetFileName + "/";
        }
        targetFileName = targetFileName + fileName;
        return FtpUtils.renameFile((FtpConfig)config, (String)sourceFileName, (String)targetFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModifiedTime(FtpConfig config, String remoteFileName) {
        if ("sftp".equalsIgnoreCase(config.getProtocol())) {
            Map connectionMap = null;
            try {
                connectionMap = FtpUtils.connectSftp((FtpConfig)config);
                ChannelSftp channelSftp = (ChannelSftp)connectionMap.get("channel");
                SftpATTRS attrs = channelSftp.stat(remoteFileName);
                long l = (long)attrs.getMTime() * 1000L;
                return l;
            }
            catch (JSchException | SftpException e) {
                log.error("\u83b7\u53d6SFTP\u6587\u4ef6\u4fee\u6539\u65f6\u95f4\u5931\u8d25: {}", (Object)remoteFileName, (Object)e);
                long l = -1L;
                return l;
            }
            finally {
                if (connectionMap != null) {
                    FtpUtils.disconnectSftp((ChannelSftp)((ChannelSftp)connectionMap.get("channel")), (Session)((Session)connectionMap.get("session")));
                }
            }
        }
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtils.connectFtp((FtpConfig)config);
            FTPFile[] files = ftpClient.listFiles(remoteFileName);
            if (files.length == 1 && files[0].getTimestamp() != null) {
                long l = files[0].getTimestamp().getTimeInMillis();
                return l;
            }
            log.error("FTP\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u6709\u591a\u4e2a\u5339\u914d: {}", (Object)remoteFileName);
            long l = -1L;
            return l;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6FTP\u6587\u4ef6\u4fee\u6539\u65f6\u95f4\u5931\u8d25: {}", (Object)remoteFileName, (Object)e);
            long l = -1L;
            return l;
        }
        finally {
            FtpUtils.disconnectFtp((FTPClient)ftpClient);
        }
    }

    public static List<FileInfo> listFilesRecursively(FtpConfig config, String filePattern) {
        ArrayList<FileInfo> allFiles = new ArrayList<FileInfo>();
        FtpUtils.listFilesRecursively((FtpConfig)config, (String)filePattern, allFiles, (String)"");
        return allFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listFilesRecursively(FtpConfig config, String filePattern, List<FileInfo> allFiles, String subPath) {
        String originalPath = config.getRemotePath();
        try {
            String currentPath = originalPath;
            if (!subPath.isEmpty()) {
                currentPath = originalPath + (originalPath.endsWith("/") ? "" : "/") + subPath;
            }
            config.setRemotePath(currentPath);
            List entries = FtpUtils.listFiles((FtpConfig)config, (String)"*");
            WildcardFileFilter filter = new WildcardFileFilter(filePattern);
            List matchingFiles = entries.stream().filter(entry -> !entry.isDirectory()).filter(entry -> filter.accept(null, entry.getName())).collect(Collectors.toList());
            for (FileInfo file : matchingFiles) {
                file.setSubPath(subPath);
            }
            allFiles.addAll(matchingFiles);
            List directories = entries.stream().filter(FileInfo::isDirectory).collect(Collectors.toList());
            for (FileInfo dir : directories) {
                String newSubPath = subPath.isEmpty() ? dir.getName() : subPath + "/" + dir.getName();
                FtpUtils.listFilesRecursively((FtpConfig)config, (String)filePattern, allFiles, (String)newSubPath);
            }
        }
        catch (Exception e) {
            log.error("\u9012\u5f52\u5217\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u8def\u5f84: {}", (Object)config.getRemotePath(), (Object)e);
        }
        finally {
            config.setRemotePath(originalPath);
        }
    }
}

